/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraft.world.ticks.TickListChunk;
import org.bukkit.craftbukkit.v1_21_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R3.persistence.DirtyCraftPersistentDataContainer;
import org.slf4j.Logger;

public abstract class IChunkAccess
implements BiomeManager.Provider,
LightChunk,
StructureAccess,
StarlightChunk {
    public static final int a = -1;
    private static final Logger n = LogUtils.getLogger();
    private static final LongSet o = new LongOpenHashSet();
    protected final ShortList[] b;
    private volatile boolean p;
    private volatile boolean q;
    protected final ChunkCoordIntPair c;
    public final long coordinateKey;
    public final int locX;
    public final int locZ;
    private long r;
    @Nullable
    @Deprecated
    private BiomeSettingsGeneration s;
    @Nullable
    protected NoiseChunk d;
    protected final ChunkConverter e;
    @Nullable
    protected BlendingData f;
    public final Map<HeightMap.Type, HeightMap> h = Maps.newEnumMap(HeightMap.Type.class);
    private final Map<Structure, StructureStart> t = Maps.newHashMap();
    private final Map<Structure, LongSet> u = Maps.newHashMap();
    protected final Map<BlockPosition, NBTTagCompound> j = Maps.newHashMap();
    public final Map<BlockPosition, TileEntity> k = new Object2ObjectOpenHashMap();
    protected final LevelHeightAccessor l;
    protected final ChunkSection[] m;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public DirtyCraftPersistentDataContainer persistentDataContainer = new DirtyCraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    public final IRegistry<BiomeBase> biomeRegistry;
    private volatile SWMRNibbleArray[] blockNibbles;
    private volatile SWMRNibbleArray[] skyNibbles;
    private volatile boolean[] skyEmptinessMap;
    private volatile boolean[] blockEmptinessMap;
    private final int minSection;
    private final int maxSection;

    @Override
    public SWMRNibbleArray[] starlight$getBlockNibbles() {
        return this.blockNibbles;
    }

    @Override
    public void starlight$setBlockNibbles(SWMRNibbleArray[] nibbles) {
        this.blockNibbles = nibbles;
    }

    @Override
    public SWMRNibbleArray[] starlight$getSkyNibbles() {
        return this.skyNibbles;
    }

    @Override
    public void starlight$setSkyNibbles(SWMRNibbleArray[] nibbles) {
        this.skyNibbles = nibbles;
    }

    @Override
    public boolean[] starlight$getSkyEmptinessMap() {
        return this.skyEmptinessMap;
    }

    @Override
    public void starlight$setSkyEmptinessMap(boolean[] emptinessMap) {
        this.skyEmptinessMap = emptinessMap;
    }

    @Override
    public boolean[] starlight$getBlockEmptinessMap() {
        return this.blockEmptinessMap;
    }

    @Override
    public void starlight$setBlockEmptinessMap(boolean[] emptinessMap) {
        this.blockEmptinessMap = emptinessMap;
    }

    public IChunkAccess(ChunkCoordIntPair chunkPos, ChunkConverter upgradeData, LevelHeightAccessor levelHeightAccessor, IRegistry<BiomeBase> biomeRegistry, long inhabitedTime, @Nullable ChunkSection[] sections, @Nullable BlendingData blendingData) {
        this.locX = chunkPos.h;
        this.locZ = chunkPos.i;
        this.c = chunkPos;
        this.coordinateKey = ChunkCoordIntPair.c(this.locX, this.locZ);
        this.e = upgradeData;
        this.l = levelHeightAccessor;
        this.m = new ChunkSection[levelHeightAccessor.ao()];
        this.r = inhabitedTime;
        this.b = new ShortList[levelHeightAccessor.ao()];
        this.f = blendingData;
        if (sections != null) {
            if (this.m.length == sections.length) {
                System.arraycopy(sections, 0, this.m, 0, this.m.length);
            } else {
                n.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)sections.length, (Object)this.m.length);
            }
        }
        this.a(biomeRegistry, this.m);
        this.biomeRegistry = biomeRegistry;
        if (!(this instanceof ProtoChunkExtension)) {
            this.starlight$setBlockNibbles(StarLightEngine.getFilledEmptyLight(levelHeightAccessor));
            this.starlight$setSkyNibbles(StarLightEngine.getFilledEmptyLight(levelHeightAccessor));
        }
        this.minSection = WorldUtil.getMinSection(levelHeightAccessor);
        this.maxSection = WorldUtil.getMaxSection(levelHeightAccessor);
    }

    private void a(IRegistry<BiomeBase> biomeRegistry, ChunkSection[] sections) {
        for (int i2 = 0; i2 < sections.length; ++i2) {
            if (sections[i2] != null) continue;
            sections[i2] = new ChunkSection(biomeRegistry, this.l instanceof World ? (World)this.l : null, this.c, this.l.h(i2));
        }
    }

    public GameEventListenerRegistry a(int sectionY) {
        return GameEventListenerRegistry.a;
    }

    public abstract IBlockData getBlockState(int var1, int var2, int var3);

    @Nullable
    public abstract IBlockData a(BlockPosition var1, IBlockData var2, boolean var3);

    public abstract void a(TileEntity var1);

    public abstract void a(Entity var1);

    public int a() {
        ChunkSection[] sections = this.d();
        for (int i2 = sections.length - 1; i2 >= 0; --i2) {
            ChunkSection levelChunkSection = sections[i2];
            if (levelChunkSection.c()) continue;
            return i2;
        }
        return -1;
    }

    @Deprecated(forRemoval=true)
    public int b() {
        int highestFilledSectionIndex = this.a();
        return highestFilledSectionIndex == -1 ? this.L_() : SectionPosition.c(this.h(highestFilledSectionIndex));
    }

    public Set<BlockPosition> c() {
        HashSet set = Sets.newHashSet(this.j.keySet());
        set.addAll(this.k.keySet());
        return set;
    }

    public ChunkSection[] d() {
        return this.m;
    }

    public ChunkSection b(int index) {
        return this.d()[index];
    }

    public Collection<Map.Entry<HeightMap.Type, HeightMap>> e() {
        return Collections.unmodifiableSet(this.h.entrySet());
    }

    public void a(HeightMap.Type type, long[] data) {
        this.a(type).a(this, type, data);
    }

    public HeightMap a(HeightMap.Type type) {
        return this.h.computeIfAbsent(type, absentType -> new HeightMap(this, (HeightMap.Type)absentType));
    }

    public boolean b(HeightMap.Type type) {
        return this.h.get(type) != null;
    }

    public int a(HeightMap.Type type, int x2, int z2) {
        HeightMap heightmap = this.h.get(type);
        if (heightmap == null) {
            if (SharedConstants.aU && this instanceof Chunk) {
                n.error("Unprimed heightmap: " + String.valueOf(type) + " " + x2 + " " + z2);
            }
            HeightMap.a(this, EnumSet.of(type));
            heightmap = this.h.get(type);
        }
        return heightmap.a(x2 & 0xF, z2 & 0xF) - 1;
    }

    public ChunkCoordIntPair f() {
        return this.c;
    }

    @Override
    @Nullable
    public StructureStart a(Structure structure) {
        return this.t.get(structure);
    }

    @Override
    public void a(Structure structure, StructureStart structureStart) {
        this.t.put(structure, structureStart);
        this.i();
    }

    public Map<Structure, StructureStart> g() {
        return Collections.unmodifiableMap(this.t);
    }

    public void a(Map<Structure, StructureStart> structureStarts) {
        this.t.clear();
        this.t.putAll(structureStarts);
        this.i();
    }

    @Override
    public LongSet b(Structure structure) {
        return this.u.getOrDefault(structure, o);
    }

    @Override
    public void a(Structure structure, long reference) {
        this.u.computeIfAbsent(structure, key -> new LongOpenHashSet()).add(reference);
        this.i();
    }

    @Override
    public Map<Structure, LongSet> h() {
        return Collections.unmodifiableMap(this.u);
    }

    @Override
    public void b(Map<Structure, LongSet> structureReferencesMap) {
        this.u.clear();
        this.u.putAll(structureReferencesMap);
        this.i();
    }

    public boolean a(int startY, int endY) {
        if (startY < this.L_()) {
            startY = this.L_();
        }
        if (endY > this.an()) {
            endY = this.an();
        }
        for (int i2 = startY; i2 <= endY; i2 += 16) {
            if (this.b(this.f(i2)).c()) continue;
            return false;
        }
        return true;
    }

    public boolean c(int y2) {
        return this.b(this.g(y2)).c();
    }

    public void i() {
        this.p = true;
    }

    public boolean j() {
        if (this.p) {
            this.p = false;
            this.persistentDataContainer.dirty(false);
            return true;
        }
        return false;
    }

    public boolean k() {
        return this.p || this.persistentDataContainer.dirty();
    }

    public abstract ChunkStatus n();

    public ChunkStatus o() {
        ChunkStatus persistedStatus = this.n();
        BelowZeroRetrogen belowZeroRetrogen = this.z();
        if (belowZeroRetrogen != null) {
            ChunkStatus chunkStatus = belowZeroRetrogen.a();
            return ChunkStatus.a(chunkStatus, persistedStatus);
        }
        return persistedStatus;
    }

    public abstract void d(BlockPosition var1);

    public void e(BlockPosition pos) {
        n.warn("Trying to mark a block for PostProcessing @ {}, but this operation is not supported.", (Object)pos);
    }

    public ShortList[] p() {
        return this.b;
    }

    public void a(ShortList offsets, int index) {
        IChunkAccess.a(this.p(), index).addAll(offsets);
    }

    public void a(NBTTagCompound tag) {
        BlockPosition posFromTag = TileEntity.b(tag);
        if (!this.k.containsKey(posFromTag)) {
            this.j.put(posFromTag, tag);
        }
    }

    @Nullable
    public NBTTagCompound f(BlockPosition pos) {
        return this.j.get(pos);
    }

    @Nullable
    public abstract NBTTagCompound a(BlockPosition var1, HolderLookup.a var2);

    @Override
    public final void a(BiConsumer<BlockPosition, IBlockData> output) {
        this.a((IBlockData state) -> state.k() != 0, output);
    }

    public void a(Predicate<IBlockData> predicate, BiConsumer<BlockPosition, IBlockData> output) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int sectionY = this.ap(); sectionY <= this.aq(); ++sectionY) {
            ChunkSection section = this.b(this.g(sectionY));
            if (!section.a(predicate)) continue;
            BlockPosition blockPos = SectionPosition.a(this.c, sectionY).j();
            for (int i2 = 0; i2 < 16; ++i2) {
                for (int i1 = 0; i1 < 16; ++i1) {
                    for (int i22 = 0; i22 < 16; ++i22) {
                        IBlockData blockState = section.a(i22, i2, i1);
                        if (!predicate.test(blockState)) continue;
                        output.accept(mutableBlockPos.a(blockPos, i22, i2, i1), blockState);
                    }
                }
            }
        }
    }

    public abstract TickContainerAccess<Block> q();

    public abstract TickContainerAccess<FluidType> r();

    public boolean s() {
        return true;
    }

    public abstract a a(long var1);

    public ChunkConverter t() {
        return this.e;
    }

    public boolean u() {
        return this.f != null;
    }

    @Nullable
    public BlendingData v() {
        return this.f;
    }

    public long w() {
        return this.r;
    }

    public void b(long amount) {
        this.r += amount;
    }

    public void c(long inhabitedTime) {
        this.r = inhabitedTime;
    }

    public static ShortList a(ShortList[] packedPositions, int index) {
        if (packedPositions[index] == null) {
            packedPositions[index] = new ShortArrayList();
        }
        return packedPositions[index];
    }

    public boolean x() {
        return this.q;
    }

    public void a(boolean lightCorrect) {
        this.q = lightCorrect;
        this.i();
    }

    @Override
    public int L_() {
        return this.l.L_();
    }

    @Override
    public int M_() {
        return this.l.M_();
    }

    public NoiseChunk a(Function<IChunkAccess, NoiseChunk> noiseChunkCreator) {
        if (this.d == null) {
            this.d = noiseChunkCreator.apply(this);
        }
        return this.d;
    }

    @Deprecated
    public BiomeSettingsGeneration a(Supplier<BiomeSettingsGeneration> caverBiomeSettingsSupplier) {
        if (this.s == null) {
            this.s = caverBiomeSettingsSupplier.get();
        }
        return this.s;
    }

    @Override
    public Holder<BiomeBase> getNoiseBiome(int x2, int y2, int z2) {
        int sectionY = (y2 >> 2) - this.minSection;
        int rel = y2 & 3;
        ChunkSection[] sections = this.m;
        if (sectionY < 0) {
            sectionY = 0;
            rel = 0;
        } else if (sectionY >= sections.length) {
            sectionY = sections.length - 1;
            rel = 3;
        }
        return sections[sectionY].c(x2 & 3, rel, z2 & 3);
    }

    public void setBiome(int x2, int y2, int z2, Holder<BiomeBase> biome) {
        try {
            int minY = QuartPos.a(this.L_());
            int maxY = minY + QuartPos.a(this.M_()) - 1;
            int clampedY = MathHelper.a(y2, minY, maxY);
            int sectionIndex = this.f(QuartPos.c(clampedY));
            this.m[sectionIndex].setBiome(x2 & 3, clampedY & 3, z2 & 3, biome);
        }
        catch (Throwable throwable) {
            CrashReport report = CrashReport.a(throwable, "Setting biome");
            CrashReportSystemDetails reportCategory = report.a("Biome being set");
            reportCategory.a("Location", () -> CrashReportSystemDetails.a((LevelHeightAccessor)this, x2, y2, z2));
            throw new ReportedException(report);
        }
    }

    public void a(BiomeResolver resolver, Climate.Sampler sampler) {
        ChunkCoordIntPair pos = this.f();
        int quartPosMinX = QuartPos.a(pos.d());
        int quartPosMinZ = QuartPos.a(pos.e());
        LevelHeightAccessor heightAccessorForGeneration = this.B();
        for (int sectionY = heightAccessorForGeneration.ap(); sectionY <= heightAccessorForGeneration.aq(); ++sectionY) {
            ChunkSection section = this.b(this.g(sectionY));
            int quartPosY = QuartPos.d(sectionY);
            section.a(resolver, sampler, quartPosMinX, quartPosY, quartPosMinZ);
        }
    }

    public boolean y() {
        return !this.h().isEmpty();
    }

    @Nullable
    public BelowZeroRetrogen z() {
        return null;
    }

    public boolean A() {
        return this.z() != null;
    }

    public LevelHeightAccessor B() {
        return this;
    }

    public void C() {
    }

    @Override
    public ChunkSkyLightSources D() {
        return null;
    }

    public record a(List<TickListChunk<Block>> a, List<TickListChunk<FluidType>> b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blocks;fluids", "a", "b"}, this, o2);
        }
    }
}

