/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.world.StructuresLocateEvent;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_21_R3.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R3.util.RandomSourceWrapper;
import org.bukkit.event.Event;
import org.bukkit.event.world.AsyncStructureSpawnEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.generator.structure.Structure;
import org.bukkit.util.BoundingBox;
import org.spigotmc.SpigotWorldConfig;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> a = BuiltInRegistries.aa.q().dispatchStable(ChunkGenerator::b, Function.identity());
    protected final WorldChunkManager b;
    private final Supplier<List<FeatureSorter.b>> c;
    public final Function<Holder<BiomeBase>, BiomeSettingsGeneration> d;

    public ChunkGenerator(WorldChunkManager biomeSource) {
        this(biomeSource, biome -> ((BiomeBase)biome.a()).d());
    }

    public ChunkGenerator(WorldChunkManager biomeSource, Function<Holder<BiomeBase>, BiomeSettingsGeneration> generationSettingsGetter) {
        this.b = biomeSource;
        this.d = generationSettingsGetter;
        this.c = Suppliers.memoize(() -> FeatureSorter.a(List.copyOf(biomeSource.c()), biome -> ((BiomeSettingsGeneration)generationSettingsGetter.apply((Holder<BiomeBase>)biome)).c(), true));
    }

    public void a() {
        this.c.get();
    }

    protected abstract MapCodec<? extends ChunkGenerator> b();

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> structureSetLookup, RandomState randomState, long seed, SpigotWorldConfig conf) {
        return ChunkGeneratorStructureState.createForNormal(randomState, seed, this.b, structureSetLookup, conf);
    }

    public Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> c() {
        return BuiltInRegistries.aa.d(this.b());
    }

    public CompletableFuture<IChunkAccess> a(RandomState randomState, Blender blender, StructureManager structureManager, IChunkAccess chunk) {
        return CompletableFuture.supplyAsync(() -> {
            chunk.a(this.b, randomState.b());
            return chunk;
        }, Runnable::run);
    }

    public abstract void a(RegionLimitedWorldAccess var1, long var2, RandomState var4, BiomeManager var5, StructureManager var6, IChunkAccess var7);

    @Nullable
    public Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> a(WorldServer level, HolderSet<net.minecraft.world.level.levelgen.structure.Structure> structure, BlockPosition pos, int searchRadius, boolean skipKnownStructures) {
        CraftWorld bukkitWorld = level.getWorld();
        Location origin = MCUtil.toLocation(level, pos);
        List<Structure> apiStructures = structure.a().map(Holder::a).map(nms -> CraftStructure.minecraftToBukkit(nms)).toList();
        if (!apiStructures.isEmpty()) {
            StructuresLocateEvent event = new StructuresLocateEvent((org.bukkit.World)bukkitWorld, origin, apiStructures, searchRadius, skipKnownStructures);
            if (!event.callEvent()) {
                return null;
            }
            if (event.getResult() != null) {
                return Pair.of((Object)MCUtil.toBlockPos(event.getResult().pos()), level.K_().e(Registries.aU).e(CraftStructure.bukkitToMinecraft(event.getResult().structure())));
            }
            pos = MCUtil.toBlockPosition(event.getOrigin());
            searchRadius = event.getRadius();
            skipKnownStructures = event.shouldFindUnexplored();
            structure = HolderSet.a((E api) -> level.K_().e(Registries.aU).e(CraftStructure.bukkitToMinecraft(api)), event.getStructures());
        }
        ChunkGeneratorStructureState generatorState = level.m().h();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Holder holder : structure) {
            for (StructurePlacement structurePlacement : generatorState.a(holder)) {
                map.computeIfAbsent(structurePlacement, key -> new ObjectArraySet()).add(holder);
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> pair = null;
        double d2 = Double.MAX_VALUE;
        StructureManager structureManager = level.b();
        ArrayList list = new ArrayList(map.size());
        for (Map.Entry entry : map.entrySet()) {
            StructurePlacement structurePlacement1 = (StructurePlacement)entry.getKey();
            if (structurePlacement1 instanceof ConcentricRingsStructurePlacement) {
                BlockPosition blockPosition;
                double d1;
                ConcentricRingsStructurePlacement concentricRingsStructurePlacement = (ConcentricRingsStructurePlacement)structurePlacement1;
                Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> nearestGeneratedStructure = this.a((Set)entry.getValue(), level, structureManager, pos, skipKnownStructures, concentricRingsStructurePlacement);
                if (nearestGeneratedStructure == null || !((d1 = pos.j(blockPosition = (BlockPosition)nearestGeneratedStructure.getFirst())) < d2)) continue;
                d2 = d1;
                pair = nearestGeneratedStructure;
                continue;
            }
            if (!(structurePlacement1 instanceof RandomSpreadStructurePlacement)) continue;
            list.add(entry);
        }
        if (!list.isEmpty()) {
            int sectionPosX = SectionPosition.a(pos.u());
            int sectionPosZ = SectionPosition.a(pos.w());
            for (int i2 = 0; i2 <= searchRadius; ++i2) {
                boolean flag = false;
                for (Map.Entry entry : list) {
                    RandomSpreadStructurePlacement randomSpreadStructurePlacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> nearestGeneratedStructure1 = ChunkGenerator.a((Set)entry.getValue(), level, structureManager, sectionPosX, sectionPosZ, i2, skipKnownStructures, generatorState.d(), randomSpreadStructurePlacement);
                    if (nearestGeneratedStructure1 == null) continue;
                    flag = true;
                    double d22 = pos.j((BaseBlockPosition)nearestGeneratedStructure1.getFirst());
                    if (!(d22 < d2)) continue;
                    d2 = d22;
                    pair = nearestGeneratedStructure1;
                }
                if (!flag) continue;
                return pair;
            }
        }
        return pair;
    }

    @Nullable
    private Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> a(Set<Holder<net.minecraft.world.level.levelgen.structure.Structure>> structureHoldersSet, WorldServer level, StructureManager structureManager, BlockPosition pos, boolean skipKnownStructures, ConcentricRingsStructurePlacement placement) {
        List<ChunkCoordIntPair> ringPositionsFor = level.m().h().a(placement);
        if (ringPositionsFor == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> pair = null;
        double d2 = Double.MAX_VALUE;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (ChunkCoordIntPair chunkPos : ringPositionsFor) {
            Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> structureGeneratingAt;
            if (!level.paperConfig().environment.locateStructuresOutsideWorldBorder && !level.F_().isChunkInBounds(chunkPos.h, chunkPos.i)) continue;
            mutableBlockPos.d(SectionPosition.a(chunkPos.h, 8), 32, SectionPosition.a(chunkPos.i, 8));
            double d1 = mutableBlockPos.j(pos);
            boolean flag = pair == null || d1 < d2;
            if (!flag || (structureGeneratingAt = ChunkGenerator.a(structureHoldersSet, level, structureManager, skipKnownStructures, placement, chunkPos)) == null) continue;
            pair = structureGeneratingAt;
            d2 = d1;
        }
        return pair;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> a(Set<Holder<net.minecraft.world.level.levelgen.structure.Structure>> structureHoldersSet, IWorldReader level, StructureManager structureManager, int x2, int y2, int z2, boolean skipKnownStructures, long seed, RandomSpreadStructurePlacement spreadPlacement) {
        int spacing = spreadPlacement.a();
        for (int i2 = -z2; i2 <= z2; ++i2) {
            boolean flag;
            int radius = z2;
            boolean onBorderAlongZAxis = flag = i2 == -z2 || i2 == z2;
            for (int i1 = -radius; i1 <= radius; i1 += onBorderAlongZAxis ? 1 : radius * 2) {
                int i22 = x2 + spacing * i2;
                int i3 = y2 + spacing * i1;
                ChunkCoordIntPair potentialStructureChunk = spreadPlacement.a(seed, i22, i3);
                Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> structureGeneratingAt = ChunkGenerator.a(structureHoldersSet, level, structureManager, skipKnownStructures, spreadPlacement, potentialStructureChunk);
                if (structureGeneratingAt == null) continue;
                return structureGeneratingAt;
            }
        }
        return null;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<net.minecraft.world.level.levelgen.structure.Structure>> a(Set<Holder<net.minecraft.world.level.levelgen.structure.Structure>> structureHoldersSet, IWorldReader level, StructureManager structureManager, boolean skipKnownStructures, StructurePlacement placement, ChunkCoordIntPair chunkPos) {
        for (Holder<net.minecraft.world.level.levelgen.structure.Structure> holder : structureHoldersSet) {
            StructureCheckResult structureCheckResult = structureManager.a(chunkPos, holder.a(), placement, skipKnownStructures);
            if (structureCheckResult == StructureCheckResult.b) continue;
            if (!skipKnownStructures && structureCheckResult == StructureCheckResult.a) {
                return Pair.of((Object)placement.a(chunkPos), holder);
            }
            IChunkAccess chunk = level.moonrise$syncLoadNonFull(chunkPos.h, chunkPos.i, ChunkStatus.d);
            StructureStart startForStructure = structureManager.a(SectionPosition.a(chunk), holder.a(), chunk);
            if (startForStructure == null || !startForStructure.b() || skipKnownStructures && !ChunkGenerator.a(structureManager, startForStructure)) continue;
            return Pair.of((Object)placement.a(startForStructure.c()), holder);
        }
        return null;
    }

    private static boolean a(StructureManager structureManager, StructureStart structureStart) {
        if (structureStart.d()) {
            structureManager.a(structureStart);
            return true;
        }
        return false;
    }

    public void addVanillaDecorations(GeneratorAccessSeed level, IChunkAccess chunk, StructureManager structureManager) {
        ChunkCoordIntPair pos = chunk.f();
        if (!SharedConstants.a(pos)) {
            SectionPosition sectionPos = SectionPosition.a(pos, level.ap());
            BlockPosition blockPos = sectionPos.j();
            IRegistry<net.minecraft.world.level.levelgen.structure.Structure> registry = level.K_().e(Registries.aU);
            Map<Integer, List<net.minecraft.world.level.levelgen.structure.Structure>> map = registry.s().collect(Collectors.groupingBy(structure1 -> structure1.c().ordinal()));
            List<FeatureSorter.b> list = this.c.get();
            SeededRandom worldgenRandom = new SeededRandom(new XoroshiroRandomSource(RandomSupport.a()));
            long l2 = worldgenRandom.a(level.E(), blockPos.u(), blockPos.w());
            ObjectArraySet set = new ObjectArraySet();
            ChunkCoordIntPair.a(sectionPos.r(), 1).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$8(level, (Set)set, arg_0));
            set.retainAll(this.b.c());
            int size = list.size();
            try {
                IRegistry<PlacedFeature> registry1 = level.K_().e(Registries.aT);
                int max = Math.max(WorldGenStage.Decoration.values().length, size);
                for (int i2 = 0; i2 < max; ++i2) {
                    int i1 = 0;
                    if (structureManager.a()) {
                        for (net.minecraft.world.level.levelgen.structure.Structure structure : map.getOrDefault(i2, Collections.emptyList())) {
                            worldgenRandom.b(l2, i1, i2);
                            Supplier<String> supplier = () -> registry.d(structure).map(Object::toString).orElseGet(structure::toString);
                            try {
                                level.a(supplier);
                                structureManager.a(sectionPos, structure).forEach(structureStart -> structureStart.a(level, structureManager, this, worldgenRandom, ChunkGenerator.a(chunk), pos));
                            }
                            catch (Exception var29) {
                                CrashReport crashReport = CrashReport.a(var29, "Feature placement");
                                crashReport.a("Feature").a("Description", supplier::get);
                                throw new ReportedException(crashReport);
                            }
                            ++i1;
                        }
                    }
                    if (i2 >= size) continue;
                    IntArraySet set1 = new IntArraySet();
                    for (Holder holder : set) {
                        List<HolderSet<PlacedFeature>> list2 = this.d.apply(holder).c();
                        if (i2 >= list2.size()) continue;
                        HolderSet<PlacedFeature> holderSet = list2.get(i2);
                        FeatureSorter.b stepFeatureData = list.get(i2);
                        holderSet.a().map(Holder::a).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$11((IntSet)set1, stepFeatureData, arg_0));
                    }
                    int size1 = set1.size();
                    int[] ints = set1.toIntArray();
                    Arrays.sort(ints);
                    FeatureSorter.b stepFeatureData1 = list.get(i2);
                    for (int i22 = 0; i22 < size1; ++i22) {
                        int i3 = ints[i22];
                        PlacedFeature placedFeature = stepFeatureData1.a().get(i3);
                        Supplier<String> supplier1 = () -> registry1.d(placedFeature).map(Object::toString).orElseGet(placedFeature::toString);
                        long featurePopulationSeed = l2;
                        long configFeatureSeed = level.getMinecraftWorld().paperConfig().featureSeeds.features.getLong(placedFeature.b());
                        if (configFeatureSeed != -1L) {
                            featurePopulationSeed = worldgenRandom.a(configFeatureSeed, blockPos.u(), blockPos.w());
                        }
                        worldgenRandom.b(featurePopulationSeed, i3, i2);
                        try {
                            level.a(supplier1);
                            placedFeature.b(level, this, worldgenRandom, blockPos);
                            continue;
                        }
                        catch (Exception var30) {
                            CrashReport crashReport1 = CrashReport.a(var30, "Feature placement");
                            crashReport1.a("Feature").a("Description", supplier1::get);
                            throw new ReportedException(crashReport1);
                        }
                    }
                }
                level.a((Supplier<String>)null);
            }
            catch (Exception var31) {
                CrashReport crashReport2 = CrashReport.a(var31, "Biome decoration");
                crashReport2.a("Generation").a("CenterX", pos.h).a("CenterZ", pos.i).a("Decoration Seed", l2);
                throw new ReportedException(crashReport2);
            }
        }
    }

    public void a(GeneratorAccessSeed level, IChunkAccess chunk, StructureManager structureManager) {
        this.applyBiomeDecoration(level, chunk, structureManager, true);
    }

    public void applyBiomeDecoration(GeneratorAccessSeed level, IChunkAccess chunk, StructureManager structureManager, boolean addVanillaDecorations) {
        CraftWorld world;
        if (addVanillaDecorations) {
            this.addVanillaDecorations(level, chunk, structureManager);
        }
        if (!(world = level.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(level, chunk.f());
            int x2 = chunk.f().h;
            int z2 = chunk.f().i;
            for (BlockPopulator populator : world.getPopulators()) {
                SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(level.E()));
                seededrandom.a(level.E(), x2, z2);
                populator.populate((WorldInfo)world, (Random)new RandomSourceWrapper.RandomWrapper(seededrandom), x2, z2, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    private static StructureBoundingBox a(IChunkAccess chunk) {
        ChunkCoordIntPair pos = chunk.f();
        int minBlockX = pos.d();
        int minBlockZ = pos.e();
        LevelHeightAccessor heightAccessorForGeneration = chunk.B();
        int i2 = heightAccessorForGeneration.L_() + 1;
        int maxY = heightAccessorForGeneration.an();
        return new StructureBoundingBox(minBlockX, i2, minBlockZ, minBlockX + 15, maxY, minBlockZ + 15);
    }

    public abstract void a(RegionLimitedWorldAccess var1, StructureManager var2, RandomState var3, IChunkAccess var4);

    public abstract void a(RegionLimitedWorldAccess var1);

    public int a(LevelHeightAccessor level) {
        return 64;
    }

    public WorldChunkManager d() {
        return this.b;
    }

    public abstract int e();

    public WeightedRandomList<BiomeSettingsMobs.c> a(Holder<BiomeBase> biome, StructureManager structureManager, EnumCreatureType category, BlockPosition pos) {
        Map<net.minecraft.world.level.levelgen.structure.Structure, LongSet> allStructuresAt = structureManager.b(pos);
        for (Map.Entry<net.minecraft.world.level.levelgen.structure.Structure, LongSet> entry : allStructuresAt.entrySet()) {
            net.minecraft.world.level.levelgen.structure.Structure structure = entry.getKey();
            StructureSpawnOverride structureSpawnOverride = structure.b().get(category);
            if (structureSpawnOverride == null) continue;
            MutableBoolean mutableBoolean = new MutableBoolean(false);
            Predicate<StructureStart> predicate = structureSpawnOverride.a() == StructureSpawnOverride.a.a ? structureStart -> structureManager.a(pos, (StructureStart)structureStart) : structureStart -> structureStart.a().b(pos);
            structureManager.a(structure, entry.getValue(), (StructureStart structureStart) -> {
                if (mutableBoolean.isFalse() && predicate.test((StructureStart)structureStart)) {
                    mutableBoolean.setTrue();
                }
            });
            if (!mutableBoolean.isTrue()) continue;
            return structureSpawnOverride.b();
        }
        return biome.a().b().a(category);
    }

    public void a(IRegistryCustom registryAccess, ChunkGeneratorStructureState structureState, StructureManager structureManager, IChunkAccess chunk, StructureTemplateManager structureTemplateManager, ResourceKey<World> level) {
        ChunkCoordIntPair pos = chunk.f();
        SectionPosition sectionPos = SectionPosition.a(chunk);
        RandomState randomState = structureState.c();
        structureState.a().forEach(holder -> {
            ResourceKey<StructureSet> resourceKey;
            StructurePlacement structurePlacement = ((StructureSet)holder.a()).b();
            List<StructureSet.a> list = ((StructureSet)holder.a()).a();
            for (StructureSet.a structureSelectionEntry : list) {
                StructureStart startForStructure = structureManager.a(sectionPos, structureSelectionEntry.a().a(), chunk);
                if (startForStructure == null || !startForStructure.b()) continue;
                return;
            }
            int n2 = pos.h;
            int n3 = pos.i;
            if (structurePlacement instanceof ChunkGeneratorStructureState.KeyedRandomSpreadStructurePlacement) {
                ChunkGeneratorStructureState.KeyedRandomSpreadStructurePlacement keyed = (ChunkGeneratorStructureState.KeyedRandomSpreadStructurePlacement)structurePlacement;
                resourceKey = keyed.key;
            } else {
                resourceKey = null;
            }
            if (structurePlacement.isStructureChunk(structureState, n2, n3, resourceKey)) {
                if (list.size() == 1) {
                    this.a(list.get(0), structureManager, registryAccess, randomState, structureTemplateManager, structureState.d(), chunk, pos, sectionPos, level);
                } else {
                    ArrayList<StructureSet.a> list1 = new ArrayList<StructureSet.a>(list.size());
                    list1.addAll(list);
                    SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
                    worldgenRandom.c(structureState.d(), pos.h, pos.i);
                    int i2 = 0;
                    for (StructureSet.a structureSelectionEntry1 : list1) {
                        i2 += structureSelectionEntry1.b();
                    }
                    while (!list1.isEmpty()) {
                        StructureSet.a structureSelectionEntry2;
                        int randomInt = worldgenRandom.a(i2);
                        int i1 = 0;
                        Iterator iterator = list1.iterator();
                        while (iterator.hasNext() && (randomInt -= (structureSelectionEntry2 = (StructureSet.a)iterator.next()).b()) >= 0) {
                            ++i1;
                        }
                        StructureSet.a structureSelectionEntry3 = (StructureSet.a)list1.get(i1);
                        if (this.a(structureSelectionEntry3, structureManager, registryAccess, randomState, structureTemplateManager, structureState.d(), chunk, pos, sectionPos, level)) {
                            return;
                        }
                        list1.remove(i1);
                        i2 -= structureSelectionEntry3.b();
                    }
                }
            }
        });
    }

    private boolean a(StructureSet.a structureSelectionEntry, StructureManager structureManager, IRegistryCustom registryAccess, RandomState random, StructureTemplateManager structureTemplateManager, long seed, IChunkAccess chunk, ChunkCoordIntPair chunkPos, SectionPosition sectionPos, ResourceKey<World> level) {
        net.minecraft.world.level.levelgen.structure.Structure structure = structureSelectionEntry.a().a();
        int i2 = ChunkGenerator.a(structureManager, chunk, sectionPos, structure);
        HolderSet<BiomeBase> holderSet = structure.a();
        Predicate<Holder<BiomeBase>> predicate = holderSet::a;
        StructureStart structureStart = structure.a(structureSelectionEntry.a(), level, registryAccess, this, this.b, random, structureTemplateManager, seed, chunkPos, i2, chunk, predicate);
        if (structureStart.b()) {
            StructureBoundingBox box = structureStart.a();
            AsyncStructureSpawnEvent event = new AsyncStructureSpawnEvent((org.bukkit.World)structureManager.a.getMinecraftWorld().getWorld(), CraftStructure.minecraftToBukkit(structure), new BoundingBox((double)box.h(), (double)box.i(), (double)box.j(), (double)box.k(), (double)box.l(), (double)box.m()), chunkPos.h, chunkPos.i);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return true;
            }
            structureManager.a(sectionPos, structure, structureStart, (StructureAccess)chunk);
            return true;
        }
        return false;
    }

    private static int a(StructureManager structureManager, IChunkAccess chunk, SectionPosition sectionPos, net.minecraft.world.level.levelgen.structure.Structure structure) {
        StructureStart startForStructure = structureManager.a(sectionPos, structure, chunk);
        return startForStructure != null ? startForStructure.f() : 0;
    }

    public void a(GeneratorAccessSeed level, StructureManager structureManager, IChunkAccess chunk) {
        int i2 = 8;
        ChunkCoordIntPair pos = chunk.f();
        int i1 = pos.h;
        int i22 = pos.i;
        int minBlockX = pos.d();
        int minBlockZ = pos.e();
        SectionPosition sectionPos = SectionPosition.a(chunk);
        for (int i3 = i1 - 8; i3 <= i1 + 8; ++i3) {
            for (int i4 = i22 - 8; i4 <= i22 + 8; ++i4) {
                long packedChunkPos = ChunkCoordIntPair.c(i3, i4);
                for (StructureStart structureStart : level.a(i3, i4).g().values()) {
                    try {
                        if (!structureStart.b() || !structureStart.a().a(minBlockX, minBlockZ, minBlockX + 15, minBlockZ + 15)) continue;
                        structureManager.a(sectionPos, structureStart.h(), packedChunkPos, (StructureAccess)chunk);
                        PacketDebug.a(level, structureStart);
                    }
                    catch (Exception var21) {
                        CrashReport crashReport = CrashReport.a(var21, "Generating structure reference");
                        CrashReportSystemDetails crashReportCategory = crashReport.a("Structure");
                        Optional<IRegistry<net.minecraft.world.level.levelgen.structure.Structure>> optional = level.K_().a(Registries.aU);
                        crashReportCategory.a("Id", () -> optional.map(registry -> registry.b(structureStart.h()).toString()).orElse("UNKNOWN"));
                        crashReportCategory.a("Name", () -> BuiltInRegistries.R.b(structureStart.h().e()).toString());
                        crashReportCategory.a("Class", () -> structureStart.h().getClass().getCanonicalName());
                        throw new ReportedException(crashReport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<IChunkAccess> a(Blender var1, RandomState var2, StructureManager var3, IChunkAccess var4);

    public abstract int f();

    public abstract int g();

    public abstract int a(int var1, int var2, HeightMap.Type var3, LevelHeightAccessor var4, RandomState var5);

    public abstract BlockColumn a(int var1, int var2, LevelHeightAccessor var3, RandomState var4);

    public int b(int x2, int z2, HeightMap.Type type, LevelHeightAccessor level, RandomState random) {
        return this.a(x2, z2, type, level, random);
    }

    public int c(int x2, int z2, HeightMap.Type types, LevelHeightAccessor level, RandomState random) {
        return this.a(x2, z2, types, level, random) - 1;
    }

    public abstract void a(List<String> var1, RandomState var2, BlockPosition var3);

    @Deprecated
    public BiomeSettingsGeneration a(Holder<BiomeBase> biome) {
        return this.d.apply(biome);
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$11(IntSet set1, FeatureSorter.b stepFeatureData, PlacedFeature placedFeature1) {
        set1.add(stepFeatureData.b().applyAsInt(placedFeature1));
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$8(GeneratorAccessSeed level, Set set, ChunkCoordIntPair chunkPos) {
        IChunkAccess chunk1 = level.a(chunkPos.h, chunkPos.i);
        for (ChunkSection levelChunkSection : chunk1.d()) {
            levelChunkSection.i().a(set::add);
        }
    }
}

