/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public class ChunkConverter {
    private static final Logger b = LogUtils.getLogger();
    public static final ChunkConverter a = new ChunkConverter(BlockAccessAir.a);
    private static final String c = "Indices";
    private static final EnumDirection8[] d = EnumDirection8.values();
    private final EnumSet<EnumDirection8> e = EnumSet.noneOf(EnumDirection8.class);
    private final List<TickListChunk<Block>> f = Lists.newArrayList();
    private final List<TickListChunk<FluidType>> g = Lists.newArrayList();
    private final int[][] h;
    static final Map<Block, a> i = new IdentityHashMap<Block, a>();
    static final Set<a> j = Sets.newHashSet();

    private ChunkConverter(LevelHeightAccessor level) {
        this.h = new int[level.ao()][];
    }

    public ChunkConverter(NBTTagCompound tag, LevelHeightAccessor level) {
        this(level);
        if (tag.b(c, 10)) {
            NBTTagCompound compound = tag.p(c);
            for (int i2 = 0; i2 < this.h.length; ++i2) {
                String string = String.valueOf(i2);
                if (!compound.b(string, 11)) continue;
                this.h[i2] = compound.n(string);
            }
        }
        int _int = tag.h("Sides");
        for (EnumDirection8 direction8 : EnumDirection8.values()) {
            if ((_int & 1 << direction8.ordinal()) == 0) continue;
            this.e.add(direction8);
        }
        ChunkConverter.a(tag, "neighbor_block_ticks", id -> BuiltInRegistries.e.b(MinecraftKey.c(id)).or(() -> Optional.of(Blocks.a)), this.f);
        ChunkConverter.a(tag, "neighbor_fluid_ticks", id -> BuiltInRegistries.c.b(MinecraftKey.c(id)).or(() -> Optional.of(FluidTypes.a)), this.g);
    }

    private ChunkConverter(ChunkConverter other) {
        this.e.addAll(other.e);
        this.f.addAll(other.f);
        this.g.addAll(other.g);
        this.h = new int[other.h.length][];
        for (int i2 = 0; i2 < other.h.length; ++i2) {
            int[] ints = other.h[i2];
            this.h[i2] = ints != null ? IntArrays.copy((int[])ints) : null;
        }
    }

    private static <T> void a(NBTTagCompound tag, String identifier, Function<String, Optional<T>> valueFunction, List<TickListChunk<T>> ticks) {
        if (tag.b(identifier, 9)) {
            for (NBTBase tag1 : tag.c(identifier, 10)) {
                TickListChunk.a((NBTTagCompound)tag1, valueFunction).ifPresent(ticks::add);
            }
        }
    }

    private static <T> void filterTickList(int chunkX, int chunkZ, List<TickListChunk<T>> ticks) {
        Iterator<TickListChunk<T>> iterator = ticks.iterator();
        while (iterator.hasNext()) {
            TickListChunk<T> tick = iterator.next();
            BlockPosition tickPos = tick.b();
            int tickCX = tickPos.u() >> 4;
            int tickCZ = tickPos.w() >> 4;
            int dist = Math.max(Math.abs(chunkX - tickCX), Math.abs(chunkZ - tickCZ));
            if (dist == 1) continue;
            b.warn("Neighbour tick '" + String.valueOf(tick) + "' serialized in chunk (" + chunkX + "," + chunkZ + ") is too far (" + tickCX + "," + tickCZ + ")");
            iterator.remove();
        }
    }

    public void a(Chunk chunk) {
        this.b(chunk);
        for (EnumDirection8 direction8 : d) {
            ChunkConverter.a(chunk, direction8);
        }
        ChunkConverter.filterTickList(chunk.locX, chunk.locZ, this.f);
        ChunkConverter.filterTickList(chunk.locX, chunk.locZ, this.g);
        World level = chunk.H();
        this.f.forEach(blockTicker -> {
            Block block = blockTicker.a() == Blocks.a ? level.a_(blockTicker.b()).b() : (Block)blockTicker.a();
            level.a(blockTicker.b(), block, blockTicker.c(), blockTicker.d());
        });
        this.g.forEach(fluidTicker -> {
            FluidType fluid = fluidTicker.a() == FluidTypes.a ? level.b_(fluidTicker.b()).a() : (FluidType)fluidTicker.a();
            level.a(fluidTicker.b(), fluid, fluidTicker.c(), fluidTicker.d());
        });
        Type.values();
        j.forEach(fixers -> fixers.a(level));
    }

    private static void a(Chunk chunk, EnumDirection8 side) {
        World level = chunk.H();
        if (chunk.t().e.remove((Object)side)) {
            Set<EnumDirection> directions = side.a();
            boolean i2 = false;
            int i1 = 15;
            boolean flag = directions.contains(EnumDirection.f);
            boolean flag1 = directions.contains(EnumDirection.e);
            boolean flag2 = directions.contains(EnumDirection.d);
            boolean flag3 = directions.contains(EnumDirection.c);
            boolean flag4 = directions.size() == 1;
            ChunkCoordIntPair pos = chunk.f();
            int i22 = pos.d() + (!flag4 || !flag3 && !flag2 ? (flag1 ? 0 : 15) : 1);
            int i3 = pos.d() + (!flag4 || !flag3 && !flag2 ? (flag1 ? 0 : 15) : 14);
            int i4 = pos.e() + (!flag4 || !flag && !flag1 ? (flag3 ? 0 : 15) : 1);
            int i5 = pos.e() + (!flag4 || !flag && !flag1 ? (flag3 ? 0 : 15) : 14);
            EnumDirection[] directions1 = EnumDirection.values();
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (BlockPosition blockPos : BlockPosition.b(i22, level.L_(), i4, i3, level.an(), i5)) {
                IBlockData blockState;
                IBlockData blockState1 = blockState = level.a_(blockPos);
                for (EnumDirection direction : directions1) {
                    mutableBlockPos.a((BaseBlockPosition)blockPos, direction);
                    blockState1 = ChunkConverter.a(blockState1, direction, level, blockPos, mutableBlockPos);
                }
                Block.a(blockState, blockState1, level, blockPos, 18);
            }
        }
    }

    private static IBlockData a(IBlockData state, EnumDirection direction, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
        return i.getOrDefault(state.b(), Type.b).a(state, direction, level.a_(offsetPos), level, pos, offsetPos);
    }

    private void b(Chunk chunk) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition mutableBlockPos1 = new BlockPosition.MutableBlockPosition();
        ChunkCoordIntPair pos = chunk.f();
        World level = chunk.H();
        for (int i2 = 0; i2 < this.h.length; ++i2) {
            ChunkSection section = chunk.b(i2);
            int[] ints = this.h[i2];
            this.h[i2] = null;
            if (ints == null || ints.length <= 0) continue;
            EnumDirection[] directions = EnumDirection.values();
            DataPaletteBlock<IBlockData> states = section.h();
            int sectionYFromSectionIndex = chunk.h(i2);
            int blockPosCoord = SectionPosition.c(sectionYFromSectionIndex);
            for (int i1 : ints) {
                IBlockData blockState;
                int i22 = i1 & 0xF;
                int i3 = i1 >> 8 & 0xF;
                int i4 = i1 >> 4 & 0xF;
                mutableBlockPos.d(pos.d() + i22, blockPosCoord + i3, pos.e() + i4);
                IBlockData blockState1 = blockState = states.a(i1);
                for (EnumDirection direction : directions) {
                    mutableBlockPos1.a((BaseBlockPosition)mutableBlockPos, direction);
                    if (SectionPosition.a(mutableBlockPos.u()) != pos.h || SectionPosition.a(mutableBlockPos.w()) != pos.i) continue;
                    blockState1 = ChunkConverter.a(blockState1, direction, level, mutableBlockPos, mutableBlockPos1);
                }
                Block.a(blockState, blockState1, level, mutableBlockPos, 18);
            }
        }
        for (int ix = 0; ix < this.h.length; ++ix) {
            if (this.h[ix] != null) {
                b.warn("Discarding update data for section {} for chunk ({} {})", new Object[]{level.h(ix), pos.h, pos.i});
            }
            this.h[ix] = null;
        }
    }

    public boolean a() {
        for (int[] ints : this.h) {
            if (ints == null) continue;
            return false;
        }
        return this.e.isEmpty();
    }

    public NBTTagCompound b() {
        NBTTagList listTag;
        NBTTagCompound compoundTag = new NBTTagCompound();
        NBTTagCompound compoundTag1 = new NBTTagCompound();
        for (int i2 = 0; i2 < this.h.length; ++i2) {
            String string = String.valueOf(i2);
            if (this.h[i2] == null || this.h[i2].length == 0) continue;
            compoundTag1.a(string, this.h[i2]);
        }
        if (!compoundTag1.g()) {
            compoundTag.a(c, compoundTag1);
        }
        int ix = 0;
        for (EnumDirection8 direction8 : this.e) {
            ix |= 1 << direction8.ordinal();
        }
        compoundTag.a("Sides", (byte)ix);
        if (!this.f.isEmpty()) {
            listTag = new NBTTagList();
            this.f.forEach(blockTicker -> listTag.add(blockTicker.a((T block) -> BuiltInRegistries.e.b((Block)block).toString())));
            compoundTag.a("neighbor_block_ticks", listTag);
        }
        if (!this.g.isEmpty()) {
            listTag = new NBTTagList();
            this.g.forEach(fluidTicker -> listTag.add(fluidTicker.a((T fluid) -> BuiltInRegistries.c.b((FluidType)fluid).toString())));
            compoundTag.a("neighbor_fluid_ticks", listTag);
        }
        return compoundTag;
    }

    public ChunkConverter c() {
        return this == a ? a : new ChunkConverter(this);
    }

    static abstract sealed class Type
    extends Enum<Type>
    implements a {
        public static final /* enum */ Type a = new Type(new Block[]{Blocks.lq, Blocks.eq, Blocks.mo, Blocks.mp, Blocks.mq, Blocks.mr, Blocks.ms, Blocks.mt, Blocks.mu, Blocks.mv, Blocks.mw, Blocks.mx, Blocks.my, Blocks.mz, Blocks.mA, Blocks.mB, Blocks.mC, Blocks.mD, Blocks.hp, Blocks.hq, Blocks.hr, Blocks.fV, Blocks.O, Blocks.L, Blocks.N, Blocks.cM, Blocks.cN, Blocks.cO, Blocks.cP, Blocks.cQ, Blocks.cR, Blocks.cS, Blocks.cT, Blocks.da, Blocks.db, Blocks.dc, Blocks.dd, Blocks.df, Blocks.dg, Blocks.dh, Blocks.dk, Blocks.dl, Blocks.dm, Blocks.dn, Blocks.dp, Blocks.dq, Blocks.dr, Blocks.dw, Blocks.dx, Blocks.dy, Blocks.dz, Blocks.dB, Blocks.dC, Blocks.dD}){

            @Override
            public IBlockData a(IBlockData state, EnumDirection direction, IBlockData offsetState, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
                return state;
            }
        };
        public static final /* enum */ Type b = new Type(new Block[0]){

            @Override
            public IBlockData a(IBlockData state, EnumDirection direction, IBlockData offsetState, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
                return state.a(level, level, pos, direction, offsetPos, level.a_(offsetPos), level.H_());
            }
        };
        public static final /* enum */ Type c = new Type(new Block[]{Blocks.cD, Blocks.hs}){

            @Override
            public IBlockData a(IBlockData state, EnumDirection direction, IBlockData offsetState, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
                if (offsetState.a(state.b()) && direction.o().d() && state.c(BlockChest.d) == BlockPropertyChestType.a && offsetState.c(BlockChest.d) == BlockPropertyChestType.a) {
                    EnumDirection direction1 = state.c(BlockChest.c);
                    if (direction.o() != direction1.o() && direction1 == offsetState.c(BlockChest.c)) {
                        BlockPropertyChestType chestType = direction == direction1.h() ? BlockPropertyChestType.b : BlockPropertyChestType.c;
                        level.a(offsetPos, (IBlockData)offsetState.b(BlockChest.d, chestType.a()), 18);
                        if (direction1 == EnumDirection.c || direction1 == EnumDirection.f) {
                            TileEntity blockEntity = level.c_(pos);
                            TileEntity blockEntity1 = level.c_(offsetPos);
                            if (blockEntity instanceof TileEntityChest && blockEntity1 instanceof TileEntityChest) {
                                TileEntityChest.a((TileEntityChest)blockEntity, (TileEntityChest)blockEntity1);
                            }
                        }
                        return (IBlockData)state.b(BlockChest.d, chestType);
                    }
                }
                return state;
            }
        };
        public static final /* enum */ Type d = new Type(true, new Block[]{Blocks.aO, Blocks.aP, Blocks.aM, Blocks.aR, Blocks.aQ, Blocks.aN, Blocks.aK, Blocks.aL}){
            private final ThreadLocal<List<ObjectSet<BlockPosition>>> g = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            public IBlockData a(IBlockData state, EnumDirection direction, IBlockData offsetState, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
                IBlockData blockState = state.a(level, level, pos, direction, offsetPos, level.a_(offsetPos), level.H_());
                if (state != blockState) {
                    int distanceValue = blockState.c(BlockProperties.aF);
                    List<ObjectSet<BlockPosition>> list = this.g.get();
                    if (list.isEmpty()) {
                        for (int i2 = 0; i2 < 7; ++i2) {
                            list.add((ObjectSet<BlockPosition>)new ObjectOpenHashSet());
                        }
                    }
                    list.get(distanceValue).add((Object)pos.j());
                }
                return state;
            }

            @Override
            public void a(GeneratorAccess level) {
                BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
                List<ObjectSet<BlockPosition>> list = this.g.get();
                for (int i2 = 2; i2 < list.size(); ++i2) {
                    int i1 = i2 - 1;
                    ObjectSet<BlockPosition> set = list.get(i1);
                    ObjectSet<BlockPosition> set1 = list.get(i2);
                    for (BlockPosition blockPos : set) {
                        IBlockData blockState = level.a_(blockPos);
                        if (blockState.c(BlockProperties.aF) < i1) continue;
                        level.a(blockPos, (IBlockData)blockState.b(BlockProperties.aF, i1), 18);
                        if (i2 == 7) continue;
                        for (EnumDirection direction : f) {
                            mutableBlockPos.a((BaseBlockPosition)blockPos, direction);
                            IBlockData blockState1 = level.a_(mutableBlockPos);
                            if (!blockState1.b(BlockProperties.aF) || blockState.c(BlockProperties.aF) <= i2) continue;
                            set1.add((Object)mutableBlockPos.j());
                        }
                    }
                }
                list.clear();
            }
        };
        public static final /* enum */ Type e = new Type(new Block[]{Blocks.fs, Blocks.fr}){

            @Override
            public IBlockData a(IBlockData state, EnumDirection direction, IBlockData offsetState, GeneratorAccess level, BlockPosition pos, BlockPosition offsetPos) {
                if (state.c(BlockStem.c) == 7) {
                    Block block;
                    Block block2 = block = state.a(Blocks.fr) ? Blocks.fn : Blocks.fo;
                    if (offsetState.a(block)) {
                        return (IBlockData)(state.a(Blocks.fr) ? Blocks.fp : Blocks.fq).m().b(BlockFacingHorizontal.aF, direction);
                    }
                }
                return state;
            }
        };
        public static final EnumDirection[] f;
        private static final /* synthetic */ Type[] g;

        public static Type[] values() {
            return (Type[])g.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(Block ... blocks) {
            this(false, blocks);
        }

        private Type(boolean chunkyFixer, Block ... blocks) {
            for (Block block : blocks) {
                i.put(block, this);
            }
            if (chunkyFixer) {
                j.add(this);
            }
        }

        private static /* synthetic */ Type[] a() {
            return new Type[]{a, b, c, d, e};
        }

        static {
            g = Type.a();
            f = EnumDirection.values();
        }
    }

    public static interface a {
        public IBlockData a(IBlockData var1, EnumDirection var2, IBlockData var3, GeneratorAccess var4, BlockPosition var5, BlockPosition var6);

        default public void a(GeneratorAccess level) {
        }
    }
}

