/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;

public class ShapeDetector {
    private final Predicate<ShapeDetectorBlock>[][][] a;
    private final int b;
    private final int c;
    private final int d;

    public ShapeDetector(Predicate<ShapeDetectorBlock>[][][] pattern) {
        this.a = pattern;
        this.b = pattern.length;
        if (this.b > 0) {
            this.c = pattern[0].length;
            this.d = this.c > 0 ? pattern[0][0].length : 0;
        } else {
            this.c = 0;
            this.d = 0;
        }
    }

    public int a() {
        return this.b;
    }

    public int b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    @VisibleForTesting
    public Predicate<ShapeDetectorBlock>[][][] d() {
        return this.a;
    }

    @Nullable
    @VisibleForTesting
    public ShapeDetectorCollection a(IWorldReader level, BlockPosition pos, EnumDirection finger, EnumDirection thumb) {
        LoadingCache<BlockPosition, ShapeDetectorBlock> loadingCache = ShapeDetector.a(level, false);
        return this.a(pos, finger, thumb, loadingCache);
    }

    @Nullable
    private ShapeDetectorCollection a(BlockPosition pos, EnumDirection finger, EnumDirection thumb, LoadingCache<BlockPosition, ShapeDetectorBlock> cache) {
        for (int i2 = 0; i2 < this.d; ++i2) {
            for (int i1 = 0; i1 < this.c; ++i1) {
                for (int i22 = 0; i22 < this.b; ++i22) {
                    if (this.a[i22][i1][i2].test((ShapeDetectorBlock)cache.getUnchecked((Object)ShapeDetector.a(pos, finger, thumb, i2, i1, i22)))) continue;
                    return null;
                }
            }
        }
        return new ShapeDetectorCollection(pos, finger, thumb, cache, this.d, this.c, this.b);
    }

    @Nullable
    public ShapeDetectorCollection a(IWorldReader level, BlockPosition pos) {
        LoadingCache<BlockPosition, ShapeDetectorBlock> loadingCache = ShapeDetector.a(level, false);
        int max = Math.max(Math.max(this.d, this.c), this.b);
        for (BlockPosition blockPos : BlockPosition.c(pos, pos.b(max - 1, max - 1, max - 1))) {
            for (EnumDirection direction : EnumDirection.values()) {
                for (EnumDirection direction1 : EnumDirection.values()) {
                    ShapeDetectorCollection blockPatternMatch;
                    if (direction1 == direction || direction1 == direction.g() || (blockPatternMatch = this.a(blockPos, direction, direction1, loadingCache)) == null) continue;
                    return blockPatternMatch;
                }
            }
        }
        return null;
    }

    public static LoadingCache<BlockPosition, ShapeDetectorBlock> a(IWorldReader level, boolean forceLoad) {
        return CacheBuilder.newBuilder().build((CacheLoader)new BlockLoader(level, forceLoad));
    }

    protected static BlockPosition a(BlockPosition pos, EnumDirection finger, EnumDirection thumb, int palmOffset, int thumbOffset, int fingerOffset) {
        if (finger != thumb && finger != thumb.g()) {
            BaseBlockPosition vec3i = new BaseBlockPosition(finger.j(), finger.k(), finger.l());
            BaseBlockPosition vec3i1 = new BaseBlockPosition(thumb.j(), thumb.k(), thumb.l());
            BaseBlockPosition vec3i2 = vec3i.d(vec3i1);
            return pos.b(vec3i1.u() * -thumbOffset + vec3i2.u() * palmOffset + vec3i.u() * fingerOffset, vec3i1.v() * -thumbOffset + vec3i2.v() * palmOffset + vec3i.v() * fingerOffset, vec3i1.w() * -thumbOffset + vec3i2.w() * palmOffset + vec3i.w() * fingerOffset);
        }
        throw new IllegalArgumentException("Invalid forwards & up combination");
    }

    public static class ShapeDetectorCollection {
        private final BlockPosition a;
        private final EnumDirection b;
        private final EnumDirection c;
        private final LoadingCache<BlockPosition, ShapeDetectorBlock> d;
        private final int e;
        private final int f;
        private final int g;

        public ShapeDetectorCollection(BlockPosition frontTopLeft, EnumDirection forwards, EnumDirection up, LoadingCache<BlockPosition, ShapeDetectorBlock> cache, int width, int height, int depth) {
            this.a = frontTopLeft;
            this.b = forwards;
            this.c = up;
            this.d = cache;
            this.e = width;
            this.f = height;
            this.g = depth;
        }

        public BlockPosition a() {
            return this.a;
        }

        public EnumDirection b() {
            return this.b;
        }

        public EnumDirection c() {
            return this.c;
        }

        public int d() {
            return this.e;
        }

        public int e() {
            return this.f;
        }

        public int f() {
            return this.g;
        }

        public ShapeDetectorBlock a(int palmOffset, int thumbOffset, int fingerOffset) {
            return (ShapeDetectorBlock)this.d.getUnchecked((Object)ShapeDetector.a(this.a, this.b(), this.c(), palmOffset, thumbOffset, fingerOffset));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("up", (Object)this.c).add("forwards", (Object)this.b).add("frontTopLeft", (Object)this.a).toString();
        }
    }

    static class BlockLoader
    extends CacheLoader<BlockPosition, ShapeDetectorBlock> {
        private final IWorldReader a;
        private final boolean b;

        public BlockLoader(IWorldReader level, boolean loadChunks) {
            this.a = level;
            this.b = loadChunks;
        }

        public ShapeDetectorBlock a(BlockPosition pos) {
            return new ShapeDetectorBlock(this.a, pos, this.b);
        }
    }
}

