/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.PistonUtil;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class TileEntityPiston
extends TileEntity {
    private static final int b = 2;
    private static final double c = 0.01;
    public static final double a = 0.51;
    private IBlockData d = Blocks.a.m();
    private EnumDirection e = EnumDirection.a;
    private boolean f;
    private boolean g;
    private static final ThreadLocal<EnumDirection> h = ThreadLocal.withInitial(() -> null);
    private float i;
    private float j;
    private long k;
    private int l;

    public TileEntityPiston(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.l, pos, blockState);
    }

    public TileEntityPiston(BlockPosition pos, IBlockData blockState, IBlockData movedState, EnumDirection direction, boolean extending, boolean isSourcePiston) {
        this(pos, blockState);
        this.d = movedState;
        this.e = direction;
        this.f = extending;
        this.g = isSourcePiston;
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.e(registries);
    }

    public boolean b() {
        return this.f;
    }

    public EnumDirection c() {
        return this.e;
    }

    public boolean d() {
        return this.g;
    }

    public float a(float partialTicks) {
        if (partialTicks > 1.0f) {
            partialTicks = 1.0f;
        }
        return MathHelper.h(partialTicks, this.j, this.i);
    }

    public float b(float partialTicks) {
        return (float)this.e.j() * this.e(this.a(partialTicks));
    }

    public float c(float partialTicks) {
        return (float)this.e.k() * this.e(this.a(partialTicks));
    }

    public float d(float partialTicks) {
        return (float)this.e.l() * this.e(this.a(partialTicks));
    }

    private float e(float progress) {
        return this.f ? progress - 1.0f : 1.0f - progress;
    }

    private IBlockData u() {
        return !this.b() && this.d() && this.d.b() instanceof BlockPiston ? (IBlockData)((IBlockData)((IBlockData)Blocks.bG.m().b(BlockPistonExtension.d, this.i > 0.25f)).b(BlockPistonExtension.c, this.d.a(Blocks.by) ? BlockPropertyPistonType.b : BlockPropertyPistonType.a)).b(BlockDirectional.a, this.d.c(BlockDirectional.a)) : this.d;
    }

    private static void a(World level, BlockPosition pos, float partialTick, TileEntityPiston piston) {
        AxisAlignedBB aabb;
        List<Entity> entities;
        EnumDirection movementDirection = piston.f();
        double d2 = partialTick - piston.i;
        VoxelShape collisionShape = piston.u().g(level, pos);
        if (!collisionShape.c() && !(entities = level.a_(null, PistonUtil.a(aabb = TileEntityPiston.a(pos, collisionShape.a(), piston), movementDirection, d2).b(aabb))).isEmpty()) {
            List<AxisAlignedBB> list = collisionShape.e();
            boolean isSlimeBlock = piston.d.a(Blocks.it);
            Iterator<Entity> var12 = entities.iterator();
            while (true) {
                AxisAlignedBB boundingBox;
                AxisAlignedBB aabb1;
                AxisAlignedBB movementArea;
                if (!var12.hasNext()) {
                    return;
                }
                Entity entity = var12.next();
                if (entity.n_() == EnumPistonReaction.d) continue;
                if (isSlimeBlock) {
                    if (entity instanceof EntityPlayer) continue;
                    Vec3D deltaMovement = entity.dy();
                    double d1 = deltaMovement.d;
                    double d22 = deltaMovement.e;
                    double d3 = deltaMovement.f;
                    switch (movementDirection.o()) {
                        case a: {
                            d1 = movementDirection.j();
                            break;
                        }
                        case b: {
                            d22 = movementDirection.k();
                            break;
                        }
                        case c: {
                            d3 = movementDirection.l();
                        }
                    }
                    entity.n(d1, d22, d3);
                    entity.activatedTick = Math.max(entity.activatedTick, (long)(MinecraftServer.currentTick + 10));
                    entity.activatedImmunityTick = Math.max(entity.activatedImmunityTick, (long)(MinecraftServer.currentTick + 10));
                }
                double d4 = 0.0;
                Iterator<AxisAlignedBB> iterator = list.iterator();
                while (!(!iterator.hasNext() || (movementArea = PistonUtil.a(TileEntityPiston.a(pos, aabb1 = iterator.next(), piston), movementDirection, d2)).c(boundingBox = entity.cR()) && (d4 = Math.max(d4, TileEntityPiston.a(movementArea, movementDirection, boundingBox))) >= d2)) {
                }
                if (d4 <= 0.0) continue;
                d4 = Math.min(d4, d2) + 0.01;
                TileEntityPiston.a(movementDirection, entity, d4, movementDirection);
                if (piston.f || !piston.g) continue;
                TileEntityPiston.a(pos, entity, movementDirection, d2);
            }
        }
    }

    private static void a(EnumDirection noClipDirection, Entity entity, double progress, EnumDirection direction) {
        h.set(noClipDirection);
        entity.a(EnumMoveType.c, new Vec3D(progress * (double)direction.j(), progress * (double)direction.k(), progress * (double)direction.l()));
        entity.aK();
        h.set(null);
    }

    private static void b(World level, BlockPosition pos, float partialTick, TileEntityPiston piston) {
        EnumDirection movementDirection;
        if (piston.v() && (movementDirection = piston.f()).o().d()) {
            double d2 = piston.d.g(level, pos).c(EnumDirection.EnumAxis.b);
            AxisAlignedBB aabb = TileEntityPiston.a(pos, new AxisAlignedBB(0.0, d2, 0.0, 1.0, 1.5000010000000001, 1.0), piston);
            double d1 = partialTick - piston.i;
            for (Entity entity : level.a((Entity)null, aabb, collidedEntity -> TileEntityPiston.a(aabb, collidedEntity, pos))) {
                TileEntityPiston.a(movementDirection, entity, d1, movementDirection);
            }
        }
    }

    private static boolean a(AxisAlignedBB box, Entity entity, BlockPosition pos) {
        return entity.n_() == EnumPistonReaction.a && entity.aJ() && (entity.d(pos) || entity.dA() >= box.a && entity.dA() <= box.d && entity.dG() >= box.c && entity.dG() <= box.f);
    }

    private boolean v() {
        return this.d.a(Blocks.pI);
    }

    public EnumDirection f() {
        return this.f ? this.e : this.e.g();
    }

    private static double a(AxisAlignedBB headShape, EnumDirection direction, AxisAlignedBB facing) {
        switch (direction) {
            case f: {
                return headShape.d - facing.a;
            }
            case e: {
                return facing.d - headShape.a;
            }
            default: {
                return headShape.e - facing.b;
            }
            case a: {
                return facing.e - headShape.b;
            }
            case d: {
                return headShape.f - facing.c;
            }
            case c: 
        }
        return facing.f - headShape.c;
    }

    private static AxisAlignedBB a(BlockPosition pos, AxisAlignedBB aabb, TileEntityPiston pistonMovingBlockEntity) {
        double d2 = pistonMovingBlockEntity.e(pistonMovingBlockEntity.i);
        return aabb.d((double)pos.u() + d2 * (double)pistonMovingBlockEntity.e.j(), (double)pos.v() + d2 * (double)pistonMovingBlockEntity.e.k(), (double)pos.w() + d2 * (double)pistonMovingBlockEntity.e.l());
    }

    private static void a(BlockPosition pos, Entity entity, EnumDirection dir, double progress) {
        double d1;
        EnumDirection opposite;
        double d2;
        AxisAlignedBB aabb;
        AxisAlignedBB boundingBox = entity.cR();
        if (boundingBox.c(aabb = VoxelShapes.b().a().a(pos)) && Math.abs((d2 = TileEntityPiston.a(aabb, opposite = dir.g(), boundingBox) + 0.01) - (d1 = TileEntityPiston.a(aabb, opposite, boundingBox.a(aabb)) + 0.01)) < 0.01) {
            d2 = Math.min(d2, progress) + 0.01;
            TileEntityPiston.a(dir, entity, d2, opposite);
        }
    }

    public IBlockData j() {
        return this.d;
    }

    public void k() {
        if (this.n != null && (this.j < 1.0f || this.n.C)) {
            this.j = this.i = 1.0f;
            this.n.o(this.o);
            this.av_();
            if (this.n.a_(this.o).a(Blocks.bX)) {
                IBlockData blockState = this.g ? Blocks.a.m() : Block.b(this.d, this.n, this.o);
                this.n.a(this.o, blockState, 3);
                this.n.b(this.o, blockState.b(), ExperimentalRedstoneUtils.a(this.n, this.s(), null));
            }
        }
    }

    public EnumDirection s() {
        return this.f ? this.e : this.e.g();
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntityPiston blockEntity) {
        blockEntity.k = level.ad();
        blockEntity.j = blockEntity.i;
        if (blockEntity.j >= 1.0f) {
            if (level.C && blockEntity.l < 5) {
                ++blockEntity.l;
            } else {
                level.o(pos);
                blockEntity.av_();
                if (level.a_(pos).a(Blocks.bX)) {
                    IBlockData blockState = Block.b(blockEntity.d, level, pos);
                    if (blockState.l()) {
                        level.a(pos, blockEntity.d, GlobalConfiguration.get().unsupportedSettings.allowPistonDuplication ? 84 : 86);
                        Block.a(blockEntity.d, blockState, level, pos, 3);
                    } else {
                        if (blockState.b(BlockProperties.J) && blockState.c(BlockProperties.J).booleanValue()) {
                            blockState = (IBlockData)blockState.b(BlockProperties.J, false);
                        }
                        level.a(pos, blockState, 67);
                        level.b(pos, blockState.b(), ExperimentalRedstoneUtils.a(level, blockEntity.s(), null));
                    }
                }
            }
        } else {
            float f2 = blockEntity.i + 0.5f;
            TileEntityPiston.a(level, pos, f2, blockEntity);
            TileEntityPiston.b(level, pos, f2, blockEntity);
            blockEntity.i = f2;
            if (blockEntity.i >= 1.0f) {
                blockEntity.i = 1.0f;
            }
        }
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        RegistryBlocks<Block> holderGetter = this.n != null ? this.n.a(Registries.f) : BuiltInRegistries.e;
        this.d = GameProfileSerializer.a(holderGetter, tag.p("blockState"));
        this.e = EnumDirection.a(tag.h("facing"));
        this.j = this.i = tag.j("progress");
        this.f = tag.q("extending");
        this.g = tag.q("source");
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        tag.a("blockState", GameProfileSerializer.a(this.d));
        tag.a("facing", this.e.d());
        tag.a("progress", this.j);
        tag.a("extending", this.f);
        tag.a("source", this.g);
    }

    public VoxelShape a(IBlockAccess level, BlockPosition pos) {
        VoxelShape collisionShape = !this.f && this.g && this.d.b() instanceof BlockPiston ? ((IBlockData)this.d.b(BlockPiston.c, true)).g(level, pos) : VoxelShapes.a();
        EnumDirection direction = h.get();
        if ((double)this.i < 1.0 && direction == this.f()) {
            return collisionShape;
        }
        IBlockData blockState = this.d() ? (IBlockData)((IBlockData)Blocks.bG.m().b(BlockDirectional.a, this.e)).b(BlockPistonExtension.d, this.f != 1.0f - this.i < 0.25f) : this.d;
        float extendedProgress = this.e(this.i);
        double d2 = (float)this.e.j() * extendedProgress;
        double d1 = (float)this.e.k() * extendedProgress;
        double d22 = (float)this.e.l() * extendedProgress;
        return VoxelShapes.a(collisionShape, blockState.g(level, pos).a(d2, d1, d22));
    }

    public long t() {
        return this.k;
    }

    @Override
    public void a(World level) {
        super.a(level);
        if (level.a(Registries.f).a(this.d.b().p().h()).isEmpty()) {
            this.d = Blocks.a.m();
        }
    }
}

