/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public final class TrialSpawnerState
extends Enum<TrialSpawnerState>
implements INamable {
    public static final /* enum */ TrialSpawnerState a = new TrialSpawnerState("inactive", 0, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a, -1.0, false);
    public static final /* enum */ TrialSpawnerState b = new TrialSpawnerState("waiting_for_players", 4, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.b, 200.0, true);
    public static final /* enum */ TrialSpawnerState c = new TrialSpawnerState("active", 8, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.c, 1000.0, true);
    public static final /* enum */ TrialSpawnerState d = new TrialSpawnerState("waiting_for_reward_ejection", 8, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.b, -1.0, false);
    public static final /* enum */ TrialSpawnerState e = new TrialSpawnerState("ejecting_reward", 8, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.b, -1.0, false);
    public static final /* enum */ TrialSpawnerState f = new TrialSpawnerState("cooldown", 0, net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.d, -1.0, false);
    private static final float g = 40.0f;
    private static final int h;
    private final String i;
    private final int j;
    private final double k;
    private final b l;
    private final boolean m;
    private static final /* synthetic */ TrialSpawnerState[] n;

    public static TrialSpawnerState[] values() {
        return (TrialSpawnerState[])n.clone();
    }

    public static TrialSpawnerState valueOf(String name) {
        return Enum.valueOf(TrialSpawnerState.class, name);
    }

    private TrialSpawnerState(String name, int lightLevel, b particleEmission, double spinningMobSpeed, boolean isCapableOfSpawning) {
        this.i = name;
        this.j = lightLevel;
        this.l = particleEmission;
        this.k = spinningMobSpeed;
        this.m = isCapableOfSpawning;
    }

    TrialSpawnerState a(BlockPosition pos, TrialSpawner spawner, WorldServer level) {
        TrialSpawnerData data = spawner.f();
        TrialSpawnerConfig config = spawner.b();
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (data.a(spawner, level, b) == null) {
                    yield this;
                }
                yield b;
            }
            case 1 -> {
                if (!spawner.a(level)) {
                    data.b();
                    yield this;
                }
                if (!data.a(spawner, level.A)) {
                    yield a;
                }
                data.a(level, pos, spawner);
                if (data.c.isEmpty()) {
                    yield this;
                }
                yield c;
            }
            case 2 -> {
                if (!spawner.a(level)) {
                    data.b();
                    yield b;
                }
                if (!data.a(spawner, level.A)) {
                    yield a;
                }
                int i = data.a(pos);
                data.a(level, pos, spawner);
                if (spawner.e()) {
                    this.a(level, pos, spawner);
                }
                if (data.a(config, i)) {
                    if (data.c()) {
                        data.e = level.ad() + (long)spawner.g();
                        data.g = 0;
                        data.f = 0L;
                        yield d;
                    }
                } else if (data.a(level, config, i)) {
                    spawner.c(level, pos).ifPresent(uuid -> {
                        data.d.add((UUID)uuid);
                        ++data.g;
                        data.f = level.ad() + (long)config.h();
                        config.i().b(level.H_()).ifPresent(wrapper -> {
                            data.h = Optional.of((MobSpawnerData)wrapper.b());
                            spawner.j();
                        });
                    });
                }
                yield this;
            }
            case 3 -> {
                if (data.a(level, 40.0f, spawner.g())) {
                    level.a(null, pos, SoundEffects.mI, SoundCategory.e);
                    yield e;
                }
                yield this;
            }
            case 4 -> {
                if (!data.b(level, h, spawner.g())) {
                    yield this;
                }
                if (data.c.isEmpty()) {
                    level.a(null, pos, SoundEffects.mJ, SoundCategory.e);
                    data.i = Optional.empty();
                    yield f;
                }
                if (data.i.isEmpty()) {
                    data.i = config.j().a(level.H_());
                }
                data.i.ifPresent(resourceKey -> spawner.a(level, pos, (ResourceKey<LootTable>)resourceKey));
                data.c.remove(data.c.iterator().next());
                yield this;
            }
            case 5 -> {
                data.a(level, pos, spawner);
                if (!data.c.isEmpty()) {
                    data.g = 0;
                    data.f = 0L;
                    yield c;
                }
                if (data.a(level)) {
                    spawner.b(level, pos);
                    data.a();
                    yield b;
                }
                yield this;
            }
        };
    }

    private void a(WorldServer level, BlockPosition pos, TrialSpawner spawner) {
        TrialSpawnerConfig config;
        TrialSpawnerData data = spawner.f();
        ItemStack itemStack = data.a(level, config = spawner.b(), pos).a(level.A).orElse(ItemStack.j);
        if (!itemStack.f() && this.a(level, data)) {
            TrialSpawnerState.a(level, pos, spawner, data).ifPresent(vec3 -> {
                OminousItemSpawner ominousItemSpawner = OminousItemSpawner.a(level, itemStack);
                ominousItemSpawner.f((Vec3D)vec3);
                level.b(ominousItemSpawner);
                float f2 = (level.H_().i() - level.H_().i()) * 0.2f + 1.0f;
                level.a(null, BlockPosition.a(vec3), SoundEffects.mD, SoundCategory.e, 1.0f, f2);
                data.e = level.ad() + spawner.d().a();
            });
        }
    }

    private static Optional<Vec3D> a(WorldServer level, BlockPosition pos, TrialSpawner spawner, TrialSpawnerData spawnerData) {
        List<EntityHuman> list = spawnerData.c.stream().map(level::b).filter(Objects::nonNull).filter(player -> !player.b() && !player.Z_() && player.bL() && player.g(pos.b()) <= (double)MathHelper.h(spawner.h())).toList();
        if (list.isEmpty()) {
            return Optional.empty();
        }
        Entity entity = TrialSpawnerState.a(list, spawnerData.d, spawner, pos, level);
        return entity == null ? Optional.empty() : TrialSpawnerState.a(entity, level);
    }

    private static Optional<Vec3D> a(Entity entity, WorldServer level) {
        Vec3D vec31;
        Vec3D vec3 = entity.dt();
        MovingObjectPositionBlock blockHitResult = level.a(new RayTrace(vec3, vec31 = vec3.a(EnumDirection.b, (double)(entity.dr() + 2.0f + (float)level.A.a(4))), RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a()));
        Vec3D vec32 = blockHitResult.b().b().a(EnumDirection.a, 1.0);
        BlockPosition blockPos = BlockPosition.a(vec32);
        return !level.a_(blockPos).g(level, blockPos).c() ? Optional.empty() : Optional.of(vec32);
    }

    @Nullable
    private static Entity a(List<EntityHuman> player, Set<UUID> currentMobs, TrialSpawner spawner, BlockPosition pos, WorldServer level) {
        List<Entity> list;
        Stream<Entity> stream = currentMobs.stream().map(level::a).filter(Objects::nonNull).filter(entity -> entity.bL() && entity.g(pos.b()) <= (double)MathHelper.h(spawner.h()));
        List<Entity> list2 = list = level.A.h() ? stream.toList() : player;
        if (list.isEmpty()) {
            return null;
        }
        return list.size() == 1 ? list.getFirst() : SystemUtils.a(list, level.A);
    }

    private boolean a(WorldServer level, TrialSpawnerData spawnerData) {
        return level.ad() >= spawnerData.e;
    }

    public int a() {
        return this.j;
    }

    public double b() {
        return this.k;
    }

    public boolean d() {
        return this.k >= 0.0;
    }

    public boolean e() {
        return this.m;
    }

    public void a(World level, BlockPosition pos, boolean isOminous) {
        this.l.emit(level, level.H_(), pos, isOminous);
    }

    @Override
    public String c() {
        return this.i;
    }

    private static /* synthetic */ TrialSpawnerState[] f() {
        return new TrialSpawnerState[]{a, b, c, d, e, f};
    }

    static {
        n = TrialSpawnerState.f();
        h = MathHelper.d(30.0f);
    }

    static interface b {
        public static final b a = (level, random, pos, isOminous) -> {};
        public static final b b = (level, random, pos, isOminous) -> {
            if (random.a(2) == 0) {
                Vec3D vec3 = pos.b().a(random, 0.9f);
                net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(isOminous ? Particles.M : Particles.aL, vec3, level);
            }
        };
        public static final b c = (level, random, pos, isOminous) -> {
            Vec3D vec3 = pos.b().a(random, 1.0f);
            net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(Particles.ag, vec3, level);
            net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(isOminous ? Particles.M : Particles.F, vec3, level);
        };
        public static final b d = (level, random, pos, isOminous) -> {
            Vec3D vec3 = pos.b().a(random, 0.9f);
            if (random.a(3) == 0) {
                net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(Particles.ag, vec3, level);
            }
            if (level.ad() % 20L == 0L) {
                Vec3D vec31 = pos.b().b(0.0, 0.5, 0.0);
                int i2 = level.H_().a(4) + 20;
                for (int i1 = 0; i1 < i2; ++i1) {
                    net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState$b.a(Particles.ag, vec31, level);
                }
            }
        };

        private static void a(ParticleType particleType, Vec3D pos, World level) {
            level.a(particleType, pos.a(), pos.b(), pos.c(), 0.0, 0.0, 0.0);
        }

        public void emit(World var1, RandomSource var2, BlockPosition var3, boolean var4);
    }

    static class c {
        private static final double a = -1.0;
        private static final double b = 200.0;
        private static final double c = 1000.0;

        private c() {
        }
    }

    static class a {
        private static final int a = 0;
        private static final int b = 4;
        private static final int c = 8;

        private a() {
        }
    }
}

