/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.bukkit.event.entity.EntityRemoveEvent;

public class TrialSpawnerData {
    public static final String a = "spawn_data";
    private static final String m = "next_mob_spawns_at";
    private static final int n = 20;
    private static final int o = 18000;
    public static MapCodec<TrialSpawnerData> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UUIDUtil.b.lenientOptionalFieldOf("registered_players", (Object)Sets.newHashSet()).forGetter(trialSpawnerData -> trialSpawnerData.c), (App)UUIDUtil.b.lenientOptionalFieldOf("current_mobs", (Object)Sets.newHashSet()).forGetter(trialSpawnerData -> trialSpawnerData.d), (App)Codec.LONG.lenientOptionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(trialSpawnerData -> trialSpawnerData.e), (App)Codec.LONG.lenientOptionalFieldOf(m, (Object)0L).forGetter(trialSpawnerData -> trialSpawnerData.f), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).lenientOptionalFieldOf("total_mobs_spawned", (Object)0).forGetter(trialSpawnerData -> trialSpawnerData.g), (App)MobSpawnerData.b.lenientOptionalFieldOf(a).forGetter(trialSpawnerData -> trialSpawnerData.h), (App)ResourceKey.a(Registries.bg).lenientOptionalFieldOf("ejecting_loot_table").forGetter(trialSpawnerData -> trialSpawnerData.i)).apply((Applicative)instance, TrialSpawnerData::new));
    public final Set<UUID> c = new HashSet<UUID>();
    public final Set<UUID> d = new HashSet<UUID>();
    public long e;
    public long f;
    protected int g;
    public Optional<MobSpawnerData> h;
    protected Optional<ResourceKey<LootTable>> i;
    @Nullable
    protected Entity j;
    @Nullable
    private SimpleWeightedRandomList<ItemStack> p;
    protected double k;
    protected double l;

    public TrialSpawnerData() {
        this(Collections.emptySet(), Collections.emptySet(), 0L, 0L, 0, Optional.empty(), Optional.empty());
    }

    public TrialSpawnerData(Set<UUID> detectedPlayers, Set<UUID> currentMobs, long cooldownEndsAt, long nextMobSpawnsAt, int totalMobsSpawned, Optional<MobSpawnerData> nextSpawnData, Optional<ResourceKey<LootTable>> ejectingLootTable) {
        this.c.addAll(detectedPlayers);
        this.d.addAll(currentMobs);
        this.e = cooldownEndsAt;
        this.f = nextMobSpawnsAt;
        this.g = totalMobsSpawned;
        this.h = nextSpawnData;
        this.i = ejectingLootTable;
    }

    public void a() {
        this.d.clear();
        this.h = Optional.empty();
        this.b();
    }

    public void b() {
        this.c.clear();
        this.g = 0;
        this.f = 0L;
        this.e = 0L;
    }

    public boolean a(TrialSpawner trialSpawner, RandomSource random) {
        boolean flag = this.b(trialSpawner, random).a().b("id", 8);
        return flag || !trialSpawner.b().i().d();
    }

    public boolean a(TrialSpawnerConfig config, int players) {
        return this.g >= config.a(players);
    }

    public boolean c() {
        return this.d.isEmpty();
    }

    public boolean a(WorldServer level, TrialSpawnerConfig config, int players) {
        return level.ad() >= this.f && this.d.size() < config.b(players);
    }

    public int a(BlockPosition pos) {
        if (this.c.isEmpty()) {
            SystemUtils.b("Trial Spawner at " + String.valueOf(pos) + " has no detected players");
        }
        return Math.max(0, this.c.size() - 1);
    }

    public void a(WorldServer level, BlockPosition pos, TrialSpawner spawner) {
        boolean flag;
        boolean bl = flag = (pos.a() + level.ad()) % 20L != 0L;
        if (!(flag || spawner.i().equals(TrialSpawnerState.f) && spawner.e())) {
            boolean flag1;
            List<UUID> list = spawner.k().detect(level, spawner.l(), pos, spawner.h(), true);
            if (!spawner.e() && !list.isEmpty()) {
                Optional<Pair<EntityHuman, Holder<MobEffectList>>> optional = TrialSpawnerData.a(level, list);
                optional.ifPresent(pair -> {
                    EntityHuman player = (EntityHuman)pair.getFirst();
                    if (pair.getSecond() == MobEffects.E) {
                        TrialSpawnerData.a(player);
                    }
                    level.c(3020, BlockPosition.a(player.bF()), 0);
                    spawner.a(level, pos);
                });
                flag1 = optional.isPresent();
            } else {
                flag1 = false;
            }
            if (!spawner.i().equals(TrialSpawnerState.f) || flag1) {
                List<UUID> list1;
                boolean isEmpty = spawner.f().c.isEmpty();
                List<UUID> list2 = list1 = isEmpty ? list : spawner.k().detect(level, spawner.l(), pos, spawner.h(), false);
                if (this.c.addAll(list1)) {
                    this.f = Math.max(level.ad() + 40L, this.f);
                    if (!flag1) {
                        int i2 = spawner.e() ? 3019 : 3013;
                        level.c(i2, pos, this.c.size());
                    }
                }
            }
        }
    }

    private static Optional<Pair<EntityHuman, Holder<MobEffectList>>> a(WorldServer level, List<UUID> players) {
        EntityHuman player = null;
        for (UUID uuid : players) {
            EntityHuman playerByUuid = level.b(uuid);
            if (playerByUuid == null) continue;
            Holder<MobEffectList> holder = MobEffects.H;
            if (playerByUuid.b(holder)) {
                return Optional.of(Pair.of((Object)playerByUuid, holder));
            }
            if (!playerByUuid.b(MobEffects.E)) continue;
            player = playerByUuid;
        }
        return Optional.ofNullable(player).map(player1 -> Pair.of((Object)player1, MobEffects.E));
    }

    public void a(TrialSpawner spawner, WorldServer level) {
        this.d.stream().map(level::a).forEach(entity -> {
            if (entity != null) {
                level.c(3012, entity.dv(), TrialSpawner.a.a.a());
                if (entity instanceof EntityInsentient) {
                    EntityInsentient mob = (EntityInsentient)entity;
                    mob.b(level);
                }
                entity.remove(Entity.RemovalReason.b, EntityRemoveEvent.Cause.DESPAWN);
            }
        });
        if (!spawner.d().i().d()) {
            this.h = Optional.empty();
        }
        this.g = 0;
        this.d.clear();
        this.f = level.ad() + (long)spawner.d().h();
        spawner.j();
        this.e = level.ad() + spawner.d().a();
    }

    private static void a(EntityHuman player) {
        MobEffect effect = player.c(MobEffects.E);
        if (effect != null) {
            int i2 = effect.e() + 1;
            int i1 = 18000 * i2;
            player.e(MobEffects.E);
            player.a(new MobEffect(MobEffects.H, i1, 0));
        }
    }

    public boolean a(WorldServer level, float delay, int targetCooldownLength) {
        long l2 = this.e - (long)targetCooldownLength;
        return (float)level.ad() >= (float)l2 + delay;
    }

    public boolean b(WorldServer level, float delay, int targetCooldownLength) {
        long l2 = this.e - (long)targetCooldownLength;
        return (float)(level.ad() - l2) % delay == 0.0f;
    }

    public boolean a(WorldServer level) {
        return level.ad() >= this.e;
    }

    protected MobSpawnerData b(TrialSpawner spawner, RandomSource random) {
        if (this.h.isPresent()) {
            return this.h.get();
        }
        SimpleWeightedRandomList<MobSpawnerData> simpleWeightedRandomList = spawner.b().i();
        Optional<MobSpawnerData> optional = simpleWeightedRandomList.d() ? this.h : simpleWeightedRandomList.b(random).map(WeightedEntry.b::b);
        this.h = Optional.of(optional.orElseGet(MobSpawnerData::new));
        spawner.j();
        return this.h.get();
    }

    @Nullable
    public Entity a(TrialSpawner spawner, World level, TrialSpawnerState spawnerState) {
        NBTTagCompound entityToSpawn;
        if (!spawnerState.d()) {
            return null;
        }
        if (this.j == null && (entityToSpawn = this.b(spawner, level.H_()).a()).b("id", 8)) {
            this.j = EntityTypes.a(entityToSpawn, level, EntitySpawnReason.q, Function.identity());
        }
        return this.j;
    }

    public NBTTagCompound a(TrialSpawnerState spawnerState) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        if (spawnerState == TrialSpawnerState.c) {
            compoundTag.a(m, this.f);
        }
        this.h.ifPresent(spawnData -> compoundTag.a(a, (NBTBase)MobSpawnerData.b.encodeStart((DynamicOps)DynamicOpsNBT.a, spawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData"))));
        return compoundTag;
    }

    public double d() {
        return this.k;
    }

    public double e() {
        return this.l;
    }

    SimpleWeightedRandomList<ItemStack> a(WorldServer level, TrialSpawnerConfig config, BlockPosition pos) {
        long l2;
        LootParams lootParams;
        if (this.p != null) {
            return this.p;
        }
        LootTable lootTable = level.p().bc().b(config.k());
        ObjectArrayList<ItemStack> randomItems = lootTable.a(lootParams = new LootParams.a(level).a(LootContextParameterSets.b), l2 = TrialSpawnerData.a(level, pos));
        if (randomItems.isEmpty()) {
            return SimpleWeightedRandomList.b();
        }
        SimpleWeightedRandomList.a<ItemStack> builder = new SimpleWeightedRandomList.a<ItemStack>();
        for (ItemStack itemStack : randomItems) {
            builder.a(itemStack.c(1), itemStack.M());
        }
        this.p = builder.a();
        return this.p;
    }

    private static long a(WorldServer level, BlockPosition pos) {
        BlockPosition blockPos = new BlockPosition(MathHelper.d((float)pos.u() / 30.0f), MathHelper.d((float)pos.v() / 20.0f), MathHelper.d((float)pos.w() / 30.0f));
        return level.E() + blockPos.a();
    }
}

