/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.BlockStructure;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class TileEntityStructure
extends TileEntity {
    private static final int d = 5;
    public static final int a = 48;
    public static final int b = 48;
    public static final String c = "author";
    @Nullable
    private MinecraftKey e;
    public String f = "";
    public String g = "";
    public BlockPosition h = new BlockPosition(0, 1, 0);
    public BaseBlockPosition i = BaseBlockPosition.h;
    public EnumBlockMirror j = EnumBlockMirror.a;
    public EnumBlockRotation k = EnumBlockRotation.a;
    public BlockPropertyStructureMode l;
    public boolean m = true;
    private boolean q;
    public boolean r;
    public boolean s = true;
    public float t = 1.0f;
    public long u;

    public TileEntityStructure(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.v, pos, blockState);
        this.l = blockState.c(BlockStructure.b);
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        tag.a("name", this.c());
        tag.a(c, this.f);
        tag.a("metadata", this.g);
        tag.a("posX", this.h.u());
        tag.a("posY", this.h.v());
        tag.a("posZ", this.h.w());
        tag.a("sizeX", this.i.u());
        tag.a("sizeY", this.i.v());
        tag.a("sizeZ", this.i.w());
        tag.a("rotation", this.k.toString());
        tag.a("mirror", this.j.toString());
        tag.a("mode", this.l.toString());
        tag.a("ignoreEntities", this.m);
        tag.a("powered", this.q);
        tag.a("showair", this.r);
        tag.a("showboundingbox", this.s);
        tag.a("integrity", this.t);
        tag.a("seed", this.u);
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.a(tag.l("name"));
        this.f = tag.l(c);
        this.g = tag.l("metadata");
        int i2 = MathHelper.a(tag.h("posX"), -48, 48);
        int i1 = MathHelper.a(tag.h("posY"), -48, 48);
        int i22 = MathHelper.a(tag.h("posZ"), -48, 48);
        this.h = new BlockPosition(i2, i1, i22);
        int i3 = MathHelper.a(tag.h("sizeX"), 0, 48);
        int i4 = MathHelper.a(tag.h("sizeY"), 0, 48);
        int i5 = MathHelper.a(tag.h("sizeZ"), 0, 48);
        this.i = new BaseBlockPosition(i3, i4, i5);
        try {
            this.k = EnumBlockRotation.valueOf(tag.l("rotation"));
        }
        catch (IllegalArgumentException var12) {
            this.k = EnumBlockRotation.a;
        }
        try {
            this.j = EnumBlockMirror.valueOf(tag.l("mirror"));
        }
        catch (IllegalArgumentException var11) {
            this.j = EnumBlockMirror.a;
        }
        try {
            this.l = BlockPropertyStructureMode.valueOf(tag.l("mode"));
        }
        catch (IllegalArgumentException var10) {
            this.l = BlockPropertyStructureMode.d;
        }
        this.m = tag.q("ignoreEntities");
        this.q = tag.q("powered");
        this.r = tag.q("showair");
        this.s = tag.q("showboundingbox");
        this.t = tag.e("integrity") ? tag.j("integrity") : 1.0f;
        this.u = tag.i("seed");
        this.F();
    }

    private void F() {
        BlockPosition blockPos;
        IBlockData blockState;
        if (this.n != null && (blockState = this.n.a_(blockPos = this.aA_())).a(Blocks.pC)) {
            this.n.a(blockPos, (IBlockData)blockState.b(BlockStructure.b, this.l), 2);
        }
    }

    public PacketPlayOutTileEntityData b() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.e(registries);
    }

    public boolean a(EntityHuman player) {
        if (!player.gG()) {
            return false;
        }
        if (player.cU().C) {
            player.a(this);
        }
        return true;
    }

    public String c() {
        return this.e == null ? "" : this.e.toString();
    }

    public boolean d() {
        return this.e != null;
    }

    public void a(@Nullable String structureName) {
        this.a(UtilColor.b(structureName) ? null : MinecraftKey.c(structureName));
    }

    public void a(@Nullable MinecraftKey structureName) {
        this.e = structureName;
    }

    public void a(EntityLiving author) {
        this.f = author.al().getString();
    }

    public BlockPosition f() {
        return this.h;
    }

    public void a(BlockPosition structurePos) {
        this.h = structurePos;
    }

    public BaseBlockPosition j() {
        return this.i;
    }

    public void a(BaseBlockPosition structureSize) {
        this.i = structureSize;
    }

    public EnumBlockMirror k() {
        return this.j;
    }

    public void a(EnumBlockMirror mirror) {
        this.j = mirror;
    }

    public EnumBlockRotation s() {
        return this.k;
    }

    public void a(EnumBlockRotation rotation) {
        this.k = rotation;
    }

    public String t() {
        return this.g;
    }

    public void b(String metaData) {
        this.g = metaData;
    }

    public BlockPropertyStructureMode u() {
        return this.l;
    }

    public void a(BlockPropertyStructureMode mode) {
        this.l = mode;
        IBlockData blockState = this.n.a_(this.aA_());
        if (blockState.a(Blocks.pC)) {
            this.n.a(this.aA_(), (IBlockData)blockState.b(BlockStructure.b, mode), 2);
        }
    }

    public boolean v() {
        return this.m;
    }

    public void a(boolean ignoreEntities) {
        this.m = ignoreEntities;
    }

    public float w() {
        return this.t;
    }

    public void a(float integrity) {
        this.t = integrity;
    }

    public long x() {
        return this.u;
    }

    public void a(long seed) {
        this.u = seed;
    }

    public boolean y() {
        if (this.l != BlockPropertyStructureMode.a) {
            return false;
        }
        BlockPosition blockPos = this.aA_();
        int i2 = 80;
        BlockPosition blockPos1 = new BlockPosition(blockPos.u() - 80, this.n.L_(), blockPos.w() - 80);
        BlockPosition blockPos2 = new BlockPosition(blockPos.u() + 80, this.n.an(), blockPos.w() + 80);
        Stream<BlockPosition> relatedCorners = this.a(blockPos1, blockPos2);
        return TileEntityStructure.a(blockPos, relatedCorners).filter(boundingBox -> {
            int i1 = boundingBox.k() - boundingBox.h();
            int i2 = boundingBox.l() - boundingBox.i();
            int i3 = boundingBox.m() - boundingBox.j();
            if (i1 > 1 && i2 > 1 && i3 > 1) {
                this.h = new BlockPosition(boundingBox.h() - blockPos.u() + 1, boundingBox.i() - blockPos.v() + 1, boundingBox.j() - blockPos.w() + 1);
                this.i = new BaseBlockPosition(i1 - 1, i2 - 1, i3 - 1);
                this.e();
                IBlockData blockState = this.n.a_(blockPos);
                this.n.a(blockPos, blockState, blockState, 3);
                return true;
            }
            return false;
        }).isPresent();
    }

    private Stream<BlockPosition> a(BlockPosition minPos, BlockPosition maxPos) {
        return BlockPosition.d(minPos, maxPos).filter(pos -> this.n.a_((BlockPosition)pos).a(Blocks.pC)).map(this.n::c_).filter(blockEntity -> blockEntity instanceof TileEntityStructure).map(blockEntity -> (TileEntityStructure)blockEntity).filter(blockEntity -> blockEntity.l == BlockPropertyStructureMode.c && Objects.equals(this.e, blockEntity.e)).map(TileEntity::aA_);
    }

    private static Optional<StructureBoundingBox> a(BlockPosition pos, Stream<BlockPosition> relatedCorners) {
        Iterator iterator = relatedCorners.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        BlockPosition blockPos = (BlockPosition)iterator.next();
        StructureBoundingBox boundingBox = new StructureBoundingBox(blockPos);
        if (iterator.hasNext()) {
            iterator.forEachRemaining(boundingBox::a);
        } else {
            boundingBox.a(pos);
        }
        return Optional.of(boundingBox);
    }

    public boolean z() {
        return this.l == BlockPropertyStructureMode.a && this.b(true);
    }

    public boolean b(boolean writeToDisk) {
        DefinedStructure structureTemplate;
        if (this.e == null) {
            return false;
        }
        BlockPosition blockPos = this.aA_().a(this.h);
        WorldServer serverLevel = (WorldServer)this.n;
        StructureTemplateManager structureManager = serverLevel.r();
        try {
            structureTemplate = structureManager.a(this.e);
        }
        catch (ResourceKeyInvalidException var8) {
            return false;
        }
        structureTemplate.a(this.n, blockPos, this.i, !this.m, Blocks.lp);
        structureTemplate.a(this.f);
        if (writeToDisk) {
            try {
                return structureManager.c(this.e);
            }
            catch (ResourceKeyInvalidException var7) {
                return false;
            }
        }
        return true;
    }

    public static RandomSource b(long seed) {
        return seed == 0L ? RandomSource.a(SystemUtils.c()) : RandomSource.a(seed);
    }

    public boolean a(WorldServer level) {
        if (this.l == BlockPropertyStructureMode.b && this.e != null) {
            DefinedStructure structureTemplate = level.r().b(this.e).orElse(null);
            if (structureTemplate == null) {
                return false;
            }
            if (structureTemplate.a().equals(this.i)) {
                this.a(level, structureTemplate);
                return true;
            }
            this.a(structureTemplate);
            return false;
        }
        return false;
    }

    public boolean b(WorldServer level) {
        DefinedStructure structureTemplate = this.d(level);
        if (structureTemplate == null) {
            return false;
        }
        this.a(structureTemplate);
        return true;
    }

    private void a(DefinedStructure structureTemplate) {
        this.f = !UtilColor.b(structureTemplate.b()) ? structureTemplate.b() : "";
        this.i = structureTemplate.a();
        this.e();
    }

    public void c(WorldServer level) {
        DefinedStructure structureTemplate = this.d(level);
        if (structureTemplate != null) {
            this.a(level, structureTemplate);
        }
    }

    @Nullable
    private DefinedStructure d(WorldServer level) {
        return this.e == null ? null : (DefinedStructure)level.r().b(this.e).orElse(null);
    }

    private void a(WorldServer level, DefinedStructure structureTemplate) {
        this.a(structureTemplate);
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(this.j).a(this.k).a(this.m);
        if (this.t < 1.0f) {
            structurePlaceSettings.b().a(new DefinedStructureProcessorRotation(MathHelper.a(this.t, 0.0f, 1.0f))).a(TileEntityStructure.b(this.u));
        }
        BlockPosition blockPos = this.aA_().a(this.h);
        structureTemplate.a(level, blockPos, blockPos, structurePlaceSettings, TileEntityStructure.b(this.u), 2);
    }

    public void A() {
        if (this.e != null) {
            WorldServer serverLevel = (WorldServer)this.n;
            StructureTemplateManager structureManager = serverLevel.r();
            structureManager.d(this.e);
        }
    }

    public boolean B() {
        if (this.l == BlockPropertyStructureMode.b && !this.n.C && this.e != null) {
            WorldServer serverLevel = (WorldServer)this.n;
            StructureTemplateManager structureManager = serverLevel.r();
            try {
                return structureManager.b(this.e).isPresent();
            }
            catch (ResourceKeyInvalidException var4) {
                return false;
            }
        }
        return false;
    }

    public boolean C() {
        return this.q;
    }

    public void c(boolean powered) {
        this.q = powered;
    }

    public boolean D() {
        return this.r;
    }

    public void d(boolean showAir) {
        this.r = showAir;
    }

    public boolean E() {
        return this.s;
    }

    public void e(boolean showBoundingBox) {
        this.s = showBoundingBox;
    }

    public static final class UpdateType
    extends Enum<UpdateType> {
        public static final /* enum */ UpdateType a = new UpdateType();
        public static final /* enum */ UpdateType b = new UpdateType();
        public static final /* enum */ UpdateType c = new UpdateType();
        public static final /* enum */ UpdateType d = new UpdateType();
        private static final /* synthetic */ UpdateType[] e;

        public static UpdateType[] values() {
            return (UpdateType[])e.clone();
        }

        public static UpdateType valueOf(String name) {
            return Enum.valueOf(UpdateType.class, name);
        }

        private static /* synthetic */ UpdateType[] a() {
            return new UpdateType[]{a, b, c, d};
        }

        static {
            e = UpdateType.a();
        }
    }
}

