/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.profile.PaperMinecraftSessionService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.Services;
import net.minecraft.util.UtilColor;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockSkullAbstract;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class TileEntitySkull
extends TileEntity {
    private static final String b = "profile";
    private static final String c = "note_block_sound";
    private static final String d = "custom_name";
    private static final Logger e = LogUtils.getLogger();
    @javax.annotation.Nullable
    private static Executor f;
    @javax.annotation.Nullable
    private static LoadingCache<String, CompletableFuture<Optional<GameProfile>>> g;
    @javax.annotation.Nullable
    private static LoadingCache<Pair<UUID, @Nullable GameProfile>, CompletableFuture<Optional<GameProfile>>> h;
    public static final Executor a;
    @javax.annotation.Nullable
    public ResolvableProfile i;
    @javax.annotation.Nullable
    public MinecraftKey j;
    private int k;
    private boolean l;
    @javax.annotation.Nullable
    private IChatBaseComponent m;

    public TileEntitySkull(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.q, pos, blockState);
    }

    public static void a(final Services services, Executor mainThreadExecutor) {
        f = mainThreadExecutor;
        final BooleanSupplier booleanSupplier = () -> h == null;
        g = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> a(String username) {
                return TileEntitySkull.a(username, services);
            }
        });
        h = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<Pair<UUID, GameProfile>, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> load(Pair<UUID, @Nullable GameProfile> id) {
                return TileEntitySkull.fetchProfileById(id, services, booleanSupplier);
            }
        });
    }

    static CompletableFuture<Optional<GameProfile>> a(String name, Services services) {
        return services.f().b(name).thenCompose(optional -> {
            LoadingCache<Pair<UUID, @Nullable GameProfile>, CompletableFuture<Optional<GameProfile>>> loadingCache = h;
            return loadingCache != null && !optional.isEmpty() ? ((CompletableFuture)loadingCache.getUnchecked((Object)new Pair((Object)((GameProfile)optional.get()).getId(), (Object)((GameProfile)optional.get())))).thenApply(optional1 -> optional1.or(() -> optional)) : CompletableFuture.completedFuture(Optional.empty());
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfileById(Pair<UUID, @Nullable GameProfile> id, Services services, BooleanSupplier cacheUninitialized) {
        return CompletableFuture.supplyAsync(() -> {
            if (cacheUninitialized.getAsBoolean()) {
                return Optional.empty();
            }
            MinecraftSessionService patt0$temp = services.c();
            if (patt0$temp instanceof PaperMinecraftSessionService) {
                PaperMinecraftSessionService paperService = (PaperMinecraftSessionService)patt0$temp;
                GameProfile profile = id.getSecond() != null ? (GameProfile)id.getSecond() : new GameProfile((UUID)id.getFirst(), "");
                return Optional.ofNullable(paperService.fetchProfile(profile, true)).map(ProfileResult::profile);
            }
            ProfileResult profileResult = services.c().fetchProfile((UUID)id.getFirst(), true);
            return Optional.ofNullable(profileResult).map(ProfileResult::profile);
        }, SystemUtils.PROFILE_EXECUTOR);
    }

    public static void b() {
        f = null;
        g = null;
        h = null;
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        if (this.i != null) {
            tag.a(b, (NBTBase)ResolvableProfile.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.i).getOrThrow());
        }
        if (this.j != null) {
            tag.a(c, this.j.toString());
        }
        if (this.m != null) {
            tag.a(d, IChatBaseComponent.ChatSerializer.a(this.m, registries));
        }
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        if (tag.e(b)) {
            ResolvableProfile.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)tag.c(b)).resultOrPartial(string -> e.error("Failed to load profile from player head: {}", string)).ifPresent(this::a);
        }
        if (tag.b(c, 8)) {
            this.j = MinecraftKey.c(tag.l(c));
        }
        this.m = tag.b(d, 8) ? TileEntitySkull.a(tag.l(d), registries) : null;
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntitySkull blockEntity) {
        if (state.b(BlockSkullAbstract.a) && state.c(BlockSkullAbstract.a).booleanValue()) {
            blockEntity.l = true;
            ++blockEntity.k;
        } else {
            blockEntity.l = false;
        }
    }

    public float a(float partialTick) {
        return this.l ? (float)this.k + partialTick : (float)this.k;
    }

    @javax.annotation.Nullable
    public ResolvableProfile c() {
        return this.i;
    }

    @javax.annotation.Nullable
    public MinecraftKey d() {
        return this.j;
    }

    public PacketPlayOutTileEntityData f() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.e(registries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(@javax.annotation.Nullable ResolvableProfile owner) {
        TileEntitySkull tileEntitySkull = this;
        synchronized (tileEntitySkull) {
            this.i = owner;
        }
        this.j();
    }

    private void j() {
        if (this.i != null && !this.i.b()) {
            this.i.a().thenAcceptAsync(resolvableProfile -> {
                this.i = resolvableProfile;
                this.e();
            }, a);
        } else {
            this.e();
        }
    }

    public static CompletableFuture<Optional<GameProfile>> a(String profileName) {
        LoadingCache<String, CompletableFuture<Optional<GameProfile>>> loadingCache = g;
        return loadingCache != null && UtilColor.f(profileName) ? (CompletableFuture)loadingCache.getUnchecked((Object)profileName) : CompletableFuture.completedFuture(Optional.empty());
    }

    public static CompletableFuture<Optional<GameProfile>> fetchGameProfile(UUID profileUuid, @javax.annotation.Nullable String name) {
        LoadingCache<Pair<UUID, @Nullable GameProfile>, CompletableFuture<Optional<GameProfile>>> loadingCache = h;
        return loadingCache != null ? (CompletableFuture)loadingCache.getUnchecked((Object)new Pair((Object)profileUuid, (Object)(name != null ? new GameProfile(profileUuid, name) : null))) : CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    protected void a(TileEntity.b componentInput) {
        super.a(componentInput);
        this.a(componentInput.a(DataComponents.ag));
        this.j = componentInput.a(DataComponents.ah);
        this.m = componentInput.a(DataComponents.g);
    }

    @Override
    protected void a(DataComponentMap.a components) {
        super.a(components);
        components.a(DataComponents.ag, this.i);
        components.a(DataComponents.ah, this.j);
        components.a(DataComponents.g, this.m);
    }

    @Override
    public void a(NBTTagCompound tag) {
        super.a(tag);
        tag.r(b);
        tag.r(c);
        tag.r(d);
    }

    static {
        a = runnable -> {
            Executor executor = f;
            if (executor != null) {
                executor.execute(runnable);
            }
        };
    }
}

