/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.commands.DelegatingCommandSource;
import io.papermc.paper.event.player.PlayerSignCommandPreprocessEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R3.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.util.LazyPlayerSet;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class TileEntitySign
extends TileEntity {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 90;
    private static final int c = 10;
    @Nullable
    public UUID d;
    private SignText e = this.f();
    private SignText f = this.f();
    private boolean g;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public void a(IChatBaseComponent message) {
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper commandSourceStack) {
            return commandSourceStack.f() != null ? commandSourceStack.f().getBukkitEntity() : new CraftBlockCommandSender(commandSourceStack, TileEntitySign.this);
        }

        @Override
        public boolean y_() {
            return false;
        }

        @Override
        public boolean z_() {
            return false;
        }

        @Override
        public boolean c() {
            return false;
        }
    };

    public TileEntitySign(BlockPosition pos, IBlockData blockState) {
        this((TileEntityTypes)TileEntityTypes.h, pos, blockState);
    }

    public TileEntitySign(TileEntityTypes type, BlockPosition pos, IBlockData blockState) {
        super(type, pos, blockState);
    }

    protected SignText f() {
        return new SignText();
    }

    public boolean a(EntityHuman player) {
        return this.isFacingFrontText(player.dA(), player.dG());
    }

    public boolean isFacingFrontText(double x2, double z2) {
        Block block = this.m().b();
        if (block instanceof BlockSign) {
            float f2;
            BlockSign signBlock = (BlockSign)block;
            Vec3D signHitboxCenterPosition = signBlock.o(this.m());
            double d2 = x2 - ((double)this.aA_().u() + signHitboxCenterPosition.d);
            double d1 = z2 - ((double)this.aA_().w() + signHitboxCenterPosition.f);
            float yRotationDegrees = signBlock.h(this.m());
            return MathHelper.d(yRotationDegrees, f2 = (float)(MathHelper.d(d1, d2) * 180.0 / 3.1415927410125732) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText a(boolean isFrontText) {
        return isFrontText ? this.e : this.f;
    }

    public SignText j() {
        return this.e;
    }

    public SignText k() {
        return this.f;
    }

    public int b() {
        return 10;
    }

    public int c() {
        return 90;
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        RegistryOps<NBTBase> dynamicOps = registries.a(DynamicOpsNBT.a);
        SignText.a.encodeStart(dynamicOps, (Object)this.e).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(frontTextTag -> tag.a("front_text", (NBTBase)frontTextTag));
        SignText.a.encodeStart(dynamicOps, (Object)this.f).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(backTextTag -> tag.a("back_text", (NBTBase)backTextTag));
        tag.a("is_waxed", this.g);
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        RegistryOps<NBTBase> dynamicOps = registries.a(DynamicOpsNBT.a);
        if (tag.e("front_text")) {
            SignText.a.parse(dynamicOps, (Object)tag.p("front_text")).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(signText -> {
                this.e = this.a((SignText)signText);
            });
        }
        if (tag.e("back_text")) {
            SignText.a.parse(dynamicOps, (Object)tag.p("back_text")).resultOrPartial(arg_0 -> ((Logger)a).error(arg_0)).ifPresent(signText -> {
                this.f = this.a((SignText)signText);
            });
        }
        this.g = tag.q("is_waxed");
    }

    private SignText a(SignText text) {
        for (int i2 = 0; i2 < 4; ++i2) {
            IChatBaseComponent component = this.a(text.a(i2, false));
            IChatBaseComponent component1 = this.a(text.a(i2, true));
            text = text.a(i2, component, component1);
        }
        return text;
    }

    private IChatBaseComponent a(IChatBaseComponent lineText) {
        World world = this.n;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            try {
                return ChatComponentUtils.a(this.a(null, (World)serverLevel, this.o), lineText, null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return lineText;
    }

    public void a(EntityHuman player, boolean isFrontText, List<FilteredText> filteredText) {
        if (!this.u() && player.cG().equals(this.t()) && this.n != null) {
            this.a(signText -> this.setMessages(player, filteredText, (SignText)signText, isFrontText), isFrontText);
            this.a((UUID)null);
            this.n.a(this.aA_(), this.m(), this.m(), 3);
        } else {
            a.warn("Player {} just tried to change non-editable sign", (Object)player.al().getString());
            if (player.i(this.aA_().u(), this.aA_().v(), this.aA_().w()) < (double)MathHelper.h(32)) {
                ((EntityPlayer)player).f.b(this.s());
            }
        }
    }

    public boolean a(UnaryOperator<SignText> updater, boolean isFrontText) {
        SignText text = this.a(isFrontText);
        return this.a((SignText)updater.apply(text), isFrontText);
    }

    private SignText setMessages(EntityHuman player, List<FilteredText> filteredText, SignText text, boolean front) {
        SignText originalText = text;
        for (int i2 = 0; i2 < filteredText.size(); ++i2) {
            FilteredText filteredText1 = filteredText.get(i2);
            ChatModifier style = text.a(i2, player.aa()).a();
            text = player.aa() ? text.a(i2, IChatBaseComponent.b(UtilColor.g(filteredText1.b())).b(style)) : text.a(i2, IChatBaseComponent.b(filteredText1.d()).b(style), IChatBaseComponent.b(UtilColor.g(filteredText1.b())).b(style));
        }
        CraftPlayer apiPlayer = ((EntityPlayer)player).getBukkitEntity();
        ArrayList<Component> lines = new ArrayList<Component>();
        for (int i3 = 0; i3 < filteredText.size(); ++i3) {
            lines.add(PaperAdventure.asAdventure(text.a(i3, player.aa())));
        }
        SignChangeEvent event = new SignChangeEvent((org.bukkit.block.Block)CraftBlock.at(this.n, this.o), (Player)apiPlayer, new ArrayList(lines), front ? Side.FRONT : Side.BACK);
        if (!event.callEvent()) {
            return originalText;
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(event.lines());
        for (int i4 = 0; i4 < components.length; ++i4) {
            if (Objects.equals(lines.get(i4), event.line(i4))) continue;
            text = text.a(i4, components[i4]);
        }
        return text;
    }

    public boolean a(SignText text, boolean isFrontText) {
        return isFrontText ? this.c(text) : this.b(text);
    }

    private boolean b(SignText text) {
        if (text != this.f) {
            this.f = text;
            this.v();
            return true;
        }
        return false;
    }

    private boolean c(SignText text) {
        if (text != this.e) {
            this.e = text;
            this.v();
            return true;
        }
        return false;
    }

    public boolean a(boolean isFrontText, EntityHuman player) {
        return this.u() && this.a(isFrontText).b(player);
    }

    public boolean a(EntityHuman player, World level, BlockPosition pos, boolean frontText) {
        boolean flag = false;
        for (IChatBaseComponent component : this.a(frontText).b(player.aa())) {
            PlayerSignCommandPreprocessEvent event;
            Object command;
            ChatModifier style = component.a();
            ChatClickable clickEvent = style.i();
            if (clickEvent == null || clickEvent.a() != ChatClickable.EnumClickAction.c) continue;
            Object object = command = clickEvent.b().startsWith("/") ? clickEvent.b() : "/" + clickEvent.b();
            if (SpigotConfig.logCommands) {
                a.info("{} issued server command: {}", (Object)player.cI(), command);
            }
            if (!(event = new PlayerSignCommandPreprocessEvent((Player)player.getBukkitEntity(), (String)command, (Set)new LazyPlayerSet(player.cV()), (Sign)CraftBlock.at(this.n, this.o).getState(), frontText ? Side.FRONT : Side.BACK)).callEvent()) {
                return false;
            }
            player.cV().aG().a(this.a((EntityHuman)((CraftPlayer)event.getPlayer()).getHandle(), level, pos), event.getMessage());
            flag = true;
        }
        return flag;
    }

    private CommandListenerWrapper a(final @Nullable EntityHuman player, World level, BlockPosition pos) {
        String string = player == null ? "Sign" : player.al().getString();
        IChatBaseComponent component = player == null ? IChatBaseComponent.b("Sign") : player.p_();
        ICommandListener commandSource = level.paperConfig().misc.showSignClickCommandFailureMsgsToPlayer ? new DelegatingCommandSource(this, this.commandSource){

            @Override
            public void a(IChatBaseComponent message) {
                if (player instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)player;
                    serverPlayer.a(message);
                }
            }

            @Override
            public boolean z_() {
                return true;
            }
        } : this.commandSource;
        return new CommandListenerWrapper(commandSource, Vec3D.b(pos), Vec2F.a, (WorldServer)level, 2, string, component, level.p(), player);
    }

    public PacketPlayOutTileEntityData s() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.e(registries);
    }

    public void a(@Nullable UUID playWhoMayEdit) {
        this.d = playWhoMayEdit;
    }

    @Nullable
    public UUID t() {
        if (this.n != null && this.d != null) {
            this.a(this, this.n, this.d);
        }
        return this.d;
    }

    private void v() {
        this.e();
        if (this.n != null) {
            this.n.a(this.aA_(), this.m(), this.m(), 3);
        }
    }

    public boolean u() {
        return this.g;
    }

    public boolean b(boolean isWaxed) {
        if (this.g != isWaxed) {
            this.g = isWaxed;
            this.v();
            return true;
        }
        return false;
    }

    public boolean b(UUID uuid) {
        EntityHuman playerByUuid = this.n.b(uuid);
        return playerByUuid == null || !playerByUuid.a(this.aA_(), 4.0);
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntitySign sign) {
        UUID playerWhoMayEdit = sign.t();
        if (playerWhoMayEdit != null) {
            sign.a(sign, level, playerWhoMayEdit);
        }
    }

    private void a(TileEntitySign sign, World level, UUID uuid) {
        if (sign.b(uuid)) {
            sign.a((UUID)null);
        }
    }

    public SoundEffect d() {
        return SoundEffects.CP;
    }
}

