/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeCraftingHolder,
AutoRecipeOutput {
    protected static final int b = 0;
    protected static final int c = 1;
    protected static final int d = 2;
    public static final int e = 0;
    private static final int[] q = new int[]{0};
    private static final int[] r = new int[]{2, 1};
    private static final int[] s = new int[]{1};
    public static final int f = 1;
    public static final int g = 2;
    public static final int h = 3;
    public static final int i = 4;
    public static final int j = 200;
    public static final int k = 2;
    protected NonNullList<net.minecraft.world.item.ItemStack> l = NonNullList.a(3, net.minecraft.world.item.ItemStack.j);
    public int t;
    int u;
    public int v;
    public int w;
    protected final IContainerProperties m = new IContainerProperties(){

        @Override
        public int a(int index) {
            switch (index) {
                case 0: {
                    return TileEntityFurnace.this.t;
                }
                case 1: {
                    return TileEntityFurnace.this.u;
                }
                case 2: {
                    return TileEntityFurnace.this.v;
                }
                case 3: {
                    return TileEntityFurnace.this.w;
                }
            }
            return 0;
        }

        @Override
        public void a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityFurnace.this.t = value;
                    break;
                }
                case 1: {
                    TileEntityFurnace.this.u = value;
                    break;
                }
                case 2: {
                    TileEntityFurnace.this.v = value;
                    break;
                }
                case 3: {
                    TileEntityFurnace.this.w = value;
                }
            }
        }

        @Override
        public int a() {
            return 4;
        }
    };
    public final Reference2IntOpenHashMap<ResourceKey<IRecipe<?>>> x = new Reference2IntOpenHashMap();
    private final CraftingManager.a<SingleRecipeInput, ? extends RecipeCooking> y;
    public final Recipes<? extends RecipeCooking> recipeType;
    public double cookSpeedMultiplier = 1.0;
    private int maxStack = 99;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected TileEntityFurnace(TileEntityTypes<?> type, BlockPosition pos, IBlockData blockState, Recipes<? extends RecipeCooking> recipeType) {
        super(type, pos, blockState);
        this.y = CraftingManager.a(recipeType);
        this.recipeType = recipeType;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.l;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int an_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    private boolean k() {
        return this.t > 0;
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.l = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.j);
        ContainerUtil.b(tag, this.l, registries);
        this.v = tag.g("cooking_time_spent");
        this.w = tag.g("cooking_total_time");
        this.t = tag.g("lit_time_remaining");
        this.u = tag.g("lit_total_time");
        NBTTagCompound compound = tag.p("RecipesUsed");
        for (String string : compound.e()) {
            MinecraftKey resourceLocation = MinecraftKey.c(string);
            if (resourceLocation == null) continue;
            this.x.put(ResourceKey.a(Registries.bk, resourceLocation), compound.h(string));
        }
        if (tag.e("Paper.CookSpeedMultiplier")) {
            this.cookSpeedMultiplier = tag.k("Paper.CookSpeedMultiplier");
        }
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        tag.a("cooking_time_spent", (short)this.v);
        tag.a("cooking_total_time", (short)this.w);
        tag.a("lit_time_remaining", (short)this.t);
        tag.a("lit_total_time", (short)this.u);
        tag.a("Paper.CookSpeedMultiplier", this.cookSpeedMultiplier);
        ContainerUtil.a(tag, this.l, registries);
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.x.forEach((recipe, count) -> compoundTag.a(recipe.a().toString(), (int)count));
        tag.a("RecipesUsed", compoundTag);
    }

    public static void a(WorldServer level, BlockPosition pos, IBlockData state, TileEntityFurnace furnace) {
        boolean flag2;
        boolean isLit = furnace.k();
        boolean flag = false;
        if (furnace.k()) {
            --furnace.t;
        }
        net.minecraft.world.item.ItemStack itemStack = furnace.l.get(1);
        net.minecraft.world.item.ItemStack itemStack1 = furnace.l.get(0);
        boolean flag1 = !itemStack1.f();
        boolean bl = flag2 = !itemStack.f();
        if (furnace.k() || flag2 && flag1) {
            SingleRecipeInput singleRecipeInput = new SingleRecipeInput(itemStack1);
            RecipeHolder recipeHolder = flag1 ? (RecipeHolder)furnace.y.a(singleRecipeInput, level).orElse(null) : null;
            int maxStackSize = furnace.an_();
            if (!furnace.k() && TileEntityFurnace.a(level.K_(), recipeHolder, singleRecipeInput, furnace.l, maxStackSize)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemStack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(level, pos), (ItemStack)fuel, furnace.a(level.M(), itemStack));
                if (!furnaceBurnEvent.callEvent()) {
                    return;
                }
                furnace.u = furnace.t = furnaceBurnEvent.getBurnTime();
                if (furnace.k() && furnaceBurnEvent.isBurning()) {
                    flag = true;
                    if (flag2 && furnaceBurnEvent.willConsumeFuel()) {
                        Item item = itemStack.h();
                        itemStack.h(1);
                        if (itemStack.f()) {
                            furnace.l.set(1, item.k());
                        }
                    }
                }
            }
            if (furnace.k() && TileEntityFurnace.a(level.K_(), recipeHolder, singleRecipeInput, furnace.l, maxStackSize)) {
                if (recipeHolder != null && furnace.v == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(furnace.l.get(0));
                    CookingRecipe recipe = (CookingRecipe)recipeHolder.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(level, pos), (ItemStack)source, recipe, TileEntityFurnace.getTotalCookTime(level, furnace, furnace.recipeType, furnace.cookSpeedMultiplier));
                    event.callEvent();
                    furnace.w = event.getTotalCookTime();
                }
                ++furnace.v;
                if (furnace.v >= furnace.w) {
                    furnace.v = 0;
                    furnace.w = TileEntityFurnace.getTotalCookTime(level, furnace, furnace.recipeType, furnace.cookSpeedMultiplier);
                    if (TileEntityFurnace.burn(level.K_(), recipeHolder, singleRecipeInput, furnace.l, maxStackSize, level, furnace.o)) {
                        furnace.a(recipeHolder);
                    }
                    flag = true;
                }
            } else {
                furnace.v = 0;
            }
        } else if (!furnace.k() && furnace.v > 0) {
            furnace.v = MathHelper.a(furnace.v - 2, 0, furnace.w);
        }
        if (isLit != furnace.k()) {
            flag = true;
            state = (IBlockData)state.b(BlockFurnace.b, furnace.k());
            level.a(pos, state, 3);
        }
        if (flag) {
            TileEntityFurnace.a(level, pos, state);
        }
    }

    private static boolean a(IRegistryCustom registryAccess, @Nullable RecipeHolder<? extends RecipeCooking> recipe, SingleRecipeInput recipeInput, NonNullList<net.minecraft.world.item.ItemStack> items, int maxStackSize) {
        if (!items.get(0).f() && recipe != null) {
            net.minecraft.world.item.ItemStack itemStack = recipe.b().a(recipeInput, (HolderLookup.a)registryAccess);
            if (itemStack.f()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemStack1 = items.get(2);
            return itemStack1.f() || net.minecraft.world.item.ItemStack.c(itemStack1, itemStack) && (itemStack1.M() < maxStackSize && itemStack1.M() < itemStack1.k() || itemStack1.M() < itemStack.k());
        }
        return false;
    }

    private static boolean burn(IRegistryCustom registryAccess, @Nullable RecipeHolder<? extends RecipeCooking> recipe, SingleRecipeInput recipeInput, NonNullList<net.minecraft.world.item.ItemStack> items, int maxStackSize, World level, BlockPosition blockPos) {
        if (recipe != null && TileEntityFurnace.a(registryAccess, recipe, recipeInput, items, maxStackSize)) {
            net.minecraft.world.item.ItemStack itemStack2;
            net.minecraft.world.item.ItemStack itemStack1;
            net.minecraft.world.item.ItemStack itemStack;
            net.minecraft.world.item.ItemStack ingredient = itemStack = items.get(0);
            net.minecraft.world.item.ItemStack result = itemStack1 = recipe.b().a(recipeInput, (HolderLookup.a)registryAccess);
            net.minecraft.world.item.ItemStack existingResults = itemStack2 = items.get(2);
            CraftItemStack apiIngredient = CraftItemStack.asCraftMirror(ingredient);
            ItemStack apiResult = CraftItemStack.asBukkitCopy(result);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(level, blockPos), (ItemStack)apiIngredient, apiResult, (CookingRecipe)recipe.toBukkitRecipe());
            if (!furnaceSmeltEvent.callEvent()) {
                return false;
            }
            apiResult = furnaceSmeltEvent.getResult();
            itemStack1 = result = CraftItemStack.asNMSCopy(apiResult);
            if (!result.f()) {
                if (existingResults.f()) {
                    items.set(2, result.v());
                } else if (CraftItemStack.asCraftMirror(existingResults).isSimilar(apiResult)) {
                    existingResults.g(result.M());
                } else {
                    return false;
                }
            }
            if (itemStack.a(Blocks.aW.j()) && !items.get(1).f() && items.get(1).a(Items.rf)) {
                items.set(1, new net.minecraft.world.item.ItemStack(Items.rg));
            }
            itemStack.h(1);
            return true;
        }
        return false;
    }

    protected int a(FuelValues fuelValues, net.minecraft.world.item.ItemStack stack) {
        return fuelValues.b(stack);
    }

    public static int getTotalCookTime(@Nullable WorldServer level, TileEntityFurnace furnace, Recipes<? extends RecipeCooking> recipeType, double cookSpeedMultiplier) {
        SingleRecipeInput singleRecipeInput = new SingleRecipeInput(furnace.a(0));
        int cookTime = level != null ? furnace.y.a(singleRecipeInput, level).map(holder -> ((RecipeCooking)holder.b()).d()).orElse(200) : MinecraftServer.getServer().aI().a(recipeType, singleRecipeInput, level).map(holder -> ((RecipeCooking)holder.b()).d()).orElse(200);
        return (int)Math.ceil((double)cookTime / cookSpeedMultiplier);
    }

    @Override
    public int[] a(EnumDirection side) {
        if (side == EnumDirection.a) {
            return r;
        }
        return side == EnumDirection.b ? q : s;
    }

    @Override
    public boolean a(int index, net.minecraft.world.item.ItemStack itemStack, @Nullable EnumDirection direction) {
        return this.b(index, itemStack);
    }

    @Override
    public boolean b(int index, net.minecraft.world.item.ItemStack stack, EnumDirection direction) {
        return direction != EnumDirection.a || index != 1 || stack.a(Items.rg) || stack.a(Items.rf);
    }

    @Override
    public int b() {
        return this.l.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> f() {
        return this.l;
    }

    @Override
    protected void a(NonNullList<net.minecraft.world.item.ItemStack> items) {
        this.l = items;
    }

    @Override
    public void a(int index, net.minecraft.world.item.ItemStack stack) {
        World world;
        net.minecraft.world.item.ItemStack itemStack = this.l.get(index);
        boolean flag = !stack.f() && net.minecraft.world.item.ItemStack.c(itemStack, stack);
        this.l.set(index, stack);
        stack.f(this.e_(stack));
        if (index == 0 && !flag && (world = this.n) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            this.w = TileEntityFurnace.getTotalCookTime(serverLevel, this, this.recipeType, this.cookSpeedMultiplier);
            this.v = 0;
            this.e();
        }
    }

    @Override
    public boolean b(int index, net.minecraft.world.item.ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemStack = this.l.get(1);
        return this.n.M().a(stack) || stack.a(Items.rf) && !itemStack.a(Items.rf);
    }

    @Override
    public void a(@Nullable RecipeHolder<?> recipe) {
        if (recipe != null) {
            ResourceKey<IRecipe<?>> resourceKey = recipe.a();
            this.x.addTo(resourceKey, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> d() {
        return null;
    }

    @Override
    public void a(EntityHuman player, List<net.minecraft.world.item.ItemStack> items) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer player, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<RecipeHolder<?>> recipesToAwardAndPopExperience = this.getRecipesToAwardAndPopExperience(player.y(), player.dt(), this.o, player, itemstack, amount);
        player.a((Collection<RecipeHolder<?>>)recipesToAwardAndPopExperience);
        for (RecipeHolder<?> recipeHolder : recipesToAwardAndPopExperience) {
            if (recipeHolder == null) continue;
            player.a(recipeHolder, this.l);
        }
        this.x.clear();
    }

    public List<RecipeHolder<?>> a(WorldServer level, Vec3D popVec) {
        return this.getRecipesToAwardAndPopExperience(level, popVec, this.o, null, null, 0);
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(WorldServer level, Vec3D popVec, BlockPosition blockPos, EntityPlayer serverPlayer, net.minecraft.world.item.ItemStack itemStack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Reference2IntMap.Entry entry : this.x.reference2IntEntrySet()) {
            level.t().b((ResourceKey)entry.getKey()).ifPresent(recipe -> {
                if (!(recipe.b() instanceof RecipeCooking)) {
                    return;
                }
                list.add(recipe);
                TileEntityFurnace.createExperience(level, popVec, entry.getIntValue(), ((RecipeCooking)recipe.b()).c(), blockPos, serverPlayer, itemStack, amount);
            });
        }
        return list;
    }

    private static void createExperience(WorldServer level, Vec3D popVec, int recipeIndex, float experience, BlockPosition blockPos, EntityPlayer serverPlayer, net.minecraft.world.item.ItemStack itemStack, int amount) {
        int floor = MathHelper.d((float)recipeIndex * experience);
        float fraction = MathHelper.i((float)recipeIndex * experience);
        if (fraction != 0.0f && Math.random() < (double)fraction) {
            ++floor;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((Player)serverPlayer.getBukkitEntity(), (Block)CraftBlock.at(level, blockPos), CraftItemType.minecraftToBukkit(itemStack.h()), amount, floor) : new BlockExpEvent((Block)CraftBlock.at(level, blockPos), floor);
        event.callEvent();
        floor = event.getExpToDrop();
        EntityExperienceOrb.award(level, popVec, floor, ExperienceOrb.SpawnReason.FURNACE, serverPlayer);
    }

    @Override
    public void fillStackedContents(StackedItemContents stackedContents) {
        stackedContents.b(this.l.get(0));
        stackedContents.b(this.l.get(2));
        for (net.minecraft.world.item.ItemStack itemStack : this.l) {
            stackedContents.b(itemStack);
        }
    }
}

