/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryLargeChest;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;

public class TileEntityChest
extends TileEntityLootable
implements LidBlockEntity {
    private static final int d = 1;
    private NonNullList<ItemStack> e = NonNullList.a(27, ItemStack.j);
    public final ContainerOpenersCounter f = new ContainerOpenersCounter(){

        @Override
        protected void a(World level, BlockPosition pos, IBlockData state) {
            TileEntityChest.a(level, pos, state, SoundEffects.eS);
        }

        @Override
        protected void b(World level, BlockPosition pos, IBlockData state) {
            TileEntityChest.a(level, pos, state, SoundEffects.eQ);
        }

        @Override
        protected void a(World level, BlockPosition pos, IBlockData state, int count, int openCount) {
            TileEntityChest.this.a(level, pos, state, count, openCount);
        }

        @Override
        protected boolean a(EntityHuman player) {
            if (!(player.cd instanceof ContainerChest)) {
                return false;
            }
            IInventory container = ((ContainerChest)player.cd).l();
            return container == TileEntityChest.this || container instanceof InventoryLargeChest && ((InventoryLargeChest)container).a(TileEntityChest.this);
        }
    };
    private final ChestLidController g = new ChestLidController();
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        return this.e;
    }

    @Override
    public void onOpen(CraftHumanEntity player) {
        this.transaction.add(player);
    }

    @Override
    public void onClose(CraftHumanEntity player) {
        this.transaction.remove(player);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int an_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    protected TileEntityChest(TileEntityTypes<?> type, BlockPosition pos, IBlockData blockState) {
        super(type, pos, blockState);
    }

    public TileEntityChest(BlockPosition pos, IBlockData blockState) {
        this(TileEntityTypes.b, pos, blockState);
    }

    @Override
    public int b() {
        return 27;
    }

    @Override
    protected IChatBaseComponent j() {
        return IChatBaseComponent.c("container.chest");
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.e = NonNullList.a(this.b(), ItemStack.j);
        if (!this.b_(tag)) {
            ContainerUtil.b(tag, this.e, registries);
        }
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        if (!this.c_(tag)) {
            ContainerUtil.a(tag, this.e, registries);
        }
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntityChest blockEntity) {
        blockEntity.g.a();
    }

    public static void a(World level, BlockPosition pos, IBlockData state, SoundEffect sound) {
        BlockPropertyChestType chestType = state.c(BlockChest.d);
        if (chestType != BlockPropertyChestType.b) {
            double d2 = (double)pos.u() + 0.5;
            double d1 = (double)pos.v() + 0.5;
            double d22 = (double)pos.w() + 0.5;
            if (chestType == BlockPropertyChestType.c) {
                EnumDirection connectedDirection = BlockChest.i(state);
                d2 += (double)connectedDirection.j() * 0.5;
                d22 += (double)connectedDirection.l() * 0.5;
            }
            level.a(null, d2, d1, d22, sound, SoundCategory.e, 0.5f, level.A.i() * 0.1f + 0.9f);
        }
    }

    @Override
    public boolean a_(int id, int type) {
        if (id == 1) {
            this.g.a(type > 0);
            return true;
        }
        return super.a_(id, type);
    }

    @Override
    public void c_(EntityHuman player) {
        if (!this.p && !player.Z_()) {
            this.f.a(player, this.i(), this.aA_(), this.m());
        }
    }

    @Override
    public void c(EntityHuman player) {
        if (!this.p && !player.Z_()) {
            this.f.b(player, this.i(), this.aA_(), this.m());
        }
    }

    @Override
    protected NonNullList<ItemStack> f() {
        return this.e;
    }

    @Override
    protected void a(NonNullList<ItemStack> items) {
        this.e = items;
    }

    @Override
    public float a(float partialTicks) {
        return this.g.a(partialTicks);
    }

    public static int a(IBlockAccess level, BlockPosition pos) {
        TileEntity blockEntity;
        IBlockData blockState = level.a_(pos);
        if (blockState.x() && (blockEntity = level.c_(pos)) instanceof TileEntityChest) {
            return ((TileEntityChest)blockEntity).f.a();
        }
        return 0;
    }

    public static void a(TileEntityChest chest, TileEntityChest otherChest) {
        NonNullList<ItemStack> items = chest.f();
        chest.a(otherChest.f());
        otherChest.a(items);
    }

    @Override
    protected Container a(int id, PlayerInventory player) {
        return ContainerChest.a(id, player, this);
    }

    public void k() {
        if (!this.p) {
            this.f.c(this.i(), this.aA_(), this.m());
        }
    }

    protected void a(World level, BlockPosition pos, IBlockData state, int eventId, int eventParam) {
        Block block = state.b();
        level.a(pos, block, 1, eventParam);
    }
}

