/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.slf4j.Logger;

public class TileEntityBeehive
extends TileEntity {
    private static final Logger c = LogUtils.getLogger();
    private static final String d = "flower_pos";
    private static final String e = "bees";
    static final List<String> f = Arrays.asList("Air", "ArmorDropChances", "ArmorItems", "Brain", "CanPickUpLoot", "DeathTime", "FallDistance", "FallFlying", "Fire", "HandDropChances", "HandItems", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "SleepingX", "SleepingY", "SleepingZ", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "hive_pos", "Passengers", "leash", "UUID");
    public static final int a = 3;
    private static final int g = 400;
    private static final int h = 2400;
    public static final int b = 600;
    private List<HiveBee> i = Lists.newArrayList();
    @Nullable
    public BlockPosition j;
    public int maxBees = 3;

    public TileEntityBeehive(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.I, pos, blockState);
    }

    @Override
    public void e() {
        if (this.b()) {
            this.a(null, this.n.a_(this.aA_()), ReleaseStatus.c);
        }
        super.e();
    }

    public boolean b() {
        if (this.n == null) {
            return false;
        }
        for (BlockPosition blockPos : BlockPosition.c(this.o.b(-1, -1, -1), this.o.b(1, 1, 1))) {
            if (!(this.n.a_(blockPos).b() instanceof BlockFire)) continue;
            return true;
        }
        return false;
    }

    public boolean c() {
        return this.i.isEmpty();
    }

    public boolean d() {
        return this.i.size() == this.maxBees;
    }

    public void a(@Nullable EntityHuman player, IBlockData state, ReleaseStatus releaseStatus) {
        List<net.minecraft.world.entity.Entity> list = this.a(state, releaseStatus);
        if (player != null) {
            for (net.minecraft.world.entity.Entity entity : list) {
                if (!(entity instanceof EntityBee)) continue;
                EntityBee bee = (EntityBee)entity;
                if (!(player.dt().g(entity.dt()) <= 16.0)) continue;
                if (!this.j()) {
                    bee.setTarget(player, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
                    continue;
                }
                bee.s(400);
            }
        }
    }

    private List<net.minecraft.world.entity.Entity> a(IBlockData state, ReleaseStatus releaseStatus) {
        return this.releaseBees(state, releaseStatus, false);
    }

    public List<net.minecraft.world.entity.Entity> releaseBees(IBlockData state, ReleaseStatus releaseStatus, boolean force) {
        ArrayList list = Lists.newArrayList();
        this.i.removeIf(data -> TileEntityBeehive.releaseOccupant(this.n, this.o, state, data.b(), list, releaseStatus, this.j, force));
        if (!list.isEmpty()) {
            super.e();
        }
        return list;
    }

    @VisibleForDebug
    public int f() {
        return this.i.size();
    }

    public void clearBees() {
        this.i.clear();
    }

    public static int a(IBlockData state) {
        return state.c(BlockBeehive.c);
    }

    @VisibleForDebug
    public boolean j() {
        return BlockCampfire.a(this.n, this.aA_());
    }

    public void a(EntityBee bee) {
        if (this.i.size() < this.maxBees) {
            EntityEnterBlockEvent event;
            if (this.n != null && !(event = new EntityEnterBlockEvent((Entity)bee.getBukkitEntity(), (Block)CraftBlock.at(this.n, this.aA_()))).callEvent()) {
                bee.s(400);
                return;
            }
            bee.ae();
            bee.bP();
            bee.z();
            this.a(net.minecraft.world.level.block.entity.TileEntityBeehive$c.a(bee));
            if (this.n != null) {
                if (bee.t() && (!this.k() || this.n.A.h())) {
                    this.j = bee.p();
                }
                BlockPosition blockPos = this.aA_();
                this.n.a(null, (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w(), SoundEffects.bV, SoundCategory.e, 1.0f, 1.0f);
                this.n.a(GameEvent.c, blockPos, GameEvent.a.a(bee, this.m()));
            }
            bee.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
            super.e();
        }
    }

    public void a(c occupant) {
        this.i.add(new HiveBee(occupant));
    }

    private static boolean a(World level, BlockPosition pos, IBlockData state, c occupant, @Nullable List<net.minecraft.world.entity.Entity> storedInHives, ReleaseStatus releaseStatus, @Nullable BlockPosition storedFlowerPos) {
        return TileEntityBeehive.releaseOccupant(level, pos, state, occupant, storedInHives, releaseStatus, storedFlowerPos, false);
    }

    private static boolean releaseOccupant(World level, BlockPosition pos, IBlockData state, c occupant, @Nullable List<net.minecraft.world.entity.Entity> storedInHives, ReleaseStatus releaseStatus, @Nullable BlockPosition storedFlowerPos, boolean force) {
        boolean flag;
        if (!force && EntityBee.c(level) && releaseStatus != ReleaseStatus.c) {
            return false;
        }
        EnumDirection direction = state.c(BlockBeehive.b);
        BlockPosition blockPos = pos.a(direction);
        boolean bl = flag = !level.a_(blockPos).g(level, blockPos).c();
        if (flag && releaseStatus != ReleaseStatus.c) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = occupant.a(level, pos);
        if (entity != null) {
            if (entity instanceof EntityBee) {
                float bbWidth = entity.dq();
                double d2 = flag ? 0.0 : 0.55 + (double)(bbWidth / 2.0f);
                double d1 = (double)pos.u() + 0.5 + d2 * (double)direction.j();
                double d22 = (double)pos.v() + 0.5 - (double)(entity.dr() / 2.0f);
                double d3 = (double)pos.w() + 0.5 + d2 * (double)direction.l();
                entity.b(d1, d22, d3, entity.dL(), entity.dN());
            }
            if (!level.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.BEEHIVE)) {
                return false;
            }
            if (entity instanceof EntityBee) {
                EntityBee bee = (EntityBee)entity;
                if (storedFlowerPos != null && !bee.t() && level.A.i() < 0.9f) {
                    bee.h(storedFlowerPos);
                }
                if (releaseStatus == ReleaseStatus.a) {
                    int honeyLevel;
                    bee.gI();
                    if (state.a(TagsBlock.aJ, (BlockBase.BlockData blockStateBase) -> blockStateBase.b(BlockBeehive.c)) && (honeyLevel = TileEntityBeehive.a(state)) < 5) {
                        IBlockData newBlockState;
                        int i2;
                        int n2 = i2 = level.A.a(100) == 0 ? 2 : 1;
                        if (honeyLevel + i2 > 5) {
                            --i2;
                        }
                        if (CraftEventFactory.callEntityChangeBlockEvent(entity, pos, newBlockState = (IBlockData)state.b(BlockBeehive.c, honeyLevel + i2))) {
                            level.b(pos, newBlockState);
                        }
                    }
                }
                if (storedInHives != null) {
                    storedInHives.add(bee);
                }
            }
            level.a(null, pos, SoundEffects.bW, SoundCategory.e, 1.0f, 1.0f);
            level.a(GameEvent.c, pos, GameEvent.a.a(entity, level.a_(pos)));
            return true;
        }
        return false;
    }

    private boolean k() {
        return this.j != null;
    }

    private static void a(World level, BlockPosition pos, IBlockData state, List<HiveBee> data, @Nullable BlockPosition savedFlowerPos) {
        boolean flag = false;
        Iterator<HiveBee> iterator = data.iterator();
        while (iterator.hasNext()) {
            ReleaseStatus beeReleaseStatus;
            HiveBee beeData = iterator.next();
            if (!beeData.a()) continue;
            ReleaseStatus releaseStatus = beeReleaseStatus = beeData.c() ? ReleaseStatus.a : ReleaseStatus.b;
            if (TileEntityBeehive.a(level, pos, state, beeData.b(), null, beeReleaseStatus, savedFlowerPos)) {
                flag = true;
                iterator.remove();
                continue;
            }
            if (!level.paperConfig().entities.behavior.cooldownFailedBeehiveReleases) continue;
            beeData.exitTickCounter = beeData.a.f / 2;
        }
        if (flag) {
            TileEntityBeehive.a(level, pos, state);
        }
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntityBeehive beehive) {
        TileEntityBeehive.a(level, pos, state, beehive.i, beehive.j);
        if (!beehive.i.isEmpty() && level.H_().j() < 0.005) {
            double d2 = (double)pos.u() + 0.5;
            double d1 = pos.v();
            double d22 = (double)pos.w() + 0.5;
            level.a(null, d2, d1, d22, SoundEffects.bY, SoundCategory.e, 1.0f, 1.0f);
        }
        PacketDebug.a(level, pos, state, beehive);
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.i = Lists.newArrayList();
        if (tag.e(e)) {
            net.minecraft.world.level.block.entity.TileEntityBeehive$c.b.parse((DynamicOps)DynamicOpsNBT.a, (Object)tag.c(e)).resultOrPartial(string -> c.error("Failed to parse bees: '{}'", string)).ifPresent(bees -> bees.forEach(this::a));
        }
        this.j = GameProfileSerializer.a(tag, d).orElse(null);
        if (tag.e("Bukkit.MaxEntities")) {
            this.maxBees = tag.h("Bukkit.MaxEntities");
        }
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        tag.a(e, (NBTBase)net.minecraft.world.level.block.entity.TileEntityBeehive$c.b.encodeStart((DynamicOps)DynamicOpsNBT.a, this.s()).getOrThrow());
        if (this.k()) {
            tag.a(d, GameProfileSerializer.a(this.j));
        }
        tag.a("Bukkit.MaxEntities", this.maxBees);
    }

    @Override
    protected void a(TileEntity.b componentInput) {
        super.a(componentInput);
        this.i = Lists.newArrayList();
        List list = componentInput.a(DataComponents.an, List.of());
        list.forEach(this::a);
    }

    @Override
    protected void a(DataComponentMap.a components) {
        super.a(components);
        components.a(DataComponents.an, this.s());
    }

    @Override
    public void a(NBTTagCompound tag) {
        super.a(tag);
        tag.r(e);
    }

    private List<c> s() {
        return this.i.stream().map(HiveBee::b).toList();
    }

    public static final class ReleaseStatus
    extends Enum<ReleaseStatus> {
        public static final /* enum */ ReleaseStatus a = new ReleaseStatus();
        public static final /* enum */ ReleaseStatus b = new ReleaseStatus();
        public static final /* enum */ ReleaseStatus c = new ReleaseStatus();
        private static final /* synthetic */ ReleaseStatus[] d;

        public static ReleaseStatus[] values() {
            return (ReleaseStatus[])d.clone();
        }

        public static ReleaseStatus valueOf(String name) {
            return Enum.valueOf(ReleaseStatus.class, name);
        }

        private static /* synthetic */ ReleaseStatus[] a() {
            return new ReleaseStatus[]{a, b, c};
        }

        static {
            d = ReleaseStatus.a();
        }
    }

    public static final class c
    extends Record {
        private final CustomData d;
        private final int e;
        private final int f;
        public static final Codec<c> a = RecordCodecBuilder.create(instance -> instance.group((App)CustomData.b.optionalFieldOf("entity_data", (Object)CustomData.a).forGetter(c::a), (App)Codec.INT.fieldOf("ticks_in_hive").forGetter(c::b), (App)Codec.INT.fieldOf("min_ticks_in_hive").forGetter(c::c)).apply((Applicative)instance, c::new));
        public static final Codec<List<c>> b = a.listOf();
        public static final StreamCodec<ByteBuf, c> c = StreamCodec.a(CustomData.d, c::a, ByteBufCodecs.h, c::b, ByteBufCodecs.h, c::c, c::new);

        public c(CustomData entityData, int ticksInHive, int minTicksInHive) {
            this.d = entityData;
            this.e = ticksInHive;
            this.f = minTicksInHive;
        }

        public static c a(net.minecraft.world.entity.Entity entity) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            entity.e(compoundTag);
            f.forEach(compoundTag::r);
            boolean _boolean = compoundTag.q("HasNectar");
            return new c(CustomData.a(compoundTag), 0, _boolean ? 2400 : 600);
        }

        public static c a(int ticksInHive) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a("id", BuiltInRegistries.f.b(EntityTypes.l).toString());
            return new c(CustomData.a(compoundTag), ticksInHive, 600);
        }

        @Nullable
        public net.minecraft.world.entity.Entity a(World level, BlockPosition pos) {
            NBTTagCompound compoundTag = this.d.d();
            f.forEach(compoundTag::r);
            net.minecraft.world.entity.Entity entity = EntityTypes.a(compoundTag, level, EntitySpawnReason.r, entity1 -> entity1);
            if (entity != null && entity.aq().a(TagsEntity.e)) {
                entity.f(true);
                if (entity instanceof EntityBee) {
                    EntityBee bee = (EntityBee)entity;
                    bee.i(pos);
                    net.minecraft.world.level.block.entity.TileEntityBeehive$c.a(this.e, bee);
                }
                return entity;
            }
            return null;
        }

        private static void a(int ticksInHive, EntityBee bee) {
            if (!bee.ageLocked) {
                int age = bee.Y_();
                if (age < 0) {
                    bee.c_(Math.min(0, age + ticksInHive));
                } else if (age > 0) {
                    bee.c_(Math.max(0, age - ticksInHive));
                }
                bee.r(Math.max(0, bee.gA() - ticksInHive));
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "entityData;ticksInHive;minTicksInHive", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "entityData;ticksInHive;minTicksInHive", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "entityData;ticksInHive;minTicksInHive", "d", "e", "f"}, this, o2);
        }

        public CustomData a() {
            return this.d;
        }

        public int b() {
            return this.e;
        }

        public int c() {
            return this.f;
        }
    }

    static class HiveBee {
        private final c a;
        private int exitTickCounter;
        private int b;

        HiveBee(c occupant) {
            this.a = occupant;
            this.exitTickCounter = this.b = occupant.b();
        }

        public boolean a() {
            ++this.b;
            return this.exitTickCounter++ > this.a.f;
        }

        public c b() {
            return new c(this.a.d, this.b, this.a.f);
        }

        public boolean c() {
            return this.a.d.e().q("HasNectar");
        }
    }
}

