/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.event.block.BeaconEffectEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.block.BeaconActivatedEvent;
import io.papermc.paper.event.block.BeaconDeactivatedEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ARGB;
import net.minecraft.world.ChestLock;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBeaconBeam;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.potion.CraftPotionUtil;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.potion.PotionEffect;

public class TileEntityBeacon
extends TileEntity
implements ITileInventory,
INamableTileEntity {
    private static final int f = 4;
    public static final List<List<Holder<MobEffectList>>> a = List.of(List.of(MobEffects.a, MobEffects.c), List.of(MobEffects.k, MobEffects.h), List.of(MobEffects.e), List.of(MobEffects.j));
    private static final Set<Holder<MobEffectList>> g = a.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    public static final int b = 0;
    public static final int c = 1;
    public static final int d = 2;
    public static final int e = 3;
    private static final int h = 10;
    private static final IChatBaseComponent i = IChatBaseComponent.c("container.beacon");
    private static final String j = "primary_effect";
    private static final String k = "secondary_effect";
    List<BeaconColorTracker> l = Lists.newArrayList();
    private List<BeaconColorTracker> m = Lists.newArrayList();
    public int q;
    private int r;
    @Nullable
    public Holder<MobEffectList> s;
    @Nullable
    public Holder<MobEffectList> t;
    @Nullable
    public IChatBaseComponent u;
    public ChestLock v = ChestLock.a;
    private final IContainerProperties w = new IContainerProperties(){

        @Override
        public int a(int index) {
            return switch (index) {
                case 0 -> TileEntityBeacon.this.q;
                case 1 -> ContainerBeacon.a(TileEntityBeacon.this.s);
                case 2 -> ContainerBeacon.a(TileEntityBeacon.this.t);
                default -> 0;
            };
        }

        @Override
        public void a(int index, int value) {
            switch (index) {
                case 0: {
                    TileEntityBeacon.this.q = value;
                    break;
                }
                case 1: {
                    if (!TileEntityBeacon.this.n.C && !TileEntityBeacon.this.l.isEmpty()) {
                        TileEntityBeacon.a(TileEntityBeacon.this.n, TileEntityBeacon.this.o, SoundEffects.bN);
                    }
                    TileEntityBeacon.this.s = TileEntityBeacon.a(ContainerBeacon.e(value));
                    break;
                }
                case 2: {
                    TileEntityBeacon.this.t = TileEntityBeacon.a(ContainerBeacon.e(value));
                }
            }
        }

        @Override
        public int a() {
            return 3;
        }
    };
    private final String PAPER_RANGE_TAG = "Paper.Range";
    private double effectRange = -1.0;

    @Nullable
    public PotionEffect getPrimaryEffect() {
        return this.s != null ? CraftPotionUtil.toBukkit(new MobEffect(this.s, TileEntityBeacon.computeEffectDuration(this.q), TileEntityBeacon.computeEffectAmplifier(this.q, this.s, this.t), true, true)) : null;
    }

    @Nullable
    public PotionEffect getSecondaryEffect() {
        return TileEntityBeacon.hasSecondaryEffect(this.q, this.s, this.t) ? CraftPotionUtil.toBukkit(new MobEffect(this.t, TileEntityBeacon.computeEffectDuration(this.q), TileEntityBeacon.computeEffectAmplifier(this.q, this.s, this.t), true, true)) : null;
    }

    public double getEffectRange() {
        if (this.effectRange < 0.0) {
            return this.q * 10 + 10;
        }
        return this.effectRange;
    }

    public void setEffectRange(double range) {
        this.effectRange = range;
    }

    public void resetEffectRange() {
        this.effectRange = -1.0;
    }

    @Nullable
    static Holder<MobEffectList> a(@Nullable Holder<MobEffectList> effect) {
        return g.contains(effect) ? effect : null;
    }

    public TileEntityBeacon(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.p, pos, blockState);
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntityBeacon blockEntity) {
        int i2;
        BlockPosition blockPos;
        int x2 = pos.u();
        int y2 = pos.v();
        int z2 = pos.w();
        if (blockEntity.r < y2) {
            blockPos = pos;
            blockEntity.m = Lists.newArrayList();
            blockEntity.r = pos.v() - 1;
        } else {
            blockPos = new BlockPosition(x2, blockEntity.r + 1, z2);
        }
        BeaconColorTracker beaconBeamSection = blockEntity.m.isEmpty() ? null : blockEntity.m.get(blockEntity.m.size() - 1);
        int height = level.a(HeightMap.Type.b, x2, z2);
        for (i2 = 0; i2 < 10 && blockPos.v() <= height; ++i2) {
            IBlockData blockState = level.a_(blockPos);
            Block block = blockState.b();
            if (block instanceof IBeaconBeam) {
                IBeaconBeam beaconBeamBlock = (IBeaconBeam)((Object)block);
                int textureDiffuseColor = beaconBeamBlock.b().d();
                if (blockEntity.m.size() <= 1) {
                    beaconBeamSection = new BeaconColorTracker(textureDiffuseColor);
                    blockEntity.m.add(beaconBeamSection);
                } else if (beaconBeamSection != null) {
                    if (textureDiffuseColor == beaconBeamSection.a) {
                        beaconBeamSection.a();
                    } else {
                        beaconBeamSection = new BeaconColorTracker(ARGB.d(beaconBeamSection.a, textureDiffuseColor));
                        blockEntity.m.add(beaconBeamSection);
                    }
                }
            } else {
                if (beaconBeamSection == null || blockState.g() >= 15 && !blockState.a(Blocks.I)) {
                    blockEntity.m.clear();
                    blockEntity.r = height;
                    break;
                }
                beaconBeamSection.a();
            }
            blockPos = blockPos.d();
            ++blockEntity.r;
        }
        int originalLevels = i2 = blockEntity.q;
        if (level.ad() % 80L == 0L) {
            if (!blockEntity.l.isEmpty()) {
                blockEntity.q = TileEntityBeacon.a(level, x2, y2, z2);
            }
            if (blockEntity.q > 0 && !blockEntity.l.isEmpty()) {
                TileEntityBeacon.applyEffects(level, pos, blockEntity.q, blockEntity.s, blockEntity.t, blockEntity);
                TileEntityBeacon.a(level, pos, SoundEffects.bL);
            }
        }
        if (originalLevels <= 0 && blockEntity.q > 0) {
            block = CraftBlock.at(level, pos);
            new BeaconActivatedEvent((org.bukkit.block.Block)block).callEvent();
        } else if (originalLevels > 0 && blockEntity.q <= 0) {
            block = CraftBlock.at(level, pos);
            new BeaconDeactivatedEvent((org.bukkit.block.Block)block).callEvent();
        }
        if (blockEntity.r >= height) {
            blockEntity.r = level.L_() - 1;
            boolean flag = i2 > 0;
            blockEntity.l = blockEntity.m;
            if (!level.C) {
                boolean flag1;
                boolean bl = flag1 = blockEntity.q > 0;
                if (!flag && flag1) {
                    TileEntityBeacon.a(level, pos, SoundEffects.bK);
                    for (EntityPlayer serverPlayer : level.a(EntityPlayer.class, new AxisAlignedBB(x2, y2, z2, x2, y2 - 4, z2).c(10.0, 5.0, 10.0))) {
                        CriterionTriggers.m.a(serverPlayer, blockEntity.q);
                    }
                } else if (flag && !flag1) {
                    TileEntityBeacon.a(level, pos, SoundEffects.bM);
                }
            }
        }
    }

    private static int a(World level, int x2, int y2, int z2) {
        int i2;
        int i3 = 0;
        int i1 = 1;
        while (i1 <= 4 && (i2 = y2 - i1) >= level.L_()) {
            boolean flag = true;
            block1: for (int i32 = x2 - i1; i32 <= x2 + i1 && flag; ++i32) {
                for (int i4 = z2 - i1; i4 <= z2 + i1; ++i4) {
                    if (level.a_(new BlockPosition(i32, i2, i4)).a(TagsBlock.aP)) continue;
                    flag = false;
                    continue block1;
                }
            }
            if (!flag) break;
            i3 = i1++;
        }
        return i3;
    }

    @Override
    public void av_() {
        CraftBlock block = CraftBlock.at(this.n, this.o);
        new BeaconDeactivatedEvent((org.bukkit.block.Block)block).callEvent();
        if (this.q > 0 && !this.l.isEmpty()) {
            TileEntityBeacon.a(this.n, this.o, SoundEffects.bM);
        }
        super.av_();
    }

    @DoNotUse
    private static void a(World level, BlockPosition pos, int beaconLevel, @Nullable Holder<MobEffectList> primaryEffect, @Nullable Holder<MobEffectList> secondaryEffect) {
        TileEntityBeacon.applyEffects(level, pos, beaconLevel, primaryEffect, secondaryEffect, null);
    }

    private static void applyEffects(World level, BlockPosition pos, int beaconLevel, @Nullable Holder<MobEffectList> primaryEffect, @Nullable Holder<MobEffectList> secondaryEffect, @Nullable TileEntityBeacon blockEntity) {
        if (!level.C && primaryEffect != null) {
            double d2 = TileEntityBeacon.computeBeaconRange(beaconLevel);
            int i2 = TileEntityBeacon.computeEffectAmplifier(beaconLevel, primaryEffect, secondaryEffect);
            int i1 = TileEntityBeacon.computeEffectDuration(beaconLevel);
            List<EntityHuman> entitiesOfClass = TileEntityBeacon.getHumansInRange(level, pos, beaconLevel, blockEntity);
            TileEntityBeacon.applyEffectsAndCallEvent(level, pos, entitiesOfClass, new MobEffect(primaryEffect, i1, i2, true, true), true);
            if (TileEntityBeacon.hasSecondaryEffect(beaconLevel, primaryEffect, secondaryEffect)) {
                TileEntityBeacon.applyEffectsAndCallEvent(level, pos, entitiesOfClass, new MobEffect(secondaryEffect, i1, 0, true, true), false);
            }
        }
    }

    private static int computeEffectDuration(int beaconLevel) {
        return (9 + beaconLevel * 2) * 20;
    }

    private static int computeEffectAmplifier(int beaconLevel, @Nullable Holder<MobEffectList> primaryEffect, @Nullable Holder<MobEffectList> secondaryEffect) {
        int i2 = 0;
        if (beaconLevel >= 4 && Objects.equals(primaryEffect, secondaryEffect)) {
            i2 = 1;
        }
        return i2;
    }

    private static double computeBeaconRange(int beaconLevel) {
        return beaconLevel * 10 + 10;
    }

    public static List<EntityHuman> getHumansInRange(World level, BlockPosition pos, int beaconLevel, @Nullable TileEntityBeacon blockEntity) {
        ArrayList<EntityHuman> list;
        double d2 = blockEntity != null ? blockEntity.getEffectRange() : TileEntityBeacon.computeBeaconRange(beaconLevel);
        AxisAlignedBB aabb = new AxisAlignedBB(pos).g(d2).b(0.0, level.M_(), 0.0);
        if (d2 <= 128.0) {
            list = level.a(EntityHuman.class, aabb);
        } else {
            list = new ArrayList();
            for (EntityHuman entityHuman : level.z()) {
                if (!IEntitySelector.f.test(entityHuman) || !entityHuman.cR().c(aabb)) continue;
                list.add(entityHuman);
            }
        }
        return list;
    }

    private static boolean hasSecondaryEffect(int beaconLevel, Holder<MobEffectList> primaryEffect, @Nullable Holder<MobEffectList> secondaryEffect) {
        return beaconLevel >= 4 && !Objects.equals(primaryEffect, secondaryEffect) && secondaryEffect != null;
    }

    private static void applyEffectsAndCallEvent(World level, BlockPosition position, List<EntityHuman> players, MobEffect mobEffectInstance, boolean isPrimary) {
        PotionEffect apiEffect = CraftPotionUtil.toBukkit(mobEffectInstance);
        CraftBlock apiBlock = CraftBlock.at(level, position);
        for (EntityHuman player : players) {
            BeaconEffectEvent event = new BeaconEffectEvent((org.bukkit.block.Block)apiBlock, apiEffect, (Player)player.getBukkitEntity(), isPrimary);
            if (!event.callEvent()) continue;
            player.addEffect(CraftPotionUtil.fromBukkit(event.getEffect()), EntityPotionEffectEvent.Cause.BEACON);
        }
    }

    public static void a(World level, BlockPosition pos, SoundEffect sound) {
        level.a(null, pos, sound, SoundCategory.e, 1.0f, 1.0f);
    }

    public List<BeaconColorTracker> b() {
        return this.q == 0 ? ImmutableList.of() : this.l;
    }

    public PacketPlayOutTileEntityData c() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.e(registries);
    }

    private static void a(NBTTagCompound tag, String key, @Nullable Holder<MobEffectList> effect) {
        if (effect != null) {
            effect.e().ifPresent(resourceKey -> tag.a(key, resourceKey.a().toString()));
        }
    }

    @Nullable
    private static Holder<MobEffectList> a(NBTTagCompound tag, String key) {
        if (tag.b(key, 8)) {
            MinecraftKey resourceLocation = MinecraftKey.c(tag.l(key));
            return resourceLocation == null ? null : (Holder)BuiltInRegistries.d.c(resourceLocation).orElse(null);
        }
        return null;
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.s = TileEntityBeacon.a(tag, j);
        this.t = TileEntityBeacon.a(tag, k);
        this.q = tag.h("Levels");
        if (tag.b("CustomName", 8)) {
            this.u = TileEntityBeacon.a(tag.l("CustomName"), registries);
        }
        this.v = ChestLock.b(tag, registries);
        this.effectRange = tag.b("Paper.Range", 6) ? tag.k("Paper.Range") : -1.0;
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        TileEntityBeacon.a(tag, j, this.s);
        TileEntityBeacon.a(tag, k, this.t);
        tag.a("Levels", this.q);
        if (this.u != null) {
            tag.a("CustomName", IChatBaseComponent.ChatSerializer.a(this.u, registries));
        }
        this.v.a(tag, registries);
        tag.a("Paper.Range", this.effectRange);
    }

    public void a(@Nullable IChatBaseComponent name) {
        this.u = name;
    }

    @Override
    @Nullable
    public IChatBaseComponent an() {
        return this.u;
    }

    @Override
    @Nullable
    public Container createMenu(int containerId, PlayerInventory playerInventory, EntityHuman player) {
        return TileEntityContainer.canUnlock(player, this.v, this.p_(), this) ? new ContainerBeacon(containerId, playerInventory, this.w, ContainerAccess.a(this.n, this.aA_())) : null;
    }

    @Override
    public IChatBaseComponent p_() {
        return this.al();
    }

    @Override
    public IChatBaseComponent al() {
        return this.u != null ? this.u : i;
    }

    @Override
    protected void a(TileEntity.b componentInput) {
        super.a(componentInput);
        this.u = componentInput.a(DataComponents.g);
        this.v = componentInput.a(DataComponents.ao, ChestLock.a);
    }

    @Override
    protected void a(DataComponentMap.a components) {
        super.a(components);
        components.a(DataComponents.g, this.u);
        if (!this.v.equals(ChestLock.a)) {
            components.a(DataComponents.ao, this.v);
        }
    }

    @Override
    public void a(NBTTagCompound tag) {
        tag.r("CustomName");
        tag.r("lock");
    }

    @Override
    public void a(World level) {
        super.a(level);
        this.r = level.L_() - 1;
    }

    public static class BeaconColorTracker {
        final int a;
        private int b;

        public BeaconColorTracker(int color) {
            this.a = color;
            this.b = 1;
        }

        protected void a() {
            ++this.b;
        }

        public int b() {
            return this.a;
        }

        public int c() {
            return this.b;
        }
    }
}

