/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockBanner;
import net.minecraft.world.level.block.BlockBannerAbstract;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.slf4j.Logger;

public class TileEntityBanner
extends TileEntity
implements INamableTileEntity {
    private static final Logger b = LogUtils.getLogger();
    public static final int a = 6;
    private static final String c = "patterns";
    @Nullable
    public IChatBaseComponent d;
    public EnumColor e;
    private BannerPatternLayers f = BannerPatternLayers.a;
    ThreadLocal<Boolean> serialisingForNetwork = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public TileEntityBanner(BlockPosition pos, IBlockData blockState) {
        this(pos, blockState, ((BlockBannerAbstract)blockState.b()).b());
    }

    public TileEntityBanner(BlockPosition pos, IBlockData blockState, EnumColor baseColor) {
        super(TileEntityTypes.u, pos, blockState);
        this.e = baseColor;
    }

    @Override
    public IChatBaseComponent al() {
        return this.d != null ? this.d : IChatBaseComponent.c("block.minecraft.banner");
    }

    @Override
    @Nullable
    public IChatBaseComponent an() {
        return this.d;
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        if (!this.f.equals(BannerPatternLayers.a) || this.serialisingForNetwork.get().booleanValue()) {
            tag.a(c, (NBTBase)BannerPatternLayers.b.encodeStart(registries.a(DynamicOpsNBT.a), (Object)this.f).getOrThrow());
        }
        if (this.d != null) {
            tag.a("CustomName", IChatBaseComponent.ChatSerializer.a(this.d, registries));
        }
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        if (tag.b("CustomName", 8)) {
            this.d = TileEntityBanner.a(tag.l("CustomName"), registries);
        }
        if (tag.e(c)) {
            BannerPatternLayers.b.parse(registries.a(DynamicOpsNBT.a), (Object)tag.c(c)).resultOrPartial(string -> b.error("Failed to parse banner patterns: '{}'", string)).ifPresent(bannerPatternLayers -> this.setPatterns((BannerPatternLayers)bannerPatternLayers));
        }
    }

    public PacketPlayOutTileEntityData a() {
        return PacketPlayOutTileEntityData.a(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        Boolean wasSerialisingForNetwork = this.serialisingForNetwork.get();
        try {
            this.serialisingForNetwork.set(Boolean.TRUE);
            NBTTagCompound nBTTagCompound = this.d(registries);
            return nBTTagCompound;
        }
        finally {
            this.serialisingForNetwork.set(wasSerialisingForNetwork);
        }
    }

    public BannerPatternLayers b() {
        return this.f;
    }

    public ItemStack c() {
        ItemStack itemStack = new ItemStack(BlockBanner.a(this.e));
        itemStack.b(this.q());
        return itemStack;
    }

    public EnumColor f() {
        return this.e;
    }

    @Override
    protected void a(TileEntity.b componentInput) {
        super.a(componentInput);
        this.setPatterns(componentInput.a(DataComponents.ai, BannerPatternLayers.a));
        this.d = componentInput.a(DataComponents.g);
    }

    @Override
    protected void a(DataComponentMap.a components) {
        super.a(components);
        components.a(DataComponents.ai, this.f);
        components.a(DataComponents.g, this.d);
    }

    @Override
    public void a(NBTTagCompound tag) {
        tag.r(c);
        tag.r("CustomName");
    }

    public void setPatterns(BannerPatternLayers bannerPatternLayers) {
        if (bannerPatternLayers.b().size() > 20) {
            bannerPatternLayers = new BannerPatternLayers(List.copyOf(bannerPatternLayers.b().subList(0, 20)));
        }
        this.f = bannerPatternLayers;
    }
}

