/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R3.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;

public abstract class TileEntity {
    static boolean ignoreBlockEntityUpdates;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Logger d;
    private final TileEntityTypes<?> e;
    @Nullable
    protected World n;
    protected final BlockPosition o;
    protected boolean p;
    private IBlockData f;
    private DataComponentMap g = DataComponentMap.a;

    public TileEntity(TileEntityTypes<?> type, BlockPosition pos, IBlockData blockState) {
        this.e = type;
        this.o = pos.j();
        this.a(blockState);
        this.f = blockState;
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    }

    private void a(IBlockData state) {
        if (!this.b(state)) {
            throw new IllegalStateException("Invalid block entity " + this.k() + " state at " + String.valueOf(this.o) + ", got " + String.valueOf(state));
        }
    }

    public boolean b(IBlockData state) {
        return this.e.a(state);
    }

    public static BlockPosition b(NBTTagCompound tag) {
        return new BlockPosition(tag.h("x"), tag.h("y"), tag.h("z"));
    }

    @Nullable
    public World i() {
        return this.n;
    }

    public void a(World level) {
        this.n = level;
    }

    public boolean l() {
        return this.n != null;
    }

    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        this.persistentDataContainer.clear();
        NBTBase persistentDataTag = tag.c("PublicBukkitValues");
        if (persistentDataTag instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)persistentDataTag);
        }
    }

    public final void c(NBTTagCompound tag, HolderLookup.a registries) {
        this.a(tag, registries);
        a.a.parse(registries.a(DynamicOpsNBT.a), (Object)tag).resultOrPartial(string -> d.warn("Failed to load components: {}", string)).ifPresent(components -> {
            this.g = components;
        });
    }

    public final void d(NBTTagCompound tag, HolderLookup.a registries) {
        this.a(tag, registries);
    }

    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
    }

    public final NBTTagCompound b(HolderLookup.a registries) {
        NBTTagCompound compoundTag = this.d(registries);
        this.d(compoundTag);
        return compoundTag;
    }

    public final NBTTagCompound c(HolderLookup.a registries) {
        NBTTagCompound compoundTag = this.d(registries);
        this.c(compoundTag);
        return compoundTag;
    }

    public final NBTTagCompound d(HolderLookup.a registries) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.b(compoundTag, registries);
        a.a.encodeStart(registries.a(DynamicOpsNBT.a), (Object)this.g).resultOrPartial(string -> d.warn("Failed to save components: {}", string)).ifPresent(tag -> compoundTag.a((NBTTagCompound)tag));
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            compoundTag.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return compoundTag;
    }

    public final NBTTagCompound e(HolderLookup.a registries) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.b(compoundTag, registries);
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            compoundTag.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return compoundTag;
    }

    public final NBTTagCompound f(HolderLookup.a registries) {
        NBTTagCompound compoundTag = this.e(registries);
        this.d(compoundTag);
        return compoundTag;
    }

    public void c(NBTTagCompound tag) {
        MinecraftKey key = TileEntityTypes.a(this.p());
        if (key == null) {
            throw new RuntimeException(String.valueOf(this.getClass()) + " is missing a mapping! This is a bug!");
        }
        tag.a("id", key.toString());
    }

    public static void a(NBTTagCompound tag, TileEntityTypes<?> entityType) {
        tag.a("id", TileEntityTypes.a(entityType).toString());
    }

    private void d(NBTTagCompound tag) {
        this.c(tag);
        tag.a("x", this.o.u());
        tag.a("y", this.o.v());
        tag.a("z", this.o.w());
    }

    @Nullable
    public static TileEntity a(BlockPosition pos, IBlockData state, NBTTagCompound tag, HolderLookup.a registries) {
        String string = tag.l("id");
        MinecraftKey resourceLocation = MinecraftKey.c(string);
        if (resourceLocation == null) {
            d.error("Block entity has invalid type: {}", (Object)string);
            return null;
        }
        return BuiltInRegistries.j.b(resourceLocation).map(blockEntityType -> {
            try {
                return blockEntityType.a(pos, state);
            }
            catch (Throwable var5x) {
                d.error("Failed to create block entity {}", (Object)string, (Object)var5x);
                return null;
            }
        }).map(blockEntity -> {
            try {
                blockEntity.c(tag, registries);
                return blockEntity;
            }
            catch (Throwable var5x) {
                d.error("Failed to load data for block entity {}", (Object)string, (Object)var5x);
                return null;
            }
        }).orElseGet(() -> {
            d.warn("Skipping BlockEntity with id {}", (Object)string);
            return null;
        });
    }

    public void e() {
        if (this.n != null) {
            if (ignoreBlockEntityUpdates) {
                return;
            }
            TileEntity.a(this.n, this.o, this.f);
        }
    }

    protected static void a(World level, BlockPosition pos, IBlockData state) {
        level.q(pos);
        if (!state.l()) {
            level.c(pos, state.b());
        }
    }

    public BlockPosition aA_() {
        return this.o;
    }

    public IBlockData m() {
        return this.f;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> ax_() {
        return null;
    }

    public NBTTagCompound a(HolderLookup.a registries) {
        return new NBTTagCompound();
    }

    public boolean n() {
        return this.p;
    }

    public void av_() {
        this.p = true;
    }

    public void o() {
        this.p = false;
    }

    public boolean a_(int id, int type) {
        return false;
    }

    public void a(CrashReportSystemDetails reportCategory) {
        reportCategory.a("Name", this::k);
        if (this.n != null) {
            IBlockData block = this.m();
            if (block != null) {
                CrashReportSystemDetails.a(reportCategory, this.n, this.o, block);
            }
            CrashReportSystemDetails.a(reportCategory, this.n, this.o, this.n.a_(this.o));
        }
    }

    private String k() {
        return String.valueOf(BuiltInRegistries.j.b(this.p())) + " // " + this.getClass().getCanonicalName();
    }

    public TileEntityTypes<?> p() {
        return this.e;
    }

    @Deprecated
    public void c(IBlockData blockState) {
        this.a(blockState);
        this.f = blockState;
    }

    protected void a(b componentInput) {
    }

    public final void a(ItemStack stack) {
        this.a(stack.c(), stack.d());
    }

    public final void a(DataComponentMap components, DataComponentPatch patch) {
        this.applyComponentsSet(components, patch);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap components, DataComponentPatch patch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.Y);
        set.add(DataComponents.am);
        final PatchedDataComponentMap dataComponentMap = PatchedDataComponentMap.a(components, patch);
        this.a(new b(){

            @Override
            @Nullable
            public <T> T a(DataComponentType<T> component) {
                set.add(component);
                return dataComponentMap.a(component);
            }

            @Override
            public <T> T a(DataComponentType<? extends T> component, T defaultValue) {
                set.add(component);
                return dataComponentMap.a(component, defaultValue);
            }
        });
        DataComponentPatch dataComponentPatch = patch.a(set::contains);
        this.g = dataComponentPatch.e().a();
        set.remove(DataComponents.Y);
        return set;
    }

    protected void a(DataComponentMap.a components) {
    }

    @Deprecated
    public void a(NBTTagCompound tag) {
    }

    public final DataComponentMap q() {
        DataComponentMap.a builder = DataComponentMap.a();
        builder.a(this.g);
        this.a(builder);
        return builder.a();
    }

    public DataComponentMap r() {
        return this.g;
    }

    public void a(DataComponentMap components) {
        this.g = components;
    }

    @Nullable
    public static IChatBaseComponent a(String customName, HolderLookup.a registries) {
        try {
            return IChatBaseComponent.ChatSerializer.a(customName, registries);
        }
        catch (Exception var3) {
            d.warn("Failed to parse custom name from string '{}', discarding", (Object)customName, (Object)var3);
            return null;
        }
    }

    public InventoryHolder getOwner() {
        return this.getOwner(true);
    }

    public InventoryHolder getOwner(boolean useSnapshot) {
        InventoryHolder inventoryHolder;
        if (this.n == null) {
            return null;
        }
        Block block = this.n.getWorld().getBlockAt(this.o.u(), this.o.v(), this.o.w());
        BlockState state = block.getState(useSnapshot);
        return state instanceof InventoryHolder ? (inventoryHolder = (InventoryHolder)state) : null;
    }

    public NBTTagCompound sanitizeSentNbt(NBTTagCompound tag) {
        tag.r("PublicBukkitValues");
        return tag;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
        d = LogUtils.getLogger();
    }

    static class a {
        public static final Codec<DataComponentMap> a = DataComponentMap.b.optionalFieldOf("components", (Object)DataComponentMap.a).codec();

        private a() {
        }
    }

    protected static interface b {
        @Nullable
        public <T> T a(DataComponentType<T> var1);

        public <T> T a(DataComponentType<? extends T> var1, T var2);
    }
}

