/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.slf4j.Logger;

public class SculkShriekerBlockEntity
extends TileEntity
implements GameEventListener.b<VibrationSystem.b>,
VibrationSystem {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 10;
    private static final int c = 20;
    private static final int d = 5;
    private static final int h = 6;
    private static final int i = 40;
    private static final int j = 90;
    private static final Int2ObjectMap<SoundEffect> k = (Int2ObjectMap)SystemUtils.a(new Int2ObjectOpenHashMap(), (? super T map) -> {
        map.put(1, (Object)SoundEffects.CF);
        map.put(2, (Object)SoundEffects.CG);
        map.put(3, (Object)SoundEffects.CH);
        map.put(4, (Object)SoundEffects.CE);
    });
    public int l;
    private final VibrationSystem.d m = new a();
    private VibrationSystem.a q = new VibrationSystem.a();
    private final VibrationSystem.b r = new VibrationSystem.b(this);

    public SculkShriekerBlockEntity(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.M, pos, blockState);
    }

    @Override
    public VibrationSystem.a gt() {
        return this.q;
    }

    @Override
    public VibrationSystem.d gu() {
        return this.m;
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        if (tag.b("warning_level", 99)) {
            this.l = tag.h("warning_level");
        }
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        if (tag.b("listener", 10)) {
            VibrationSystem.a.a.parse(registryOps, (Object)tag.p("listener")).resultOrPartial(string -> a.error("Failed to parse vibration listener for Sculk Shrieker: '{}'", string)).ifPresent(data -> {
                this.q = data;
            });
        }
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        tag.a("warning_level", this.l);
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        VibrationSystem.a.a.encodeStart(registryOps, (Object)this.q).resultOrPartial(string -> a.error("Failed to encode vibration listener for Sculk Shrieker: '{}'", string)).ifPresent(tag1 -> tag.a("listener", (NBTBase)tag1));
    }

    @Nullable
    public static EntityPlayer a(@Nullable Entity entity) {
        EntityPlayer player = SculkShriekerBlockEntity.tryGetPlayer0(entity);
        return player != null && player.dV() == entity.dV() ? player : null;
    }

    @Nullable
    private static EntityPlayer tryGetPlayer0(@Nullable Entity entity) {
        EntityItem itemEntity;
        Entity var9;
        IProjectile projectile;
        Entity var3;
        EntityLiving serverPlayer1;
        if (entity instanceof EntityPlayer) {
            return (EntityPlayer)entity;
        }
        if (entity != null && (serverPlayer1 = entity.cW()) instanceof EntityPlayer) {
            return (EntityPlayer)serverPlayer1;
        }
        if (entity instanceof IProjectile && (var3 = (projectile = (IProjectile)entity).p()) instanceof EntityPlayer) {
            return (EntityPlayer)var3;
        }
        if (entity instanceof EntityItem && (var9 = (itemEntity = (EntityItem)entity).p()) instanceof EntityPlayer) {
            return (EntityPlayer)var9;
        }
        return null;
    }

    public void a(WorldServer level, @Nullable EntityPlayer player) {
        IBlockData blockState;
        if (player != null && !(blockState = this.m()).c(SculkShriekerBlock.b).booleanValue()) {
            this.l = 0;
            if (!this.b(level) || this.b(level, player)) {
                this.a(level, (Entity)player);
            }
        }
    }

    private boolean b(WorldServer level, EntityPlayer player) {
        OptionalInt optionalInt = WardenSpawnTracker.a(level, this.aA_(), player);
        optionalInt.ifPresent(i2 -> {
            this.l = i2;
        });
        return optionalInt.isPresent();
    }

    private void a(WorldServer level, @Nullable Entity sourceEntity) {
        BlockPosition blockPos = this.aA_();
        IBlockData blockState = this.m();
        level.a(blockPos, (IBlockData)blockState.b(SculkShriekerBlock.b, true), 2);
        level.a(blockPos, blockState.b(), 90);
        level.c(3007, blockPos, 0);
        level.a(GameEvent.N, blockPos, GameEvent.a.a(sourceEntity));
    }

    private boolean b(WorldServer level) {
        return this.m().c(SculkShriekerBlock.d) != false && level.am() != EnumDifficulty.a && level.O().b(GameRules.N);
    }

    public void a(WorldServer level) {
        if (this.b(level) && this.l > 0) {
            if (!this.c(level)) {
                this.b((World)level);
            }
            Warden.a(level, Vec3D.b(this.aA_()), null, 40);
        }
    }

    private void b(World level) {
        SoundEffect soundEvent = (SoundEffect)k.get(this.l);
        if (soundEvent != null) {
            BlockPosition blockPos = this.aA_();
            int i2 = blockPos.u() + MathHelper.b(level.A, -10, 10);
            int i1 = blockPos.v() + MathHelper.b(level.A, -10, 10);
            int i22 = blockPos.w() + MathHelper.b(level.A, -10, 10);
            level.a(null, (double)i2, (double)i1, (double)i22, soundEvent, SoundCategory.f, 5.0f, 1.0f);
        }
    }

    private boolean c(WorldServer level) {
        return this.l >= 4 && SpawnUtil.trySpawnMob(EntityTypes.bF, EntitySpawnReason.k, level, this.aA_(), 20, 5, 6, SpawnUtil.a.b, false, CreatureSpawnEvent.SpawnReason.NATURAL, null).isPresent();
    }

    public VibrationSystem.b b() {
        return this.r;
    }

    class a
    implements VibrationSystem.d {
        private static final int b = 8;
        private final PositionSource c;

        public a() {
            this.c = new BlockPositionSource(SculkShriekerBlockEntity.this.o);
        }

        @Override
        public int a() {
            return 8;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.c;
        }

        @Override
        public boolean a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, GameEvent.a context) {
            return SculkShriekerBlockEntity.this.m().c(SculkShriekerBlock.b) == false && SculkShriekerBlockEntity.a(context.a()) != null;
        }

        @Override
        public void a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            SculkShriekerBlockEntity.this.a(level, SculkShriekerBlockEntity.a(playerEntity != null ? playerEntity : entity));
        }

        @Override
        public void e() {
            SculkShriekerBlockEntity.this.e();
        }

        @Override
        public boolean f() {
            return true;
        }
    }
}

