/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.slf4j.Logger;

public class SculkSensorBlockEntity
extends TileEntity
implements GameEventListener.b<VibrationSystem.b>,
VibrationSystem {
    private static final Logger a = LogUtils.getLogger();
    private VibrationSystem.a b;
    private final VibrationSystem.b c;
    private final VibrationSystem.d d = this.b();
    public int h;
    @Nullable
    public Integer rangeOverride = null;
    protected static final String PAPER_LISTENER_RANGE_NBT_KEY = "Paper.ListenerRange";

    protected SculkSensorBlockEntity(TileEntityTypes<?> type, BlockPosition pos, IBlockData blockState) {
        super(type, pos, blockState);
        this.b = new VibrationSystem.a();
        this.c = new VibrationSystem.b(this);
    }

    public SculkSensorBlockEntity(BlockPosition pos, IBlockData blockState) {
        this(TileEntityTypes.J, pos, blockState);
    }

    public VibrationSystem.d b() {
        return new a(this.aA_());
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.h = tag.h("last_vibration_frequency");
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        if (tag.b("listener", 10)) {
            VibrationSystem.a.a.parse(registryOps, (Object)tag.p("listener")).resultOrPartial(string -> a.error("Failed to parse vibration listener for Sculk Sensor: '{}'", string)).ifPresent(data -> {
                this.b = data;
            });
        }
        this.rangeOverride = tag.e(PAPER_LISTENER_RANGE_NBT_KEY) ? Integer.valueOf(tag.h(PAPER_LISTENER_RANGE_NBT_KEY)) : null;
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        tag.a("last_vibration_frequency", this.h);
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        VibrationSystem.a.a.encodeStart(registryOps, (Object)this.b).resultOrPartial(string -> a.error("Failed to encode vibration listener for Sculk Sensor: '{}'", string)).ifPresent(tag1 -> tag.a("listener", (NBTBase)tag1));
        this.saveRangeOverride(tag);
    }

    protected void saveRangeOverride(NBTTagCompound tag) {
        if (this.rangeOverride != null && this.rangeOverride != 8) {
            tag.a(PAPER_LISTENER_RANGE_NBT_KEY, this.rangeOverride);
        }
    }

    @Override
    public VibrationSystem.a gt() {
        return this.b;
    }

    @Override
    public VibrationSystem.d gu() {
        return this.d;
    }

    public int d() {
        return this.h;
    }

    public void a(int lastVibrationFrequency) {
        this.h = lastVibrationFrequency;
    }

    public VibrationSystem.b f() {
        return this.c;
    }

    protected class a
    implements VibrationSystem.d {
        public static final int b = 8;
        protected final BlockPosition c;
        private final PositionSource a;

        public a(BlockPosition pos) {
            this.c = pos;
            this.a = new BlockPositionSource(pos);
        }

        @Override
        public int a() {
            if (SculkSensorBlockEntity.this.rangeOverride != null) {
                return SculkSensorBlockEntity.this.rangeOverride;
            }
            return 8;
        }

        @Override
        public PositionSource b() {
            return this.a;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable GameEvent.a context) {
            return (!pos.equals(this.c) || !gameEvent.a(GameEvent.f) && !gameEvent.a(GameEvent.i)) && SculkSensorBlock.q(SculkSensorBlockEntity.this.m());
        }

        @Override
        public void a(WorldServer level, BlockPosition pos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            IBlockData blockState = SculkSensorBlockEntity.this.m();
            if (SculkSensorBlock.q(blockState)) {
                SculkSensorBlockEntity.this.a(VibrationSystem.a_(gameEvent));
                int redstoneStrengthForDistance = VibrationSystem.a_(distance, this.a());
                Block block = blockState.b();
                if (block instanceof SculkSensorBlock) {
                    SculkSensorBlock sculkSensorBlock = (SculkSensorBlock)block;
                    sculkSensorBlock.a(entity, (World)level, this.c, blockState, redstoneStrengthForDistance, SculkSensorBlockEntity.this.d());
                }
            }
        }

        @Override
        public void e() {
            SculkSensorBlockEntity.this.e();
        }

        @Override
        public boolean f() {
            return true;
        }
    }
}

