/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.slf4j.Logger;

public class BrushableBlockEntity
extends TileEntity {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "LootTable";
    private static final String c = "LootTableSeed";
    private static final String d = "hit_direction";
    private static final String e = "item";
    private static final int f = 10;
    private static final int g = 40;
    private static final int h = 10;
    private int i;
    private long j;
    private long k;
    public ItemStack l = ItemStack.j;
    @Nullable
    private EnumDirection m;
    @Nullable
    public ResourceKey<LootTable> q;
    public long r;

    public BrushableBlockEntity(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.O, pos, blockState);
    }

    public boolean a(long startTick, WorldServer level, EntityHuman player, EnumDirection hitDirection, ItemStack stack) {
        if (this.m == null) {
            this.m = hitDirection;
        }
        this.j = startTick + 40L;
        if (startTick < this.k) {
            return false;
        }
        this.k = startTick + 10L;
        this.a(level, player, stack);
        int completionState = this.f();
        if (++this.i >= 10) {
            this.b(level, player, stack);
            return true;
        }
        level.a(this.aA_(), this.m().b(), 2);
        int completionState1 = this.f();
        if (completionState != completionState1) {
            IBlockData blockState = this.m();
            IBlockData blockState1 = (IBlockData)blockState.b(BlockProperties.by, completionState1);
            level.a(this.aA_(), blockState1, 3);
        }
        return false;
    }

    private void a(WorldServer level, EntityHuman player, ItemStack stack) {
        if (this.q != null) {
            LootTable lootTable = level.p().bc().b(this.q);
            if (player instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)player;
                CriterionTriggers.Q.a(serverPlayer, this.q);
            }
            LootParams lootParams = new LootParams.a(level).a(LootContextParameters.f, Vec3D.b(this.o)).a(player.gF()).a(LootContextParameters.a, player).a(LootContextParameters.i, stack).a(LootContextParameterSets.i);
            ObjectArrayList<ItemStack> randomItems = lootTable.a(lootParams, this.r);
            this.l = switch (randomItems.size()) {
                case 0 -> ItemStack.j;
                case 1 -> (ItemStack)randomItems.getFirst();
                default -> {
                    a.warn("Expected max 1 loot from loot table {}, but got {}", (Object)this.q.a(), (Object)randomItems.size());
                    yield (ItemStack)randomItems.getFirst();
                }
            };
            this.q = null;
            this.e();
        }
    }

    private void b(WorldServer level, EntityHuman player, ItemStack stack) {
        Block turnsInto;
        this.c(level, player, stack);
        IBlockData blockState = this.m();
        level.c(3008, this.aA_(), Block.j(blockState));
        Block block = this.m().b();
        if (block instanceof BrushableBlock) {
            BrushableBlock brushableBlock = (BrushableBlock)block;
            turnsInto = brushableBlock.b();
        } else {
            turnsInto = Blocks.a;
        }
        level.a(this.o, turnsInto.m(), 3);
    }

    private void c(WorldServer level, EntityHuman player, ItemStack stack) {
        this.a(level, player, stack);
        if (!this.l.f()) {
            double d2 = EntityTypes.aq.l();
            double d1 = 1.0 - d2;
            double d22 = d2 / 2.0;
            EnumDirection direction = Objects.requireNonNullElse(this.m, EnumDirection.b);
            BlockPosition blockPos = this.o.a(direction, 1);
            double d3 = (double)blockPos.u() + 0.5 * d1 + d22;
            double d4 = (double)blockPos.v() + 0.5 + (double)(EntityTypes.aq.m() / 2.0f);
            double d5 = (double)blockPos.w() + 0.5 * d1 + d22;
            EntityItem itemEntity = new EntityItem(level, d3, d4, d5, this.l.a(level.A.a(21) + 10));
            itemEntity.i(Vec3D.c);
            CraftBlock bblock = CraftBlock.at(this.n, this.o);
            CraftEventFactory.handleBlockDropItemEvent(bblock, bblock.getState(), (EntityPlayer)player, List.of(itemEntity));
            this.l = ItemStack.j;
        }
    }

    public void a(WorldServer level) {
        if (this.i != 0 && level.ad() >= this.j) {
            int completionState = this.f();
            this.i = Math.max(0, this.i - 2);
            int completionState1 = this.f();
            if (completionState != completionState1) {
                level.a(this.aA_(), (IBlockData)this.m().b(BlockProperties.by, completionState1), 3);
            }
            int i2 = 4;
            this.j = level.ad() + 4L;
        }
        if (this.i == 0) {
            this.m = null;
            this.j = 0L;
            this.k = 0L;
        } else {
            level.a(this.aA_(), this.m().b(), 2);
        }
    }

    private boolean c(NBTTagCompound tag) {
        if (tag.b(b, 8)) {
            this.q = Optionull.a(MinecraftKey.c(tag.l(b)), (T rl) -> ResourceKey.a(Registries.bg, rl));
            this.r = tag.i(c);
            return true;
        }
        return false;
    }

    private boolean d(NBTTagCompound tag) {
        if (this.q == null) {
            return false;
        }
        tag.a(b, this.q.a().toString());
        if (this.r != 0L) {
            tag.a(c, this.r);
        }
        return true;
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        NBTTagCompound compoundTag = super.a(registries);
        if (this.m != null) {
            compoundTag.a(d, this.m.ordinal());
        }
        if (!this.l.f()) {
            compoundTag.a(e, this.l.a(registries));
        }
        return compoundTag;
    }

    public PacketPlayOutTileEntityData b() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.l = !this.c(tag) && tag.e(e) ? ItemStack.a(registries, (NBTBase)tag.p(e)).orElse(ItemStack.j) : ItemStack.j;
        if (tag.e(d)) {
            this.m = EnumDirection.values()[tag.h(d)];
        }
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        if (!this.d(tag) && !this.l.f()) {
            tag.a(e, this.l.a(registries));
        }
    }

    public void a(ResourceKey<LootTable> lootTable, long seed) {
        this.q = lootTable;
        this.r = seed;
    }

    private int f() {
        if (this.i == 0) {
            return 0;
        }
        if (this.i < 3) {
            return 1;
        }
        return this.i < 6 ? 2 : 3;
    }

    @Nullable
    public EnumDirection c() {
        return this.m;
    }

    public ItemStack d() {
        return this.l;
    }
}

