/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SnifferEggBlock
extends Block {
    public static final MapCodec<SnifferEggBlock> a = SnifferEggBlock.b(SnifferEggBlock::new);
    public static final int b = 2;
    public static final BlockStateInteger c = BlockProperties.aH;
    private static final int d = 24000;
    private static final int e = 12000;
    private static final int f = 300;
    private static final VoxelShape g = Block.a(1.0, 0.0, 2.0, 15.0, 16.0, 14.0);

    public MapCodec<SnifferEggBlock> a() {
        return a;
    }

    public SnifferEggBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.F.b().b(c, 0));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{c});
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return g;
    }

    public int o(IBlockData state) {
        return state.c(c);
    }

    private boolean q(IBlockData state) {
        return this.o(state) == 2;
    }

    private void rescheduleTick(WorldServer level, BlockPosition pos) {
        int baseDelay = SnifferEggBlock.a(level, pos) ? level.paperConfig().entities.sniffer.boostedHatchTime.or(12000) : level.paperConfig().entities.sniffer.hatchTime.or(24000);
        level.a(pos, (Block)this, baseDelay / 3 + level.A.a(300));
    }

    @Override
    public void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (!this.q(state)) {
            if (!CraftEventFactory.handleBlockGrowEvent(level, pos, (IBlockData)state.b(c, this.o(state) + 1), 2)) {
                this.rescheduleTick(level, pos);
                return;
            }
            level.a(null, pos, SoundEffects.zm, SoundCategory.e, 0.7f, 0.9f + random.i() * 0.2f);
        } else {
            if (CraftEventFactory.callBlockFadeEvent(level, pos, state.y().g()).isCancelled()) {
                this.rescheduleTick(level, pos);
                return;
            }
            level.a(null, pos, SoundEffects.zn, SoundCategory.e, 0.7f, 0.9f + random.i() * 0.2f);
            level.b(pos, false);
            Sniffer sniffer = EntityTypes.bi.a(level, EntitySpawnReason.e);
            if (sniffer != null) {
                Vec3D center = pos.b();
                sniffer.a(true);
                sniffer.b(center.a(), center.b(), center.c(), MathHelper.h(level.A.i() * 360.0f), 0.0f);
                level.addFreshEntity(sniffer, CreatureSpawnEvent.SpawnReason.EGG);
            }
        }
    }

    @Override
    public void b(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        boolean flag = SnifferEggBlock.a(level, pos);
        if (!level.B_() && flag) {
            level.c(3009, pos, 0);
        }
        int i2 = flag ? level.paperConfig().entities.sniffer.boostedHatchTime.or(12000) : level.paperConfig().entities.sniffer.hatchTime.or(24000);
        int i1 = i2 / 3;
        level.a(GameEvent.i, pos, GameEvent.a.a(state));
        level.a(pos, (Block)this, i1 + level.A.a(300));
    }

    @Override
    public boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    public static boolean a(IBlockAccess level, BlockPosition pos) {
        return level.a_(pos.e()).a(TagsBlock.cv);
    }
}

