/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.event.block.Action;

public class SculkShriekerBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<SculkShriekerBlock> a = SculkShriekerBlock.b(SculkShriekerBlock::new);
    public static final BlockStateBoolean b = BlockProperties.D;
    public static final BlockStateBoolean c = BlockProperties.J;
    public static final BlockStateBoolean d = BlockProperties.f;
    protected static final VoxelShape e = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final double f = e.c(EnumDirection.EnumAxis.b);

    public MapCodec<SculkShriekerBlock> a() {
        return a;
    }

    public SculkShriekerBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, false)).b(c, false)).b(d, false));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
        builder.a(new IBlockState[]{c});
        builder.a(new IBlockState[]{d});
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, Entity entity) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            EntityPlayer serverPlayer = SculkShriekerBlockEntity.a(entity);
            if (serverPlayer != null) {
                if (CraftEventFactory.callPlayerInteractEvent(serverPlayer, Action.PHYSICAL, pos, null, null, null).isCancelled()) {
                    return;
                }
                serverLevel.a(pos, TileEntityTypes.M).ifPresent(sculkShrieker -> sculkShrieker.a(serverLevel, serverPlayer));
            }
        }
        super.a(level, pos, state, entity);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData newState, boolean movedByPiston) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (state.c(b).booleanValue() && !state.a(newState.b())) {
                serverLevel.a(pos, TileEntityTypes.M).ifPresent(sculkShrieker -> sculkShrieker.a(serverLevel));
            }
        }
        super.a(state, level, pos, newState, movedByPiston);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (state.c(b).booleanValue()) {
            level.a(pos, (IBlockData)state.b(b, false), 3);
            level.a(pos, TileEntityTypes.M).ifPresent(sculkShrieker -> sculkShrieker.a(level));
        }
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return e;
    }

    @Override
    protected VoxelShape d_(IBlockData state) {
        return e;
    }

    @Override
    protected boolean g_(IBlockData state) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new SculkShriekerBlockEntity(pos, state);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(c).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        return (IBlockData)this.m().b(c, context.q().b_(context.a()).a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(c) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, ItemStack stack, boolean dropExperience) {
        super.a(state, level, pos, stack, dropExperience);
    }

    @Override
    public int getExpDrop(IBlockData state, WorldServer level, BlockPosition pos, ItemStack stack, boolean dropExperience) {
        if (dropExperience) {
            return this.tryDropExperience(level, pos, stack, ConstantInt.a(5));
        }
        return 0;
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return !level.C ? BlockTileEntity.a(blockEntityType, TileEntityTypes.M, (World level1, BlockPosition pos, IBlockData state1, ? super E blockEntity) -> VibrationSystem.c.a(level1, blockEntity.gt(), blockEntity.gu())) : null;
    }
}

