/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;

public class PitcherCropBlock
extends BlockTallPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<PitcherCropBlock> c = PitcherCropBlock.b(PitcherCropBlock::new);
    public static final BlockStateInteger d = BlockProperties.aw;
    public static final int e = 4;
    private static final int f = 3;
    private static final int g = 1;
    private static final VoxelShape h = Block.a(3.0, 0.0, 3.0, 13.0, 15.0, 13.0);
    private static final VoxelShape i = Block.a(3.0, -1.0, 3.0, 13.0, 16.0, 13.0);
    private static final VoxelShape j = Block.a(5.0, -1.0, 5.0, 11.0, 3.0, 11.0);
    private static final VoxelShape k = Block.a(3.0, -1.0, 3.0, 13.0, 5.0, 13.0);
    private static final VoxelShape[] l = new VoxelShape[]{Block.a(3.0, 0.0, 3.0, 13.0, 11.0, 13.0), h};
    private static final VoxelShape[] m = new VoxelShape[]{j, Block.a(3.0, -1.0, 3.0, 13.0, 14.0, 13.0), i, i, i};

    public MapCodec<PitcherCropBlock> a() {
        return c;
    }

    public PitcherCropBlock(BlockBase.Info properties) {
        super(properties);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        return this.m();
    }

    @Override
    public VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.a ? l[Math.min(Math.abs(4 - (state.c(d) + 1)), l.length - 1)] : m[state.c(d)];
    }

    @Override
    public VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        if (state.c(d) == 0) {
            return j;
        }
        return state.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.b ? k : super.b(state, level, pos, context);
    }

    @Override
    public IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (PitcherCropBlock.b(state.c(d))) {
            return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }
        return state.a(level, pos) ? state : Blocks.a.m();
    }

    @Override
    public boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return (!PitcherCropBlock.o(state) || PitcherCropBlock.b(level, pos)) && super.a(state, level, pos);
    }

    @Override
    protected boolean b(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return state.a(Blocks.cK);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{d});
        super.a(builder);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (entity instanceof EntityRavager && serverLevel.O().b(GameRules.c)) {
                serverLevel.a(pos, true, entity);
            }
        }
        super.a(state, level, pos, entity);
    }

    @Override
    public boolean a(IBlockData state, BlockActionContext useContext) {
        return false;
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack stack) {
    }

    @Override
    public boolean f(IBlockData state) {
        return state.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.b && !this.q(state);
    }

    @Override
    public void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        boolean flag;
        float growthSpeed = BlockCrops.a(this, level, pos);
        boolean bl = flag = (double)random.i() < (double)level.spigotConfig.pitcherPlantModifier / (100.0 * (Math.floor(25.0f / growthSpeed) + 1.0));
        if (flag) {
            this.a(level, state, pos, 1);
        }
    }

    private void a(WorldServer level, IBlockData state, BlockPosition pos, int ageIncrement) {
        int min = Math.min(state.c(d) + ageIncrement, 4);
        if (this.a((IWorldReader)level, pos, state, min)) {
            IBlockData blockState = (IBlockData)state.b(d, min);
            if (!CraftEventFactory.handleBlockGrowEvent(level, pos, blockState, 2)) {
                return;
            }
            if (PitcherCropBlock.b(min)) {
                level.a(pos.d(), (IBlockData)blockState.b(BlockTallPlant.b, BlockPropertyDoubleBlockHalf.a), 3);
            }
        }
    }

    private static boolean a(IWorldReader level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos);
        return blockState.l() || blockState.a(Blocks.ld);
    }

    private static boolean b(IWorldReader level, BlockPosition pos) {
        return BlockCrops.a(level, pos);
    }

    private static boolean o(IBlockData state) {
        return state.a(Blocks.ld) && state.c(BlockTallPlant.b) == BlockPropertyDoubleBlockHalf.b;
    }

    private static boolean b(int age) {
        return age >= 3;
    }

    private boolean a(IWorldReader reader, BlockPosition pos, IBlockData state, int age) {
        return !this.q(state) && PitcherCropBlock.b(reader, pos) && (!PitcherCropBlock.b(age) || PitcherCropBlock.a(reader, pos.d()));
    }

    private boolean q(IBlockData state) {
        return state.c(d) >= 4;
    }

    @Nullable
    private a c(IWorldReader level, BlockPosition pos, IBlockData state) {
        if (PitcherCropBlock.o(state)) {
            return new a(pos, state);
        }
        BlockPosition blockPos = pos.e();
        IBlockData blockState = level.a_(blockPos);
        return PitcherCropBlock.o(blockState) ? new a(blockPos, blockState) : null;
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        a lowerHalf = this.c(level, pos, state);
        return lowerHalf != null && this.a(level, lowerHalf.a, lowerHalf.b, lowerHalf.b.c(d) + 1);
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        a lowerHalf = this.c(level, pos, state);
        if (lowerHalf != null) {
            this.a(level, lowerHalf.b, lowerHalf.a, 1);
        }
    }

    record a(BlockPosition a, IBlockData b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos;state", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos;state", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos;state", "a", "b"}, this, o2);
        }
    }
}

