/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class MultifaceBlock
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<MultifaceBlock> b = MultifaceBlock.b(MultifaceBlock::new);
    public static final BlockStateBoolean c = BlockProperties.J;
    private static final float a = 1.0f;
    private static final VoxelShape e = Block.a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape f = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape g = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape h = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape i = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape j = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, BlockStateBoolean> k = BlockSprawling.h;
    private static final Map<EnumDirection, VoxelShape> l = SystemUtils.a(Maps.newEnumMap(EnumDirection.class), (? super T map) -> {
        map.put(EnumDirection.c, i);
        map.put(EnumDirection.f, h);
        map.put(EnumDirection.d, j);
        map.put(EnumDirection.e, g);
        map.put(EnumDirection.b, e);
        map.put(EnumDirection.a, f);
    });
    protected static final EnumDirection[] d = EnumDirection.values();
    private final ImmutableMap<IBlockData, VoxelShape> m;
    private final boolean n;
    private final boolean o;
    private final boolean G;

    protected MapCodec<? extends MultifaceBlock> a() {
        return b;
    }

    public MultifaceBlock(BlockBase.Info properties) {
        super(properties);
        this.l(MultifaceBlock.a(this.F));
        this.m = this.a(MultifaceBlock::r);
        this.n = EnumDirection.EnumDirectionLimit.a.a().allMatch(this::a);
        this.o = EnumDirection.EnumDirectionLimit.a.a().filter(EnumDirection.EnumAxis.a).filter(this::a).count() % 2L == 0L;
        this.G = EnumDirection.EnumDirectionLimit.a.a().filter(EnumDirection.EnumAxis.c).filter(this::a).count() % 2L == 0L;
    }

    public static Set<EnumDirection> o(IBlockData state) {
        if (!(state.b() instanceof MultifaceBlock)) {
            return Set.of();
        }
        EnumSet<EnumDirection> set = EnumSet.noneOf(EnumDirection.class);
        for (EnumDirection direction : EnumDirection.values()) {
            if (!MultifaceBlock.a(state, direction)) continue;
            set.add(direction);
        }
        return set;
    }

    public static Set<EnumDirection> a(byte packedDirections) {
        EnumSet<EnumDirection> set = EnumSet.noneOf(EnumDirection.class);
        for (EnumDirection direction : EnumDirection.values()) {
            if ((packedDirections & (byte)(1 << direction.ordinal())) <= 0) continue;
            set.add(direction);
        }
        return set;
    }

    public static byte a(Collection<EnumDirection> directions) {
        byte b2 = 0;
        for (EnumDirection direction : directions) {
            b2 = (byte)(b2 | 1 << direction.ordinal());
        }
        return b2;
    }

    protected boolean a(EnumDirection face) {
        return true;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        for (EnumDirection direction : d) {
            if (!this.a(direction)) continue;
            builder.a(new IBlockState[]{MultifaceBlock.b(direction)});
        }
        builder.a(new IBlockState[]{c});
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(c).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        if (!MultifaceBlock.q(state)) {
            return this.b_(state).g();
        }
        return MultifaceBlock.a(state, direction) && !MultifaceBlock.a(level, direction, neighborPos, neighborState) ? MultifaceBlock.a(state, MultifaceBlock.b(direction)) : state;
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(c) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return (VoxelShape)this.m.get((Object)state);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        boolean flag = false;
        for (EnumDirection direction : d) {
            if (!MultifaceBlock.a(state, direction)) continue;
            if (!MultifaceBlock.a((IBlockAccess)level, pos, direction)) {
                return false;
            }
            flag = true;
        }
        return flag;
    }

    @Override
    protected boolean a(IBlockData state, BlockActionContext useContext) {
        return !useContext.n().a(this.j()) || MultifaceBlock.s(state);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        World level = context.q();
        BlockPosition clickedPos = context.a();
        IBlockData blockState = level.a_(clickedPos);
        return Arrays.stream(context.f()).map(lookingDirection -> this.c(blockState, (IBlockAccess)level, clickedPos, (EnumDirection)lookingDirection)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean a(IBlockAccess level, IBlockData state, BlockPosition pos, EnumDirection direction) {
        if (!(!this.a(direction) || state.a(this) && MultifaceBlock.a(state, direction))) {
            BlockPosition blockPos = pos.a(direction);
            return MultifaceBlock.a(level, direction, blockPos, level.a_(blockPos));
        }
        return false;
    }

    @Nullable
    public IBlockData c(IBlockData currentState, IBlockAccess level, BlockPosition pos, EnumDirection lookingDirection) {
        if (!this.a(level, currentState, pos, lookingDirection)) {
            return null;
        }
        IBlockData blockState = currentState.a(this) ? currentState : (currentState.y().a(FluidTypes.c) ? (IBlockData)this.m().b(BlockProperties.J, true) : this.m());
        return (IBlockData)blockState.b(MultifaceBlock.b(lookingDirection), true);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return !this.n ? state : this.a(state, rotation::a);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        if (mirror == EnumBlockMirror.c && !this.o) {
            return state;
        }
        return mirror == EnumBlockMirror.b && !this.G ? state : this.a(state, mirror::b);
    }

    private IBlockData a(IBlockData state, Function<EnumDirection, EnumDirection> directionalFunction) {
        IBlockData blockState = state;
        for (EnumDirection direction : d) {
            if (!this.a(direction)) continue;
            blockState = (IBlockData)blockState.b(MultifaceBlock.b(directionalFunction.apply(direction)), state.c(MultifaceBlock.b(direction)));
        }
        return blockState;
    }

    public static boolean a(IBlockData state, EnumDirection direction) {
        BlockStateBoolean faceProperty = MultifaceBlock.b(direction);
        return state.a(faceProperty, false);
    }

    public static boolean a(IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        BlockPosition blockPos = pos.a(direction);
        IBlockData blockState = level.a_(blockPos);
        return MultifaceBlock.a(level, direction, blockPos, blockState);
    }

    public static boolean a(IBlockAccess level, EnumDirection direction, BlockPosition pos, IBlockData state) {
        return Block.a(state.h(level, pos), direction.g()) || Block.a(state.g(level, pos), direction.g());
    }

    private static IBlockData a(IBlockData state, BlockStateBoolean faceProp) {
        IBlockData blockState = (IBlockData)state.b(faceProp, false);
        return MultifaceBlock.q(blockState) ? blockState : Blocks.a.m();
    }

    public static BlockStateBoolean b(EnumDirection direction) {
        return k.get(direction);
    }

    private static IBlockData a(BlockStateList<Block, IBlockData> stateDefinition) {
        IBlockData blockState = (IBlockData)stateDefinition.b().b(c, false);
        for (BlockStateBoolean booleanProperty : k.values()) {
            blockState = (IBlockData)blockState.c(booleanProperty, false);
        }
        return blockState;
    }

    private static VoxelShape r(IBlockData state) {
        VoxelShape voxelShape = VoxelShapes.a();
        for (EnumDirection direction : d) {
            if (!MultifaceBlock.a(state, direction)) continue;
            voxelShape = VoxelShapes.a(voxelShape, l.get(direction));
        }
        return voxelShape.c() ? VoxelShapes.b() : voxelShape;
    }

    protected static boolean q(IBlockData state) {
        for (EnumDirection direction : d) {
            if (!MultifaceBlock.a(state, direction)) continue;
            return true;
        }
        return false;
    }

    private static boolean s(IBlockData state) {
        for (EnumDirection direction : d) {
            if (MultifaceBlock.a(state, direction)) continue;
            return true;
        }
        return false;
    }
}

