/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class MossyCarpetBlock
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<MossyCarpetBlock> a = MossyCarpetBlock.b(MossyCarpetBlock::new);
    public static final BlockStateBoolean b = BlockProperties.e;
    private static final BlockStateEnum<BlockPropertyWallHeight> c = BlockProperties.aa;
    private static final BlockStateEnum<BlockPropertyWallHeight> d = BlockProperties.Z;
    private static final BlockStateEnum<BlockPropertyWallHeight> e = BlockProperties.ab;
    private static final BlockStateEnum<BlockPropertyWallHeight> f = BlockProperties.ac;
    private static final Map<EnumDirection, BlockStateEnum<BlockPropertyWallHeight>> g = ImmutableMap.copyOf((Map)SystemUtils.a(Maps.newEnumMap(EnumDirection.class), (? super T map) -> {
        map.put(EnumDirection.c, c);
        map.put(EnumDirection.f, d);
        map.put(EnumDirection.d, e);
        map.put(EnumDirection.e, f);
    }));
    private static final float h = 1.0f;
    private static final VoxelShape i = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape j = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape k = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape l = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape m = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final int n = 10;
    private static final VoxelShape o = Block.a(0.0, 0.0, 0.0, 1.0, 10.0, 16.0);
    private static final VoxelShape G = Block.a(15.0, 0.0, 0.0, 16.0, 10.0, 16.0);
    private static final VoxelShape H = Block.a(0.0, 0.0, 0.0, 16.0, 10.0, 1.0);
    private static final VoxelShape I = Block.a(0.0, 0.0, 15.0, 16.0, 10.0, 16.0);
    private final Map<IBlockData, VoxelShape> J;

    public MapCodec<MossyCarpetBlock> a() {
        return a;
    }

    public MossyCarpetBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, true)).b(c, BlockPropertyWallHeight.a)).b(d, BlockPropertyWallHeight.a)).b(e, BlockPropertyWallHeight.a)).b(f, BlockPropertyWallHeight.a));
        this.J = ImmutableMap.copyOf(this.F.a().stream().collect(Collectors.toMap(Function.identity(), MossyCarpetBlock::o)));
    }

    @Override
    protected VoxelShape d_(IBlockData state) {
        return VoxelShapes.a();
    }

    private static VoxelShape o(IBlockData state) {
        VoxelShape voxelShape = VoxelShapes.a();
        if (state.c(b).booleanValue()) {
            voxelShape = i;
        }
        voxelShape = switch (state.c(c)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyWallHeight.a -> voxelShape;
            case BlockPropertyWallHeight.b -> VoxelShapes.a(voxelShape, H);
            case BlockPropertyWallHeight.c -> VoxelShapes.a(voxelShape, l);
        };
        voxelShape = switch (state.c(e)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyWallHeight.a -> voxelShape;
            case BlockPropertyWallHeight.b -> VoxelShapes.a(voxelShape, I);
            case BlockPropertyWallHeight.c -> VoxelShapes.a(voxelShape, m);
        };
        voxelShape = switch (state.c(d)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyWallHeight.a -> voxelShape;
            case BlockPropertyWallHeight.b -> VoxelShapes.a(voxelShape, G);
            case BlockPropertyWallHeight.c -> VoxelShapes.a(voxelShape, k);
        };
        voxelShape = switch (state.c(f)) {
            default -> throw new MatchException(null, null);
            case BlockPropertyWallHeight.a -> voxelShape;
            case BlockPropertyWallHeight.b -> VoxelShapes.a(voxelShape, o);
            case BlockPropertyWallHeight.c -> VoxelShapes.a(voxelShape, j);
        };
        return voxelShape.c() ? VoxelShapes.b() : voxelShape;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.J.get(state);
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(b) != false ? i : VoxelShapes.a();
    }

    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos.e());
        return state.c(b).booleanValue() ? !blockState.l() : blockState.a(this) && blockState.c(b) != false;
    }

    private static boolean q(IBlockData state) {
        if (state.c(b).booleanValue()) {
            return true;
        }
        for (BlockStateEnum<BlockPropertyWallHeight> enumProperty : g.values()) {
            if (state.c(enumProperty) == BlockPropertyWallHeight.a) continue;
            return true;
        }
        return false;
    }

    private static boolean a(IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        return direction != EnumDirection.b && MultifaceBlock.a(level, pos, direction);
    }

    private static IBlockData a(IBlockData state, IBlockAccess level, BlockPosition pos, boolean tip) {
        BlockBase.BlockData blockState = null;
        BlockBase.BlockData blockState1 = null;
        tip |= state.c(b).booleanValue();
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockPropertyWallHeight wallSide;
            BlockStateEnum<BlockPropertyWallHeight> propertyForFace = MossyCarpetBlock.a(direction);
            BlockPropertyWallHeight blockPropertyWallHeight = MossyCarpetBlock.a(level, pos, direction) ? (tip ? BlockPropertyWallHeight.b : state.c(propertyForFace)) : (wallSide = BlockPropertyWallHeight.a);
            if (wallSide == BlockPropertyWallHeight.b) {
                if (blockState == null) {
                    blockState = level.a_(pos.d());
                }
                if (blockState.a(Blocks.tX) && blockState.c(propertyForFace) != BlockPropertyWallHeight.a && !blockState.c(b).booleanValue()) {
                    wallSide = BlockPropertyWallHeight.c;
                }
                if (!state.c(b).booleanValue()) {
                    if (blockState1 == null) {
                        blockState1 = level.a_(pos.e());
                    }
                    if (blockState1.a(Blocks.tX) && blockState1.c(propertyForFace) == BlockPropertyWallHeight.a) {
                        wallSide = BlockPropertyWallHeight.a;
                    }
                }
            }
            state = (IBlockData)state.b(propertyForFace, wallSide);
        }
        return state;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        return MossyCarpetBlock.a(this.m(), (IBlockAccess)context.q(), context.a(), true);
    }

    public static void a(GeneratorAccess level, BlockPosition pos, RandomSource random, int flags) {
        IBlockData blockState = Blocks.tX.m();
        IBlockData updatedState = MossyCarpetBlock.a(blockState, (IBlockAccess)level, pos, true);
        level.a(pos, updatedState, 3);
        IBlockData blockState1 = MossyCarpetBlock.a((IBlockAccess)level, pos, random::h);
        if (!blockState1.l()) {
            level.a(pos.d(), blockState1, flags);
        }
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack stack) {
        if (!level.C) {
            RandomSource random = level.H_();
            IBlockData blockState = MossyCarpetBlock.a((IBlockAccess)level, pos, random::h);
            if (!blockState.l()) {
                level.a(pos.d(), blockState, 3);
            }
        }
    }

    private static IBlockData a(IBlockAccess level, BlockPosition pos, BooleanSupplier placeSide) {
        BlockPosition blockPos = pos.d();
        IBlockData blockState = level.a_(blockPos);
        boolean isPaleMossCarpet = blockState.a(Blocks.tX);
        if (!(isPaleMossCarpet && blockState.c(b).booleanValue() || !isPaleMossCarpet && !blockState.v())) {
            IBlockData blockState1 = (IBlockData)Blocks.tX.m().b(b, false);
            IBlockData updatedState = MossyCarpetBlock.a(blockState1, level, pos.d(), true);
            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                BlockStateEnum<BlockPropertyWallHeight> propertyForFace = MossyCarpetBlock.a(direction);
                if (updatedState.c(propertyForFace) == BlockPropertyWallHeight.a || placeSide.getAsBoolean()) continue;
                updatedState = (IBlockData)updatedState.b(propertyForFace, BlockPropertyWallHeight.a);
            }
            return MossyCarpetBlock.q(updatedState) && updatedState != blockState ? updatedState : Blocks.a.m();
        }
        return Blocks.a.m();
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (!state.a(level, pos)) {
            return Blocks.a.m();
        }
        IBlockData updatedState = MossyCarpetBlock.a(state, level, pos, false);
        return !MossyCarpetBlock.q(updatedState) ? Blocks.a.m() : updatedState;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e, f);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return switch (rotation) {
            case EnumBlockRotation.c -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(e))).b(d, state.c(f))).b(e, state.c(c))).b(f, state.c(d));
            case EnumBlockRotation.d -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(d))).b(d, state.c(e))).b(e, state.c(f))).b(f, state.c(c));
            case EnumBlockRotation.b -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(f))).b(d, state.c(c))).b(e, state.c(d))).b(f, state.c(e));
            default -> state;
        };
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return switch (mirror) {
            case EnumBlockMirror.b -> (IBlockData)((IBlockData)state.b(c, state.c(e))).b(e, state.c(c));
            case EnumBlockMirror.c -> (IBlockData)((IBlockData)state.b(d, state.c(f))).b(f, state.c(d));
            default -> super.a(state, mirror);
        };
    }

    @Nullable
    public static BlockStateEnum<BlockPropertyWallHeight> a(EnumDirection direction) {
        return g.get(direction);
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        return state.c(b) != false && !MossyCarpetBlock.a((IBlockAccess)level, pos, () -> true).l();
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        IBlockData blockState = MossyCarpetBlock.a((IBlockAccess)level, pos, () -> true);
        if (!blockState.l()) {
            level.a(pos.d(), blockState, 3);
        }
    }
}

