/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCauldron;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockStates;
import org.bukkit.entity.Entity;
import org.bukkit.event.block.CauldronLevelChangeEvent;

public class LayeredCauldronBlock
extends AbstractCauldronBlock {
    public static final MapCodec<LayeredCauldronBlock> d = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeBase.Precipitation.d.fieldOf("precipitation").forGetter(layeredCauldronBlock -> layeredCauldronBlock.j), (App)CauldronInteraction.b.fieldOf("interactions").forGetter(layeredCauldronBlock -> layeredCauldronBlock.c), LayeredCauldronBlock.t()).apply((Applicative)instance, LayeredCauldronBlock::new));
    public static final int e = 1;
    public static final int f = 3;
    public static final BlockStateInteger g = BlockProperties.aN;
    private static final int h = 6;
    private static final double i = 3.0;
    private final BiomeBase.Precipitation j;

    public MapCodec<LayeredCauldronBlock> a() {
        return d;
    }

    public LayeredCauldronBlock(BiomeBase.Precipitation precipitationType, CauldronInteraction.a interactions, BlockBase.Info properties) {
        super(properties, interactions);
        this.j = precipitationType;
        this.l((IBlockData)this.F.b().b(g, 1));
    }

    @Override
    public boolean d(IBlockData state) {
        return state.c(g) == 3;
    }

    @Override
    protected boolean a(FluidType fluid) {
        return fluid == FluidTypes.c && this.j == BiomeBase.Precipitation.b;
    }

    @Override
    protected double b(IBlockData state) {
        return (6.0 + (double)state.c(g).intValue() * 3.0) / 16.0;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (entity.bY() && this.a(state, pos, entity) && (entity instanceof EntityHuman || serverLevel.O().b(GameRules.c)) && entity.c(serverLevel, pos) && this.handleEntityOnFireInside(state, level, pos, entity)) {
                entity.aH();
            }
        }
    }

    private boolean handleEntityOnFireInside(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (this.j == BiomeBase.Precipitation.c) {
            return LayeredCauldronBlock.lowerFillLevel((IBlockData)Blocks.fP.m().b(g, state.c(g)), level, pos, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH);
        }
        return LayeredCauldronBlock.lowerFillLevel(state, level, pos, entity, CauldronLevelChangeEvent.ChangeReason.EXTINGUISH);
    }

    public static void e(IBlockData state, World level, BlockPosition pos) {
        LayeredCauldronBlock.lowerFillLevel(state, level, pos, null, CauldronLevelChangeEvent.ChangeReason.UNKNOWN);
    }

    public static boolean lowerFillLevel(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        int i2 = state.c(g) - 1;
        IBlockData iblockdata1 = i2 == 0 ? Blocks.fO.m() : (IBlockData)state.b(g, i2);
        return LayeredCauldronBlock.changeLevel(level, pos, iblockdata1, entity, reason);
    }

    public static boolean changeLevel(World level, BlockPosition pos, IBlockData newBlock, @Nullable net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason) {
        return LayeredCauldronBlock.changeLevel(level, pos, newBlock, entity, reason, true);
    }

    public static boolean changeLevel(World level, BlockPosition pos, IBlockData newBlock, @Nullable net.minecraft.world.entity.Entity entity, CauldronLevelChangeEvent.ChangeReason reason, boolean sendGameEvent) {
        CraftBlockState newState = CraftBlockStates.getBlockState(level, pos);
        newState.setData(newBlock);
        CauldronLevelChangeEvent event = new CauldronLevelChangeEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), (Entity)(entity == null ? null : entity.getBukkitEntity()), reason, (BlockState)newState);
        if (!event.callEvent()) {
            return false;
        }
        newState.update(true);
        if (sendGameEvent) {
            level.a(GameEvent.c, pos, GameEvent.a.a(newBlock));
        }
        return true;
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, BiomeBase.Precipitation precipitation) {
        if (BlockCauldron.a(level, precipitation) && state.c(g) != 3 && precipitation == this.j) {
            IBlockData blockState = (IBlockData)state.a(g);
            LayeredCauldronBlock.changeLevel(level, pos, blockState, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL);
        }
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos) {
        return state.c(g);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{g});
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, FluidType fluid) {
        if (!this.d(state)) {
            IBlockData blockState = (IBlockData)state.b(g, state.c(g) + 1);
            if (!LayeredCauldronBlock.changeLevel(level, pos, blockState, null, CauldronLevelChangeEvent.ChangeReason.NATURAL_FILL)) {
                return;
            }
            level.c(1047, pos, 0);
        }
    }
}

