/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;

public class DecoratedPotBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<DecoratedPotBlock> a = DecoratedPotBlock.b(DecoratedPotBlock::new);
    public static final MinecraftKey b = MinecraftKey.b("sherds");
    private static final VoxelShape d = Block.a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);
    private static final BlockStateEnum<EnumDirection> e = BlockProperties.U;
    public static final BlockStateBoolean c = BlockProperties.bz;
    private static final BlockStateBoolean f = BlockProperties.J;

    public MapCodec<DecoratedPotBlock> a() {
        return a;
    }

    protected DecoratedPotBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(e, EnumDirection.c)).b(f, false)).b(c, false));
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(f).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        return (IBlockData)((IBlockData)((IBlockData)this.m().b(e, context.g())).b(f, fluidState.a() == FluidTypes.c)).b(c, false);
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)tileEntity;
            if (level.C) {
                return EnumInteractionResult.a;
            }
            ItemStack theItem = decoratedPotBlockEntity.f();
            if (!stack.f() && (theItem.f() || ItemStack.c(theItem, stack) && theItem.M() < theItem.k())) {
                float f2;
                decoratedPotBlockEntity.a(DecoratedPotBlockEntity.a.a);
                player.b(StatisticList.c.b(stack.h()));
                ItemStack itemStack = stack.b(1, (EntityLiving)player);
                if (decoratedPotBlockEntity.c()) {
                    decoratedPotBlockEntity.b(itemStack);
                    f2 = (float)itemStack.M() / (float)itemStack.k();
                } else {
                    theItem.g(1);
                    f2 = (float)theItem.M() / (float)theItem.k();
                }
                level.a(null, pos, SoundEffects.gT, SoundCategory.e, 1.0f, 0.7f + 0.5f * f2);
                if (level instanceof WorldServer) {
                    WorldServer serverLevel = (WorldServer)level;
                    serverLevel.a(Particles.aZ, (double)pos.u() + 0.5, (double)pos.v() + 1.2, (double)pos.w() + 0.5, 7, 0.0, 0.0, 0.0, 0.0);
                }
                decoratedPotBlockEntity.e();
                level.a((Entity)player, GameEvent.c, pos);
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.f;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)tileEntity;
            level.a(null, pos, SoundEffects.gU, SoundCategory.e, 1.0f, 1.0f);
            decoratedPotBlockEntity.a(DecoratedPotBlockEntity.a.b);
            level.a((Entity)player, GameEvent.c, pos);
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return d;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(e, f, c);
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new DecoratedPotBlockEntity(pos, state);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData newState, boolean movedByPiston) {
        InventoryUtils.a(state, newState, level, pos);
        super.a(state, level, pos, newState, movedByPiston);
    }

    @Override
    protected List<ItemStack> a(IBlockData state, LootParams.a params) {
        TileEntity blockEntity = params.b(LootContextParameters.h);
        if (blockEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)blockEntity;
            params.a(b, (Consumer<ItemStack> output) -> {
                for (Item item : decoratedPotBlockEntity.s().a()) {
                    output.accept(item.n());
                }
            });
        }
        return super.a(state, params);
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        ItemStack mainHandItem = player.eZ();
        IBlockData blockState = state;
        if (mainHandItem.a(TagsItem.bL) && !EnchantmentManager.a(mainHandItem, EnchantmentTags.r)) {
            blockState = (IBlockData)state.b(c, true);
            level.a(pos, blockState, 4);
        }
        return super.a(level, pos, blockState, player);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(f) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected SoundEffectType h_(IBlockData state) {
        return state.c(c) != false ? SoundEffectType.bc : SoundEffectType.bb;
    }

    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltipComponents, TooltipFlag tooltipFlag) {
        super.a(stack, context, tooltipComponents, tooltipFlag);
        PotDecorations potDecorations = stack.a(DataComponents.ak, PotDecorations.a);
        if (!potDecorations.equals(PotDecorations.a)) {
            tooltipComponents.add(CommonComponents.a);
            Stream.of(potDecorations.e(), potDecorations.c(), potDecorations.d(), potDecorations.b()).forEach(optional -> tooltipComponents.add(new ItemStack(optional.orElse(Items.rs), 1).y().e().a(EnumChatFormat.h)));
        }
    }

    @Override
    protected void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        WorldServer serverLevel;
        BlockPosition blockPos = hit.b();
        if (level instanceof WorldServer && projectile.c(serverLevel = (WorldServer)level, blockPos) && projectile.a(serverLevel)) {
            if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockPos, this.b_(state).g())) {
                return;
            }
            level.a(blockPos, (IBlockData)state.b(c, true), 4);
            level.a(blockPos, true, projectile);
        }
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof DecoratedPotBlockEntity) {
            DecoratedPotBlockEntity decoratedPotBlockEntity = (DecoratedPotBlockEntity)tileEntity;
            PotDecorations decorations = decoratedPotBlockEntity.s();
            return DecoratedPotBlockEntity.a(decorations);
        }
        return super.a(level, pos, state, includeData);
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos) {
        return Container.a(level.c_(pos));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(e, rotation.a(state.c(e)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(e)));
    }
}

