/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.ServerExplosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.CreakingHeartBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;

public class CreakingHeartBlock
extends BlockTileEntity {
    public static final MapCodec<CreakingHeartBlock> a = CreakingHeartBlock.b(CreakingHeartBlock::new);
    public static final BlockStateEnum<EnumDirection.EnumAxis> b = BlockProperties.L;
    public static final BlockStateBoolean c = BlockProperties.a;
    public static final BlockStateBoolean d = BlockProperties.x;

    public MapCodec<CreakingHeartBlock> a() {
        return a;
    }

    protected CreakingHeartBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.m().b(b, EnumDirection.EnumAxis.b)).b(c, false)).b(d, false));
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new CreakingHeartBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        if (level.C) {
            return null;
        }
        return state.c(c) != false ? CreakingHeartBlock.a(blockEntityType, TileEntityTypes.k, CreakingHeartBlockEntity::a) : null;
    }

    public static boolean a(World level) {
        return level.G_().j() && level.W();
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        if (CreakingHeartBlock.a(level) && state.c(c).booleanValue() && random.a(16) == 0 && CreakingHeartBlock.a(level, pos)) {
            level.a(pos.u(), (double)pos.v(), (double)pos.w(), SoundEffects.gB, SoundCategory.e, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        IBlockData blockState = super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        return CreakingHeartBlock.c(blockState, level, pos);
    }

    private static IBlockData c(IBlockData state, IWorldReader level, BlockPosition pos) {
        boolean hasRequiredLogs = CreakingHeartBlock.b(state, level, pos);
        boolean flag = state.c(c) == false;
        return hasRequiredLogs && flag ? (IBlockData)state.b(c, true) : state;
    }

    public static boolean b(IBlockData state, IWorldReader level, BlockPosition pos) {
        EnumDirection.EnumAxis axis = state.c(b);
        for (EnumDirection direction : axis.g()) {
            IBlockData blockState = level.a_(pos.a(direction));
            if (blockState.a(TagsBlock.w) && blockState.c(b) == axis) continue;
            return false;
        }
        return true;
    }

    private static boolean a(GeneratorAccess level, BlockPosition pos) {
        for (EnumDirection direction : EnumDirection.values()) {
            BlockPosition blockPos = pos.a(direction);
            IBlockData blockState = level.a_(blockPos);
            if (blockState.a(TagsBlock.w)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        return CreakingHeartBlock.c((IBlockData)this.m().b(b, context.k().o()), (IWorldReader)context.q(), context.a());
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return BlockRotatable.b(state, rotation);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData newState, boolean movedByPiston) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity;
            creakingHeartBlockEntity.a((DamageSource)null);
        }
        super.a(state, level, pos, newState, movedByPiston);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity;
            if (explosion instanceof ServerExplosion) {
                ServerExplosion serverExplosion = (ServerExplosion)explosion;
                if (explosion.b().a()) {
                    creakingHeartBlockEntity.a(serverExplosion.k());
                    EntityLiving entityLiving = explosion.c();
                    if (entityLiving instanceof EntityHuman) {
                        EntityHuman player = (EntityHuman)entityLiving;
                        if (explosion.b().a()) {
                            this.a(player, state, level, pos);
                        }
                    }
                }
            }
        }
        super.a(state, level, pos, explosion, dropConsumer);
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity;
            creakingHeartBlockEntity.a(player.dW().a(player));
            this.a(player, state, level, pos);
        }
        return super.a(level, pos, state, player);
    }

    private void a(EntityHuman player, IBlockData state, World level, BlockPosition pos) {
        if (!player.b() && !player.Z_() && state.c(d).booleanValue() && level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            this.a(serverLevel, pos, level.A.a(20, 24));
        }
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos) {
        int n2;
        if (!state.c(c).booleanValue()) {
            return 0;
        }
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof CreakingHeartBlockEntity) {
            CreakingHeartBlockEntity creakingHeartBlockEntity = (CreakingHeartBlockEntity)tileEntity;
            n2 = creakingHeartBlockEntity.d();
        } else {
            n2 = 0;
        }
        return n2;
    }
}

