/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class CeilingHangingSignBlock
extends BlockSign {
    public static final MapCodec<CeilingHangingSignBlock> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPropertyWood.a.fieldOf("wood_type").forGetter(BlockSign::d), CeilingHangingSignBlock.t()).apply((Applicative)instance, CeilingHangingSignBlock::new));
    public static final BlockStateInteger b = BlockProperties.bd;
    public static final BlockStateBoolean c = BlockProperties.b;
    protected static final float d = 5.0f;
    protected static final VoxelShape e = Block.a(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    private static final Map<Integer, VoxelShape> i = Maps.newHashMap((Map)ImmutableMap.of((Object)0, (Object)Block.a(1.0, 0.0, 7.0, 15.0, 10.0, 9.0), (Object)4, (Object)Block.a(7.0, 0.0, 1.0, 9.0, 10.0, 15.0), (Object)8, (Object)Block.a(1.0, 0.0, 7.0, 15.0, 10.0, 9.0), (Object)12, (Object)Block.a(7.0, 0.0, 1.0, 9.0, 10.0, 15.0)));

    public MapCodec<CeilingHangingSignBlock> a() {
        return a;
    }

    public CeilingHangingSignBlock(BlockPropertyWood type, BlockBase.Info properties) {
        super(type, properties.a(type.e()));
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, 0)).b(c, false)).b(BlockSign.f, false));
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        TileEntitySign signBlockEntity;
        TileEntity tileEntity = level.c_(pos);
        return tileEntity instanceof TileEntitySign && this.a(player, hitResult, signBlockEntity = (TileEntitySign)tileEntity, stack) ? EnumInteractionResult.e : super.a(stack, state, level, pos, player, hand, hitResult);
    }

    private boolean a(EntityHuman player, MovingObjectPositionBlock hitResult, TileEntitySign sign, ItemStack stack) {
        return !sign.a(sign.a(player), player) && stack.h() instanceof HangingSignItem && hitResult.c().equals(EnumDirection.a);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return level.a_(pos.d()).a((IBlockAccess)level, pos.d(), EnumDirection.a, EnumBlockSupport.b);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        boolean flag;
        World level = context.q();
        Fluid fluidState = level.b_(context.a());
        BlockPosition blockPos = context.a().d();
        IBlockData blockState = level.a_(blockPos);
        boolean isAllHangingSigns = blockState.a(TagsBlock.aD);
        EnumDirection direction = EnumDirection.a(context.i());
        boolean bl = flag = !Block.a(blockState.g(level, blockPos), EnumDirection.a) || context.h();
        if (isAllHangingSigns && !context.h()) {
            Optional<EnumDirection> optional;
            if (blockState.b(WallHangingSignBlock.b)) {
                EnumDirection direction1 = blockState.c(WallHangingSignBlock.b);
                if (direction1.o().a(direction)) {
                    flag = false;
                }
            } else if (blockState.b(b) && (optional = RotationSegment.a(blockState.c(b))).isPresent() && optional.get().o().a(direction)) {
                flag = false;
            }
        }
        int i2 = !flag ? RotationSegment.a(direction.g()) : RotationSegment.a(context.i() + 180.0f);
        return (IBlockData)((IBlockData)((IBlockData)this.m().b(c, flag)).b(b, i2)).b(BlockSign.f, fluidState.a() == FluidTypes.c);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        VoxelShape voxelShape = i.get(state.c(b));
        return voxelShape == null ? e : voxelShape;
    }

    @Override
    protected VoxelShape b_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return this.a(state, level, pos, VoxelShapeCollision.a());
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return direction == EnumDirection.b && !this.a(state, level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public float h(IBlockData state) {
        return RotationSegment.b(state.c(b));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b), 16));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return (IBlockData)state.b(b, mirror.a(state.c(b), 16));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, BlockSign.f);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new HangingSignBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return null;
    }
}

