/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class CandleCakeBlock
extends AbstractCandleBlock {
    public static final MapCodec<CandleCakeBlock> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.e.q().fieldOf("candle").forGetter(candleCakeBlock -> candleCakeBlock.k), CandleCakeBlock.t()).apply((Applicative)instance, CandleCakeBlock::new));
    public static final BlockStateBoolean d = AbstractCandleBlock.b;
    protected static final float e = 1.0f;
    protected static final VoxelShape f = Block.a(1.0, 0.0, 1.0, 15.0, 8.0, 15.0);
    protected static final VoxelShape g = Block.a(7.0, 8.0, 7.0, 9.0, 14.0, 9.0);
    protected static final VoxelShape h = VoxelShapes.a(f, g);
    private static final Map<CandleBlock, CandleCakeBlock> i = Maps.newHashMap();
    private static final Iterable<Vec3D> j = ImmutableList.of((Object)new Vec3D(0.5, 1.0, 0.5));
    private final CandleBlock k;

    public MapCodec<CandleCakeBlock> a() {
        return c;
    }

    protected CandleCakeBlock(Block candleBlock, BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.F.b().b(d, false));
        if (!(candleBlock instanceof CandleBlock)) {
            throw new IllegalArgumentException("Expected block to be of " + String.valueOf(CandleBlock.class) + " was " + String.valueOf(candleBlock.getClass()));
        }
        CandleBlock candleBlock1 = (CandleBlock)candleBlock;
        i.put(candleBlock1, this);
        this.k = candleBlock1;
    }

    @Override
    protected Iterable<Vec3D> b(IBlockData state) {
        return j;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return h;
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        if (stack.a(Items.oX) || stack.a(Items.uV)) {
            return EnumInteractionResult.e;
        }
        if (CandleCakeBlock.a(hitResult) && stack.f() && state.c(d).booleanValue()) {
            CandleCakeBlock.a(player, state, (GeneratorAccess)level, pos);
            return EnumInteractionResult.a;
        }
        return super.a(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        EnumInteractionResult interactionResult = BlockCake.a((GeneratorAccess)level, pos, Blocks.et.m(), player);
        if (interactionResult.a()) {
            CandleCakeBlock.c(state, level, pos);
        }
        return interactionResult;
    }

    private static boolean a(MovingObjectPositionBlock hit) {
        return hit.g().e - (double)hit.b().v() > 0.5;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{d});
    }

    @Override
    protected ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return new ItemStack(Blocks.et);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return direction == EnumDirection.a && !state.a(level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return level.a_(pos.e()).e();
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos) {
        return BlockCake.d;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    public static IBlockData a(CandleBlock candle) {
        return i.get(candle).m();
    }

    public static boolean h(IBlockData state) {
        return state.a(TagsBlock.bm, (BlockBase.BlockData blockStateBase) -> blockStateBase.b(d) && state.c(d) == false);
    }
}

