/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTorch;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockTorchWall
extends BlockTorch {
    public static final MapCodec<BlockTorchWall> f = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockTorch.c.forGetter(wallTorchBlock -> wallTorchBlock.e), BlockTorchWall.t()).apply((Applicative)instance, BlockTorchWall::new));
    public static final BlockStateEnum<EnumDirection> g = BlockFacingHorizontal.aF;
    protected static final float h = 2.5f;
    private static final Map<EnumDirection, VoxelShape> i = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumDirection.c, (Object)Block.a(5.5, 3.0, 11.0, 10.5, 13.0, 16.0), (Object)EnumDirection.d, (Object)Block.a(5.5, 3.0, 0.0, 10.5, 13.0, 5.0), (Object)EnumDirection.e, (Object)Block.a(11.0, 3.0, 5.5, 16.0, 13.0, 10.5), (Object)EnumDirection.f, (Object)Block.a(0.0, 3.0, 5.5, 5.0, 13.0, 10.5)));

    public MapCodec<BlockTorchWall> a() {
        return f;
    }

    protected BlockTorchWall(ParticleType flameParticle, BlockBase.Info properties) {
        super(flameParticle, properties);
        this.l((IBlockData)this.F.b().b(g, EnumDirection.c));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return BlockTorchWall.o(state);
    }

    public static VoxelShape o(IBlockData state) {
        return i.get(state.c(g));
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return BlockTorchWall.b(level, pos, state.c(g));
    }

    public static boolean b(IWorldReader level, BlockPosition pos, EnumDirection facing) {
        BlockPosition blockPos = pos.a(facing.g());
        IBlockData blockState = level.a_(blockPos);
        return blockState.c((IBlockAccess)level, blockPos, facing);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        EnumDirection[] nearestLookingDirections;
        IBlockData blockState = this.m();
        World level = context.q();
        BlockPosition clickedPos = context.a();
        for (EnumDirection direction : nearestLookingDirections = context.f()) {
            EnumDirection opposite;
            if (!direction.o().d() || !(blockState = (IBlockData)blockState.b(g, opposite = direction.g())).a((IWorldReader)level, clickedPos)) continue;
            return blockState;
        }
        return null;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return direction.g() == state.c(g) && !state.a(level, pos) ? Blocks.a.m() : state;
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        EnumDirection direction = state.c(g);
        double d2 = (double)pos.u() + 0.5;
        double d1 = (double)pos.v() + 0.7;
        double d22 = (double)pos.w() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        EnumDirection opposite = direction.g();
        level.a(Particles.ag, d2 + 0.27 * (double)opposite.j(), d1 + 0.22, d22 + 0.27 * (double)opposite.l(), 0.0, 0.0, 0.0);
        level.a(this.e, d2 + 0.27 * (double)opposite.j(), d1 + 0.22, d22 + 0.27 * (double)opposite.l(), 0.0, 0.0, 0.0);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(g, rotation.a(state.c(g)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(g)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{g});
    }
}

