/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSprawling;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class BlockTall
extends Block
implements IBlockWaterlogged {
    public static final BlockStateBoolean a = BlockSprawling.b;
    public static final BlockStateBoolean b = BlockSprawling.c;
    public static final BlockStateBoolean c = BlockSprawling.d;
    public static final BlockStateBoolean d = BlockSprawling.e;
    public static final BlockStateBoolean e = BlockProperties.J;
    protected static final Map<EnumDirection, BlockStateBoolean> f = BlockSprawling.h.entrySet().stream().filter(direction -> ((EnumDirection)direction.getKey()).o().d()).collect(SystemUtils.a());
    protected final VoxelShape[] g;
    protected final VoxelShape[] h;
    private final Object2IntMap<IBlockData> i = new Object2IntOpenHashMap();

    protected BlockTall(float nodeWidth, float extensionWidth, float nodeHeight, float extensionHeight, float collisionHeight, BlockBase.Info properties) {
        super(properties);
        this.g = this.a(nodeWidth, extensionWidth, collisionHeight, 0.0f, collisionHeight);
        this.h = this.a(nodeWidth, extensionWidth, nodeHeight, 0.0f, extensionHeight);
        for (IBlockData blockState : this.F.a()) {
            this.h(blockState);
        }
    }

    protected abstract MapCodec<? extends BlockTall> a();

    protected VoxelShape[] a(float nodeWidth, float extensionWidth, float nodeHeight, float extensionBottom, float extensionHeight) {
        float f2 = 8.0f - nodeWidth;
        float f1 = 8.0f + nodeWidth;
        float f22 = 8.0f - extensionWidth;
        float f3 = 8.0f + extensionWidth;
        VoxelShape voxelShape = Block.a(f2, 0.0, f2, f1, nodeHeight, f1);
        VoxelShape voxelShape1 = Block.a(f22, extensionBottom, 0.0, f3, extensionHeight, f3);
        VoxelShape voxelShape2 = Block.a(f22, extensionBottom, f22, f3, extensionHeight, 16.0);
        VoxelShape voxelShape3 = Block.a(0.0, extensionBottom, f22, f3, extensionHeight, f3);
        VoxelShape voxelShape4 = Block.a(f22, extensionBottom, f22, 16.0, extensionHeight, f3);
        VoxelShape voxelShape5 = VoxelShapes.a(voxelShape1, voxelShape4);
        VoxelShape voxelShape6 = VoxelShapes.a(voxelShape2, voxelShape3);
        VoxelShape[] voxelShapes = new VoxelShape[]{VoxelShapes.a(), voxelShape2, voxelShape3, voxelShape6, voxelShape1, VoxelShapes.a(voxelShape2, voxelShape1), VoxelShapes.a(voxelShape3, voxelShape1), VoxelShapes.a(voxelShape6, voxelShape1), voxelShape4, VoxelShapes.a(voxelShape2, voxelShape4), VoxelShapes.a(voxelShape3, voxelShape4), VoxelShapes.a(voxelShape6, voxelShape4), voxelShape5, VoxelShapes.a(voxelShape2, voxelShape5), VoxelShapes.a(voxelShape3, voxelShape5), VoxelShapes.a(voxelShape6, voxelShape5)};
        for (int i2 = 0; i2 < 16; ++i2) {
            voxelShapes[i2] = VoxelShapes.a(voxelShape, voxelShapes[i2]);
        }
        return voxelShapes;
    }

    @Override
    protected boolean e_(IBlockData state) {
        return state.c(e) == false;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.h[this.h(state)];
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.g[this.h(state)];
    }

    private static int a(EnumDirection facing) {
        return 1 << facing.e();
    }

    protected int h(IBlockData state) {
        return this.i.computeIntIfAbsent((Object)state, missingState -> {
            int i2 = 0;
            if (missingState.c(a).booleanValue()) {
                i2 |= BlockTall.a(EnumDirection.c);
            }
            if (missingState.c(b).booleanValue()) {
                i2 |= BlockTall.a(EnumDirection.f);
            }
            if (missingState.c(c).booleanValue()) {
                i2 |= BlockTall.a(EnumDirection.d);
            }
            if (missingState.c(d).booleanValue()) {
                i2 |= BlockTall.a(EnumDirection.e);
            }
            return i2;
        });
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(e) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rot) {
        switch (rot) {
            case c: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(a, state.c(c))).b(b, state.c(d))).b(c, state.c(a))).b(d, state.c(b));
            }
            case d: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(a, state.c(b))).b(b, state.c(c))).b(c, state.c(d))).b(d, state.c(a));
            }
            case b: {
                return (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(a, state.c(d))).b(b, state.c(a))).b(c, state.c(b))).b(d, state.c(c));
            }
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        switch (mirror) {
            case b: {
                return (IBlockData)((IBlockData)state.b(a, state.c(c))).b(c, state.c(a));
            }
            case c: {
                return (IBlockData)((IBlockData)state.b(b, state.c(d))).b(d, state.c(b));
            }
        }
        return super.a(state, mirror);
    }
}

