/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.destroystokyo.paper.event.block.TNTPrimeEvent;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.block.TNTPrimeEvent;

public class BlockTNT
extends Block {
    public static final MapCodec<BlockTNT> a = BlockTNT.b(BlockTNT::new);
    public static final BlockStateBoolean b = BlockProperties.I;

    public MapCodec<BlockTNT> a() {
        return a;
    }

    public BlockTNT(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.m().b(b, false));
    }

    @Override
    protected void b(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean isMoving) {
        if (!oldState.a(state.b()) && level.C(pos) && CraftEventFactory.callTNTPrimeEvent(level, pos, TNTPrimeEvent.PrimeCause.REDSTONE, null, null)) {
            CraftBlock tntBlock = CraftBlock.at(level, pos);
            if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.REDSTONE, null).callEvent()) {
                return;
            }
            BlockTNT.a(level, pos);
            level.a(pos, false);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (level.C(pos) && CraftEventFactory.callTNTPrimeEvent(level, pos, TNTPrimeEvent.PrimeCause.REDSTONE, null, null)) {
            CraftBlock tntBlock = CraftBlock.at(level, pos);
            if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.REDSTONE, null).callEvent()) {
                return;
            }
            BlockTNT.a(level, pos);
            level.a(pos, false);
        }
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (!level.B_() && !player.b() && state.c(b).booleanValue() && CraftEventFactory.callTNTPrimeEvent(level, pos, TNTPrimeEvent.PrimeCause.BLOCK_BREAK, player, null)) {
            BlockTNT.a(level, pos);
        }
        return super.a(level, pos, state, player);
    }

    @Override
    public void a(WorldServer level, BlockPosition pos, Explosion explosion) {
        CraftEntity source;
        CraftBlock tntBlock = CraftBlock.at(level, pos);
        CraftEntity craftEntity = source = explosion.d() != null ? explosion.d().getBukkitEntity() : null;
        if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.EXPLOSION, (Entity)source).callEvent()) {
            return;
        }
        EntityTNTPrimed primedTnt = new EntityTNTPrimed(level, (double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, explosion.c());
        int fuse = primedTnt.m();
        primedTnt.b((short)(level.A.a(fuse / 4) + fuse / 8));
        level.b(primedTnt);
    }

    public static void a(World level, BlockPosition pos) {
        BlockTNT.a(level, pos, null);
    }

    private static void a(World level, BlockPosition pos, @Nullable EntityLiving entity) {
        if (!level.C) {
            EntityTNTPrimed primedTnt = new EntityTNTPrimed(level, (double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, entity);
            level.b(primedTnt);
            level.a(null, primedTnt.dA(), primedTnt.dC(), primedTnt.dG(), SoundEffects.Am, SoundCategory.e, 1.0f, 1.0f);
            level.a((net.minecraft.world.entity.Entity)entity, GameEvent.I, pos);
        }
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        if (!stack.a(Items.oX) && !stack.a(Items.uV)) {
            return super.a(stack, state, level, pos, player, hand, hitResult);
        }
        if (!CraftEventFactory.callTNTPrimeEvent(level, pos, TNTPrimeEvent.PrimeCause.PLAYER, player, null)) {
            return EnumInteractionResult.c;
        }
        CraftBlock tntBlock = CraftBlock.at(level, pos);
        if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.ITEM, (Entity)player.getBukkitEntity()).callEvent()) {
            return EnumInteractionResult.d;
        }
        BlockTNT.a(level, pos, player);
        level.a(pos, Blocks.a.m(), 11);
        Item item = stack.h();
        if (stack.a(Items.oX)) {
            stack.a(1, (EntityLiving)player, EntityLiving.d(hand));
        } else {
            stack.a(1, (EntityLiving)player);
        }
        player.b(StatisticList.c.b(item));
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            BlockPosition blockPos = hit.b();
            net.minecraft.world.entity.Entity owner = projectile.p();
            if (projectile.bY() && projectile.c(serverLevel, blockPos)) {
                if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockPos, state.y().g()) || !CraftEventFactory.callTNTPrimeEvent(level, blockPos, TNTPrimeEvent.PrimeCause.PROJECTILE, projectile, null)) {
                    return;
                }
                CraftBlock tntBlock = CraftBlock.at(level, blockPos);
                if (!new TNTPrimeEvent((org.bukkit.block.Block)tntBlock, TNTPrimeEvent.PrimeReason.PROJECTILE, (Entity)projectile.getBukkitEntity()).callEvent()) {
                    return;
                }
                BlockTNT.a(level, blockPos, owner instanceof EntityLiving ? (EntityLiving)owner : null);
                level.a(blockPos, false);
            }
        }
    }

    @Override
    public boolean a(Explosion explosion) {
        return false;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }
}

