/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Collections;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.ItemStack;

public class BlockSweetBerryBush
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockSweetBerryBush> a = BlockSweetBerryBush.b(BlockSweetBerryBush::new);
    private static final float d = 0.003f;
    public static final int b = 3;
    public static final BlockStateInteger c = BlockProperties.av;
    private static final VoxelShape e = Block.a(3.0, 0.0, 3.0, 13.0, 8.0, 13.0);
    private static final VoxelShape f = Block.a(1.0, 0.0, 1.0, 15.0, 16.0, 15.0);

    public MapCodec<BlockSweetBerryBush> a() {
        return a;
    }

    public BlockSweetBerryBush(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.F.b().b(c, 0));
    }

    @Override
    protected net.minecraft.world.item.ItemStack a(IWorldReader level, BlockPosition pos, IBlockData state, boolean includeData) {
        return new net.minecraft.world.item.ItemStack(Items.xv);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        if (state.c(c) == 0) {
            return e;
        }
        return state.c(c) < 3 ? f : super.a(state, level, pos, context);
    }

    @Override
    protected boolean f(IBlockData state) {
        return state.c(c) < 3;
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        int ageValue = state.c(c);
        if (ageValue < 3 && random.i() < (float)level.spigotConfig.sweetBerryModifier / 500.0f && level.b(pos.d(), 0) >= 9) {
            IBlockData blockState = (IBlockData)state.b(c, ageValue + 1);
            if (!CraftEventFactory.handleBlockGrowEvent(level, pos, blockState, 2)) {
                return;
            }
            level.a(GameEvent.c, pos, GameEvent.a.a(blockState));
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (entity instanceof EntityLiving && entity.aq() != EntityTypes.aa && entity.aq() != EntityTypes.l) {
            entity.a(state, new Vec3D(0.8f, 0.75, 0.8f));
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                if (state.c(c) != 0) {
                    Vec3D vec3;
                    Vec3D vec3D = vec3 = entity.di() ? entity.ah() : entity.bC().d(entity.dt());
                    if (vec3.j() > 0.0) {
                        double abs = Math.abs(vec3.a());
                        double abs1 = Math.abs(vec3.c());
                        if (abs >= (double)0.003f || abs1 >= (double)0.003f) {
                            entity.a(serverLevel, level.ak().u().eventBlockDamager(level, pos), 1.0f);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected EnumInteractionResult a(net.minecraft.world.item.ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        int ageValue = state.c(c);
        boolean flag = ageValue == 3;
        return !flag && stack.a(Items.sv) ? EnumInteractionResult.e : super.a(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        boolean flag;
        int ageValue = state.c(c);
        boolean bl = flag = ageValue == 3;
        if (ageValue > 1) {
            int i2 = 1 + level.A.a(2);
            PlayerHarvestBlockEvent event = CraftEventFactory.callPlayerHarvestBlockEvent(level, pos, player, EnumHand.a, Collections.singletonList(new net.minecraft.world.item.ItemStack(Items.xv, i2 + (flag ? 1 : 0))));
            if (event.isCancelled()) {
                return EnumInteractionResult.a;
            }
            for (ItemStack itemStack : event.getItemsHarvested()) {
                BlockSweetBerryBush.a(level, pos, CraftItemStack.asNMSCopy(itemStack));
            }
            level.a(null, pos, SoundEffects.Ag, SoundCategory.e, 1.0f, 0.8f + level.A.i() * 0.4f);
            IBlockData blockState = (IBlockData)state.b(c, 1);
            level.a(pos, blockState, 2);
            level.a(GameEvent.c, pos, GameEvent.a.a(player, blockState));
            return EnumInteractionResult.a;
        }
        return super.a(state, level, pos, player, hitResult);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{c});
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        return state.c(c) < 3;
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        int min = Math.min(3, state.c(c) + 1);
        level.a(pos, (IBlockData)state.b(c, min), 2);
    }
}

