/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;

public class BlockStructure
extends BlockTileEntity
implements GameMasterBlock {
    public static final MapCodec<BlockStructure> a = BlockStructure.b(BlockStructure::new);
    public static final BlockStateEnum<BlockPropertyStructureMode> b = BlockProperties.bm;

    public MapCodec<BlockStructure> a() {
        return a;
    }

    protected BlockStructure(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.F.b().b(b, BlockPropertyStructureMode.b));
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityStructure(pos, state);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityStructure) {
            return (EnumInteractionResult)((Object)(((TileEntityStructure)blockEntity).a(player) ? EnumInteractionResult.a : EnumInteractionResult.e));
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack stack) {
        TileEntity blockEntity;
        if (!level.C && placer != null && (blockEntity = level.c_(pos)) instanceof TileEntityStructure) {
            ((TileEntityStructure)blockEntity).a(placer);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        TileEntity tileEntity;
        if (level instanceof WorldServer && (tileEntity = level.c_(pos)) instanceof TileEntityStructure) {
            TileEntityStructure structureBlockEntity = (TileEntityStructure)tileEntity;
            boolean hasNeighborSignal = level.C(pos);
            boolean isPowered = structureBlockEntity.C();
            if (hasNeighborSignal && !isPowered) {
                structureBlockEntity.c(true);
                this.a((WorldServer)level, structureBlockEntity);
            } else if (!hasNeighborSignal && isPowered) {
                structureBlockEntity.c(false);
            }
        }
    }

    private void a(WorldServer level, TileEntityStructure blockEntity) {
        switch (blockEntity.u()) {
            case a: {
                blockEntity.b(false);
                break;
            }
            case b: {
                blockEntity.c(level);
                break;
            }
            case c: {
                blockEntity.A();
            }
        }
    }
}

