/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyStairsShape;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockStairs
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockStairs> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IBlockData.a.fieldOf("base_state").forGetter(stairBlock -> stairBlock.I), BlockStairs.t()).apply((Applicative)instance, BlockStairs::new));
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.aF;
    public static final BlockStateEnum<BlockPropertyHalf> c = BlockProperties.ai;
    public static final BlockStateEnum<BlockPropertyStairsShape> d = BlockProperties.bl;
    public static final BlockStateBoolean e = BlockProperties.J;
    protected static final VoxelShape f = BlockStepAbstract.e;
    protected static final VoxelShape g = BlockStepAbstract.d;
    protected static final VoxelShape h = Block.a(0.0, 0.0, 0.0, 8.0, 8.0, 8.0);
    protected static final VoxelShape i = Block.a(0.0, 0.0, 8.0, 8.0, 8.0, 16.0);
    protected static final VoxelShape j = Block.a(0.0, 8.0, 0.0, 8.0, 16.0, 8.0);
    protected static final VoxelShape k = Block.a(0.0, 8.0, 8.0, 8.0, 16.0, 16.0);
    protected static final VoxelShape l = Block.a(8.0, 0.0, 0.0, 16.0, 8.0, 8.0);
    protected static final VoxelShape m = Block.a(8.0, 0.0, 8.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape n = Block.a(8.0, 8.0, 0.0, 16.0, 16.0, 8.0);
    protected static final VoxelShape o = Block.a(8.0, 8.0, 8.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] G = BlockStairs.a(f, h, l, i, m);
    protected static final VoxelShape[] H = BlockStairs.a(g, j, n, k, o);
    private static final int[] J = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block K;
    protected final IBlockData I;

    public MapCodec<? extends BlockStairs> a() {
        return a;
    }

    private static VoxelShape[] a(VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(i2 -> BlockStairs.a(i2, slabShape, nwCorner, neCorner, swCorner, seCorner)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape a(int bitfield, VoxelShape slabShape, VoxelShape nwCorner, VoxelShape neCorner, VoxelShape swCorner, VoxelShape seCorner) {
        VoxelShape voxelShape = slabShape;
        if ((bitfield & 1) != 0) {
            voxelShape = VoxelShapes.a(slabShape, nwCorner);
        }
        if ((bitfield & 2) != 0) {
            voxelShape = VoxelShapes.a(voxelShape, neCorner);
        }
        if ((bitfield & 4) != 0) {
            voxelShape = VoxelShapes.a(voxelShape, swCorner);
        }
        if ((bitfield & 8) != 0) {
            voxelShape = VoxelShapes.a(voxelShape, seCorner);
        }
        return voxelShape;
    }

    protected BlockStairs(IBlockData baseState, BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, EnumDirection.c)).b(c, BlockPropertyHalf.b)).b(d, BlockPropertyStairsShape.a)).b(e, false));
        this.K = baseState.b();
        this.I = baseState;
    }

    @Override
    protected boolean g_(IBlockData state) {
        return true;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return (state.c(c) == BlockPropertyHalf.a ? G : H)[J[this.q(state)]];
    }

    private int q(IBlockData state) {
        return state.c(d).ordinal() * 4 + state.c(b).e();
    }

    @Override
    public float e() {
        return this.K.e();
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        EnumDirection clickedFace = context.k();
        BlockPosition clickedPos = context.a();
        Fluid fluidState = context.q().b_(clickedPos);
        IBlockData blockState = (IBlockData)((IBlockData)((IBlockData)this.m().b(b, context.g())).b(c, !(clickedFace == EnumDirection.a || clickedFace != EnumDirection.b && context.l().e - (double)clickedPos.v() > 0.5) ? BlockPropertyHalf.b : BlockPropertyHalf.a)).b(e, fluidState.a() == FluidTypes.c);
        return (IBlockData)blockState.b(d, BlockStairs.e(blockState, context.q(), clickedPos));
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(e).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return direction.o().d() ? (IBlockData)state.b(d, BlockStairs.e(state, level, pos)) : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    private static BlockPropertyStairsShape e(IBlockData state, IBlockAccess level, BlockPosition pos) {
        EnumDirection direction2;
        EnumDirection direction1;
        EnumDirection direction = state.c(b);
        IBlockData blockState = level.a_(pos.a(direction));
        if (BlockStairs.o(blockState) && state.c(c) == blockState.c(c) && (direction1 = blockState.c(b)).o() != state.c(b).o() && BlockStairs.c(state, level, pos, direction1.g())) {
            if (direction1 == direction.i()) {
                return BlockPropertyStairsShape.d;
            }
            return BlockPropertyStairsShape.e;
        }
        IBlockData blockState1 = level.a_(pos.a(direction.g()));
        if (BlockStairs.o(blockState1) && state.c(c) == blockState1.c(c) && (direction2 = blockState1.c(b)).o() != state.c(b).o() && BlockStairs.c(state, level, pos, direction2)) {
            if (direction2 == direction.i()) {
                return BlockPropertyStairsShape.b;
            }
            return BlockPropertyStairsShape.c;
        }
        return BlockPropertyStairsShape.a;
    }

    private static boolean c(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection face) {
        IBlockData blockState = level.a_(pos.a(face));
        return !BlockStairs.o(blockState) || blockState.c(b) != state.c(b) || blockState.c(c) != state.c(c);
    }

    public static boolean o(IBlockData state) {
        return state.b() instanceof BlockStairs;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rot) {
        return (IBlockData)state.b(b, rot.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        EnumDirection direction = state.c(b);
        BlockPropertyStairsShape stairsShape = state.c(d);
        switch (mirror) {
            case b: {
                if (direction.o() != EnumDirection.EnumAxis.c) break;
                switch (stairsShape) {
                    case b: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.c);
                    }
                    case c: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.b);
                    }
                    case d: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.e);
                    }
                    case e: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.d);
                    }
                }
                return state.a(EnumBlockRotation.c);
            }
            case c: {
                if (direction.o() != EnumDirection.EnumAxis.a) break;
                switch (stairsShape) {
                    case b: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.b);
                    }
                    case c: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.c);
                    }
                    case d: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.e);
                    }
                    case e: {
                        return (IBlockData)state.a(EnumBlockRotation.c).b(d, BlockPropertyStairsShape.d);
                    }
                    case a: {
                        return state.a(EnumBlockRotation.c);
                    }
                }
            }
        }
        return super.a(state, mirror);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(e) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }
}

