/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public abstract class BlockSprawling
extends Block {
    private static final EnumDirection[] a = EnumDirection.values();
    public static final BlockStateBoolean b = BlockProperties.O;
    public static final BlockStateBoolean c = BlockProperties.P;
    public static final BlockStateBoolean d = BlockProperties.Q;
    public static final BlockStateBoolean e = BlockProperties.R;
    public static final BlockStateBoolean f = BlockProperties.M;
    public static final BlockStateBoolean g = BlockProperties.N;
    public static final Map<EnumDirection, BlockStateBoolean> h = ImmutableMap.copyOf((Map)SystemUtils.a(Maps.newEnumMap(EnumDirection.class), (? super T map) -> {
        map.put(EnumDirection.c, b);
        map.put(EnumDirection.f, c);
        map.put(EnumDirection.d, d);
        map.put(EnumDirection.e, e);
        map.put(EnumDirection.b, f);
        map.put(EnumDirection.a, g);
    }));
    protected final VoxelShape[] i;

    protected BlockSprawling(float apothem, BlockBase.Info properties) {
        super(properties);
        this.i = this.a(apothem);
    }

    protected abstract MapCodec<? extends BlockSprawling> a();

    private VoxelShape[] a(float apothem) {
        float f2 = 0.5f - apothem;
        float f1 = 0.5f + apothem;
        VoxelShape voxelShape = Block.a(f2 * 16.0f, f2 * 16.0f, f2 * 16.0f, f1 * 16.0f, f1 * 16.0f, f1 * 16.0f);
        VoxelShape[] voxelShapes = new VoxelShape[a.length];
        for (int i2 = 0; i2 < a.length; ++i2) {
            EnumDirection direction = a[i2];
            voxelShapes[i2] = VoxelShapes.a(0.5 + Math.min((double)(-apothem), (double)direction.j() * 0.5), 0.5 + Math.min((double)(-apothem), (double)direction.k() * 0.5), 0.5 + Math.min((double)(-apothem), (double)direction.l() * 0.5), 0.5 + Math.max((double)apothem, (double)direction.j() * 0.5), 0.5 + Math.max((double)apothem, (double)direction.k() * 0.5), 0.5 + Math.max((double)apothem, (double)direction.l() * 0.5));
        }
        VoxelShape[] voxelShapes1 = new VoxelShape[64];
        for (int i1 = 0; i1 < 64; ++i1) {
            VoxelShape voxelShape1 = voxelShape;
            for (int i2 = 0; i2 < a.length; ++i2) {
                if ((i1 & 1 << i2) == 0) continue;
                voxelShape1 = VoxelShapes.a(voxelShape1, voxelShapes[i2]);
            }
            voxelShapes1[i1] = voxelShape1;
        }
        return voxelShapes1;
    }

    @Override
    protected boolean e_(IBlockData state) {
        return false;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.i[this.o(state)];
    }

    protected int o(IBlockData state) {
        int i2 = 0;
        for (int i1 = 0; i1 < a.length; ++i1) {
            if (!((Boolean)state.c(h.get(a[i1]))).booleanValue()) continue;
            i2 |= 1 << i1;
        }
        return i2;
    }
}

