/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockSoil
extends Block {
    public static final MapCodec<BlockSoil> a = BlockSoil.b(BlockSoil::new);
    public static final BlockStateInteger b = BlockProperties.aT;
    protected static final VoxelShape c = Block.a(0.0, 0.0, 0.0, 16.0, 15.0, 16.0);
    public static final int d = 7;

    public MapCodec<BlockSoil> a() {
        return a;
    }

    protected BlockSoil(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.F.b().b(b, 0));
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (direction == EnumDirection.b && !state.a(level, pos)) {
            scheduledTickAccess.a(pos, this, 1);
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos.d());
        return !blockState.e() || blockState.b() instanceof BlockFenceGate || blockState.b() instanceof BlockPistonMoving;
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return !this.m().a((IWorldReader)context.q(), context.a()) ? Blocks.j.m() : super.a(context);
    }

    @Override
    protected boolean g_(IBlockData state) {
        return true;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return c;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (!state.a((IWorldReader)level, pos)) {
            BlockSoil.a(null, state, level, pos);
        }
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        int moistureValue = state.c(b);
        if (moistureValue > 0 && level.paperConfig().tickRates.wetFarmland != 1 && (level.paperConfig().tickRates.wetFarmland < 1 || (MinecraftServer.currentTick + pos.hashCode()) % level.paperConfig().tickRates.wetFarmland != 0)) {
            return;
        }
        if (moistureValue == 0 && level.paperConfig().tickRates.dryFarmland != 1 && (level.paperConfig().tickRates.dryFarmland < 1 || (MinecraftServer.currentTick + pos.hashCode()) % level.paperConfig().tickRates.dryFarmland != 0)) {
            return;
        }
        if (!BlockSoil.a(level, pos) && !level.r(pos.d())) {
            if (moistureValue > 0) {
                CraftEventFactory.handleMoistureChangeEvent(level, pos, (IBlockData)state.b(b, moistureValue - 1), 2);
            } else if (!BlockSoil.a((IBlockAccess)level, pos)) {
                BlockSoil.a(null, state, level, pos);
            }
        } else if (moistureValue < 7) {
            CraftEventFactory.handleMoistureChangeEvent(level, pos, (IBlockData)state.b(b, 7), 2);
        }
    }

    @Override
    public void a(World level, IBlockData state, BlockPosition pos, net.minecraft.world.entity.Entity entity, float fallDistance) {
        super.a(level, state, pos, entity, fallDistance);
        if (level instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)level;
            if (level.A.i() < fallDistance - 0.5f && entity instanceof EntityLiving && (entity instanceof EntityHuman || serverLevel.O().b(GameRules.c)) && entity.dq() * entity.dq() * entity.dr() > 0.512f) {
                PlayerInteractEvent cancellable;
                if (entity instanceof EntityHuman) {
                    cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
                } else {
                    cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), level.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()));
                    level.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) {
                    return;
                }
                if (!CraftEventFactory.callEntityChangeBlockEvent(entity, pos, Blocks.j.m())) {
                    return;
                }
                BlockSoil.a(entity, state, level, pos);
            }
        }
    }

    public static void a(@Nullable net.minecraft.world.entity.Entity entity, IBlockData state, World level, BlockPosition pos) {
        if (entity == null && CraftEventFactory.callBlockFadeEvent(level, pos, Blocks.j.m()).isCancelled()) {
            return;
        }
        IBlockData blockState = BlockSoil.a(state, Blocks.j.m(), level, pos);
        level.b(pos, blockState);
        level.a(GameEvent.c, pos, GameEvent.a.a(entity, blockState));
    }

    private static boolean a(IBlockAccess level, BlockPosition pos) {
        return level.a_(pos.d()).a(TagsBlock.cA);
    }

    private static boolean a(IWorldReader level, BlockPosition pos) {
        int xOff = pos.u();
        int yOff = pos.v();
        int zOff = pos.w();
        for (int dz = -4; dz <= 4; ++dz) {
            int z2 = dz + zOff;
            for (int dx = -4; dx <= 4; ++dx) {
                int x2 = xOff + dx;
                for (int dy = 0; dy <= 1; ++dy) {
                    int y2 = dy + yOff;
                    Chunk chunk = (Chunk)level.a(x2 >> 4, z2 >> 4);
                    Fluid fluid = chunk.getBlockStateFinal(x2, y2, z2).y();
                    if (!fluid.a(TagsFluid.a)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }
}

