/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockShulkerBox
extends BlockTileEntity {
    public static final MapCodec<BlockShulkerBox> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumColor.q.optionalFieldOf("color").forGetter(shulkerBoxBlock -> Optional.ofNullable(shulkerBoxBlock.m)), BlockShulkerBox.t()).apply((Applicative)instance, (optional, properties) -> new BlockShulkerBox(optional.orElse(null), (BlockBase.Info)properties)));
    private static final IChatBaseComponent d = IChatBaseComponent.c("container.shulkerBox.unknownContents");
    private static final float e = 1.0f;
    private static final VoxelShape f = Block.a(0.0, 15.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape g = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);
    private static final VoxelShape h = Block.a(0.0, 0.0, 0.0, 1.0, 16.0, 16.0);
    private static final VoxelShape i = Block.a(15.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape j = Block.a(0.0, 0.0, 0.0, 16.0, 16.0, 1.0);
    private static final VoxelShape k = Block.a(0.0, 0.0, 15.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, VoxelShape> l = SystemUtils.a(Maps.newEnumMap(EnumDirection.class), (? super T map) -> {
        map.put(EnumDirection.c, j);
        map.put(EnumDirection.f, i);
        map.put(EnumDirection.d, k);
        map.put(EnumDirection.e, h);
        map.put(EnumDirection.b, f);
        map.put(EnumDirection.a, g);
    });
    public static final BlockStateEnum<EnumDirection> b = BlockDirectional.a;
    public static final MinecraftKey c = MinecraftKey.b("contents");
    @Nullable
    public final EnumColor m;

    public MapCodec<BlockShulkerBox> a() {
        return a;
    }

    public BlockShulkerBox(@Nullable EnumColor color, BlockBase.Info properties) {
        super(properties);
        this.m = color;
        this.l((IBlockData)this.F.b().b(b, EnumDirection.b));
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityShulkerBox(this.m, pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return BlockShulkerBox.a(blockEntityType, TileEntityTypes.y, TileEntityShulkerBox::a);
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (level instanceof WorldServer) {
            TileEntityShulkerBox shulkerBoxBlockEntity;
            WorldServer serverLevel = (WorldServer)level;
            TileEntity tileEntity = level.c_(pos);
            if (tileEntity instanceof TileEntityShulkerBox && BlockShulkerBox.a(state, level, pos, shulkerBoxBlockEntity = (TileEntityShulkerBox)tileEntity) && player.a(shulkerBoxBlockEntity).isPresent()) {
                player.a(StatisticList.aq);
                PiglinAI.a(serverLevel, player, true);
            }
        }
        return EnumInteractionResult.a;
    }

    private static boolean a(IBlockData state, World level, BlockPosition pos, TileEntityShulkerBox blockEntity) {
        if (blockEntity.k() != TileEntityShulkerBox.AnimationPhase.a) {
            return true;
        }
        AxisAlignedBB aabb = EntityShulker.a(1.0f, state.c(b), 0.0f, 0.5f, pos.c()).h(1.0E-6);
        return level.b(aabb);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return (IBlockData)this.m().b(b, context.k());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{b});
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox shulkerBoxBlockEntity = (TileEntityShulkerBox)blockEntity;
            if (!level.C && player.b() && !shulkerBoxBlockEntity.c()) {
                ItemStack coloredItemStack = BlockShulkerBox.b(this.b());
                coloredItemStack.b(blockEntity.q());
                EntityItem itemEntity = new EntityItem(level, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, coloredItemStack);
                itemEntity.s();
                level.b(itemEntity);
            } else {
                shulkerBoxBlockEntity.unpackLootTable(player, true);
            }
        }
        return super.a(level, pos, state, player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<ItemStack> a(IBlockData state, LootParams.a params) {
        TileEntity blockEntity = params.b(LootContextParameters.h);
        Runnable reAdd = null;
        if (blockEntity instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox shulkerBoxBlockEntity = (TileEntityShulkerBox)blockEntity;
            if (shulkerBoxBlockEntity.lootableData().getLastFill() != -1L || !params.a().paperConfig().lootables.retainUnlootedShulkerBoxLootTableOnNonPlayerBreak) {
                ResourceKey<LootTable> lootTableResourceKey = shulkerBoxBlockEntity.aw_();
                reAdd = () -> shulkerBoxBlockEntity.a(lootTableResourceKey);
                shulkerBoxBlockEntity.a((ResourceKey<LootTable>)null);
            }
            params = params.a(c, (Consumer<ItemStack> output) -> {
                for (int i2 = 0; i2 < shulkerBoxBlockEntity.b(); ++i2) {
                    output.accept(shulkerBoxBlockEntity.a(i2));
                }
            });
        }
        try {
            List<ItemStack> list = super.a(state, params);
            return list;
        }
        finally {
            if (reAdd != null) {
                reAdd.run();
            }
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData newState, boolean isMoving) {
        if (!state.a(newState.b())) {
            TileEntity blockEntity = level.c_(pos);
            super.a(state, level, pos, newState, isMoving);
            if (blockEntity instanceof TileEntityShulkerBox) {
                level.c(pos, state.b());
            }
        }
    }

    @Override
    public void a(ItemStack stack, Item.b context, List<IChatBaseComponent> tooltipComponents, TooltipFlag tooltipFlag) {
        super.a(stack, context, tooltipComponents, tooltipFlag);
        if (stack.b(DataComponents.ap)) {
            tooltipComponents.add(d);
        }
        int i2 = 0;
        int i1 = 0;
        for (ItemStack itemStack : stack.a(DataComponents.al, ItemContainerContents.a).d()) {
            ++i1;
            if (i2 > 4) continue;
            ++i2;
            tooltipComponents.add(IChatBaseComponent.a("container.shulkerBox.itemCount", itemStack.y(), itemStack.M()));
        }
        if (i1 - i2 > 0) {
            tooltipComponents.add(IChatBaseComponent.a("container.shulkerBox.more", i1 - i2).a(EnumChatFormat.u));
        }
    }

    @Override
    protected VoxelShape b_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        TileEntityShulkerBox shulkerBoxBlockEntity;
        TileEntity tileEntity = level.c_(pos);
        return tileEntity instanceof TileEntityShulkerBox && !(shulkerBoxBlockEntity = (TileEntityShulkerBox)tileEntity).t() ? l.get(state.c(b).g()) : VoxelShapes.b();
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        VoxelShape voxelShape;
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TileEntityShulkerBox) {
            TileEntityShulkerBox shulkerBoxBlockEntity = (TileEntityShulkerBox)tileEntity;
            voxelShape = VoxelShapes.a(shulkerBoxBlockEntity.a(state));
        } else {
            voxelShape = VoxelShapes.b();
        }
        return voxelShape;
    }

    @Override
    protected boolean e_(IBlockData state) {
        return false;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData blockState, World level, BlockPosition pos) {
        return Container.a(level.c_(pos));
    }

    public static Block a(@Nullable EnumColor color) {
        if (color == null) {
            return Blocks.lr;
        }
        return switch (color) {
            default -> throw new MatchException(null, null);
            case EnumColor.a -> Blocks.ls;
            case EnumColor.b -> Blocks.lt;
            case EnumColor.c -> Blocks.lu;
            case EnumColor.d -> Blocks.lv;
            case EnumColor.e -> Blocks.lw;
            case EnumColor.f -> Blocks.lx;
            case EnumColor.g -> Blocks.ly;
            case EnumColor.h -> Blocks.lz;
            case EnumColor.i -> Blocks.lA;
            case EnumColor.j -> Blocks.lB;
            case EnumColor.l -> Blocks.lD;
            case EnumColor.m -> Blocks.lE;
            case EnumColor.n -> Blocks.lF;
            case EnumColor.o -> Blocks.lG;
            case EnumColor.p -> Blocks.lH;
            case EnumColor.k -> Blocks.lC;
        };
    }

    @Nullable
    public EnumColor b() {
        return this.m;
    }

    public static ItemStack b(@Nullable EnumColor color) {
        return new ItemStack(BlockShulkerBox.a(color));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rot) {
        return (IBlockData)state.b(b, rot.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }
}

