/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.grower.WorldGenTreeProvider;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R3.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R3.util.CraftLocation;
import org.bukkit.event.Event;
import org.bukkit.event.world.StructureGrowEvent;

public class BlockSapling
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockSapling> e = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WorldGenTreeProvider.a.fieldOf("tree").forGetter(saplingBlock -> saplingBlock.i), BlockSapling.t()).apply((Applicative)instance, BlockSapling::new));
    public static final BlockStateInteger f = BlockProperties.aX;
    protected static final float g = 6.0f;
    protected static final VoxelShape h = Block.a(2.0, 0.0, 2.0, 14.0, 12.0, 14.0);
    protected final WorldGenTreeProvider i;
    public static TreeType treeType;

    public MapCodec<? extends BlockSapling> a() {
        return e;
    }

    protected BlockSapling(WorldGenTreeProvider treeGrower, BlockBase.Info properties) {
        super(properties);
        this.i = treeGrower;
        this.l((IBlockData)this.F.b().b(f, 0));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return h;
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (level.A(pos.d()) >= 9 && random.i() < (float)level.spigotConfig.saplingModifier / 700.0f) {
            this.a(level, pos, state, random);
        }
    }

    public void a(WorldServer level, BlockPosition pos, IBlockData state, RandomSource random) {
        if (state.c(f) == 0) {
            level.a(pos, (IBlockData)state.a(f), 4);
        } else if (level.captureTreeGeneration) {
            this.i.a(level, level.m().g(), pos, state, random);
        } else {
            level.captureTreeGeneration = true;
            this.i.a(level, level.m().g(), pos, state, random);
            level.captureTreeGeneration = false;
            if (!level.capturedBlockStates.isEmpty()) {
                TreeType treeType = BlockSapling.treeType;
                BlockSapling.treeType = null;
                Location location = CraftLocation.toBukkit(pos, (org.bukkit.World)level.getWorld());
                ArrayList<CraftBlockState> blocks = new ArrayList<CraftBlockState>(level.capturedBlockStates.values());
                level.capturedBlockStates.clear();
                StructureGrowEvent event = null;
                if (treeType != null) {
                    event = new StructureGrowEvent(location, treeType, false, null, blocks);
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event == null || !event.isCancelled()) {
                    for (BlockState blockState : blocks) {
                        CapturedBlockState.setBlockState(blockState);
                        level.checkCapturedTreeStateForObserverNotify(pos, (CraftBlockState)blockState);
                    }
                }
            }
        }
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return (double)level.A.i() < 0.45;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        this.a(level, pos, state, random);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{f});
    }
}

