/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.ArrayDeque;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BaseTorchBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.PluginManager;

public class BlockRedstoneTorch
extends BaseTorchBlock {
    public static final MapCodec<BlockRedstoneTorch> c = BlockRedstoneTorch.b(BlockRedstoneTorch::new);
    public static final BlockStateBoolean d = BlockProperties.v;
    public static final int e = 60;
    public static final int f = 8;
    public static final int g = 160;
    private static final int i = 2;

    public MapCodec<? extends BlockRedstoneTorch> a() {
        return c;
    }

    protected BlockRedstoneTorch(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)this.F.b().b(d, true));
    }

    @Override
    protected void b(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean isMoving) {
        this.b(level, pos, state);
    }

    private void b(World level, BlockPosition pos, IBlockData state) {
        Orientation orientation = this.a(level, state);
        for (EnumDirection direction : EnumDirection.values()) {
            level.a(pos.a(direction), (Block)this, ExperimentalRedstoneUtils.a(orientation, direction));
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData newState, boolean isMoving) {
        if (!isMoving) {
            this.b(level, pos, state);
        }
    }

    @Override
    protected int a(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return blockState.c(d) != false && EnumDirection.b != side ? 15 : 0;
    }

    protected boolean a(World level, BlockPosition pos, IBlockData state) {
        return level.b(pos.e(), EnumDirection.a);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        boolean hasNeighborSignal = this.a((World)level, pos, state);
        ArrayDeque<RedstoneUpdateInfo> redstoneUpdateInfos = level.redstoneUpdateInfos;
        if (redstoneUpdateInfos != null) {
            RedstoneUpdateInfo curr;
            while ((curr = redstoneUpdateInfos.peek()) != null && level.ad() - curr.b > 60L) {
                redstoneUpdateInfos.poll();
            }
        }
        PluginManager manager = level.getCraftServer().getPluginManager();
        org.bukkit.block.Block block = level.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
        int oldCurrent = state.c(d) != false ? 15 : 0;
        BlockRedstoneEvent event = new BlockRedstoneEvent(block, oldCurrent, oldCurrent);
        if (state.c(d).booleanValue()) {
            if (hasNeighborSignal) {
                if (oldCurrent != 0) {
                    event.setNewCurrent(0);
                    manager.callEvent((Event)event);
                    if (event.getNewCurrent() != 0) {
                        return;
                    }
                }
                level.a(pos, (IBlockData)state.b(d, false), 3);
                if (BlockRedstoneTorch.a((World)level, pos, true)) {
                    level.c(1502, pos, 0);
                    level.a(pos, level.a_(pos).b(), 160);
                }
            }
        } else if (!hasNeighborSignal && !BlockRedstoneTorch.a((World)level, pos, false)) {
            if (oldCurrent != 15) {
                event.setNewCurrent(15);
                manager.callEvent((Event)event);
                if (event.getNewCurrent() != 15) {
                    return;
                }
            }
            level.a(pos, (IBlockData)state.b(d, true), 3);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (state.c(d).booleanValue() == this.a(level, pos, state) && !level.U().b(pos, this)) {
            level.a(pos, (Block)this, 2);
        }
    }

    @Override
    protected int b(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return side == EnumDirection.a ? blockState.a(blockAccess, pos, side) : 0;
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        if (state.c(d).booleanValue()) {
            double d2 = (double)pos.u() + 0.5 + (random.j() - 0.5) * 0.2;
            double d1 = (double)pos.v() + 0.7 + (random.j() - 0.5) * 0.2;
            double d22 = (double)pos.w() + 0.5 + (random.j() - 0.5) * 0.2;
            level.a(ParticleParamRedstone.b, d2, d1, d22, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{d});
    }

    private static boolean a(World level, BlockPosition pos, boolean logToggle) {
        ArrayDeque<RedstoneUpdateInfo> list = level.redstoneUpdateInfos;
        if (list == null) {
            list = level.redstoneUpdateInfos = new ArrayDeque();
        }
        if (logToggle) {
            list.add(new RedstoneUpdateInfo(pos.j(), level.ad()));
        }
        int i2 = 0;
        for (RedstoneUpdateInfo toggle : list) {
            if (!toggle.a.equals(pos) || ++i2 < 8) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected Orientation a(World level, IBlockData state) {
        return ExperimentalRedstoneUtils.a(level, null, EnumDirection.b);
    }

    public static class RedstoneUpdateInfo {
        final BlockPosition a;
        final long b;

        public RedstoneUpdateInfo(BlockPosition pos, long when) {
            this.a = pos;
            this.b = when;
        }
    }
}

