/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPressurePlateAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BlockPressurePlateWeighted
extends BlockPressurePlateAbstract {
    public static final MapCodec<BlockPressurePlateWeighted> e = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)1, (int)1024).fieldOf("max_weight").forGetter(weightedPressurePlateBlock -> weightedPressurePlateBlock.g), (App)BlockSetType.a.fieldOf("block_set_type").forGetter(weightedPressurePlateBlock -> weightedPressurePlateBlock.d), BlockPressurePlateWeighted.t()).apply((Applicative)instance, BlockPressurePlateWeighted::new));
    public static final BlockStateInteger f = BlockProperties.aW;
    private final int g;

    public MapCodec<BlockPressurePlateWeighted> a() {
        return e;
    }

    protected BlockPressurePlateWeighted(int maxWeight, BlockSetType type, BlockBase.Info properties) {
        super(properties, type);
        this.l((IBlockData)this.F.b().b(f, 0));
        this.g = maxWeight;
    }

    @Override
    protected int b(World level, BlockPosition pos) {
        int min = 0;
        for (net.minecraft.world.entity.Entity entity : BlockPressurePlateWeighted.getEntities(level, BlockPressurePlateAbstract.c.a(pos), net.minecraft.world.entity.Entity.class)) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, pos, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), level.getWorld().getBlockAt(pos.u(), pos.v(), pos.w()));
                level.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) continue;
            ++min;
        }
        if ((min = Math.min(min, this.g)) > 0) {
            float f2 = (float)Math.min(this.g, min) / (float)this.g;
            return MathHelper.f(f2 * 15.0f);
        }
        return 0;
    }

    @Override
    protected int h(IBlockData state) {
        return state.c(f);
    }

    @Override
    protected IBlockData a(IBlockData state, int strength) {
        return (IBlockData)state.b(f, strength);
    }

    @Override
    protected int b() {
        return 10;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{f});
    }
}

