/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPressurePlateAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.PluginManager;

public class BlockPressurePlateBinary
extends BlockPressurePlateAbstract {
    public static final MapCodec<BlockPressurePlateBinary> e = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(pressurePlate -> pressurePlate.d), BlockPressurePlateBinary.t()).apply((Applicative)instance, BlockPressurePlateBinary::new));
    public static final BlockStateBoolean f = BlockProperties.B;

    public MapCodec<BlockPressurePlateBinary> a() {
        return e;
    }

    protected BlockPressurePlateBinary(BlockSetType type, BlockBase.Info properties) {
        super(properties, type);
        this.l((IBlockData)this.F.b().b(f, false));
    }

    @Override
    protected int h(IBlockData state) {
        return state.c(f) != false ? 15 : 0;
    }

    @Override
    protected IBlockData a(IBlockData state, int strength) {
        return (IBlockData)state.b(f, strength > 0);
    }

    @Override
    protected int b(World level, BlockPosition pos) {
        Class<net.minecraft.world.entity.Entity> clazz = switch (this.d.f()) {
            default -> throw new MatchException(null, null);
            case BlockSetType.a.a -> net.minecraft.world.entity.Entity.class;
            case BlockSetType.a.b -> EntityLiving.class;
        };
        for (net.minecraft.world.entity.Entity entity : BlockPressurePlateBinary.getEntities(level, BlockPressurePlateAbstract.c.a(pos), clazz)) {
            if (this.h(level.a_(pos)) == 0) {
                PlayerInteractEvent cancellable;
                CraftWorld bworld = level.getWorld();
                PluginManager manager = level.getCraftServer().getPluginManager();
                if (entity instanceof EntityHuman) {
                    EntityHuman player = (EntityHuman)entity;
                    cancellable = CraftEventFactory.callPlayerInteractEvent(player, Action.PHYSICAL, pos, null, null, null);
                } else {
                    cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), bworld.getBlockAt(pos.u(), pos.v(), pos.w()));
                    manager.callEvent((Event)((EntityInteractEvent)cancellable));
                }
                if (cancellable.isCancelled()) continue;
            }
            return 15;
        }
        return 0;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{f});
    }
}

