/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.plugin.PluginManager;

public abstract class BlockPressurePlateAbstract
extends Block {
    protected static final VoxelShape a = Block.a(1.0, 0.0, 1.0, 15.0, 0.5, 15.0);
    protected static final VoxelShape b = Block.a(1.0, 0.0, 1.0, 15.0, 1.0, 15.0);
    protected static final AxisAlignedBB c = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.25, 0.9375);
    protected final BlockSetType d;

    protected BlockPressurePlateAbstract(BlockBase.Info properties, BlockSetType type) {
        super(properties.a(type.g()));
        this.d = type;
    }

    protected abstract MapCodec<? extends BlockPressurePlateAbstract> a();

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.h(state) > 0 ? a : b;
    }

    protected int b() {
        return 20;
    }

    @Override
    public boolean a(IBlockData state) {
        return true;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return direction == EnumDirection.a && !state.a(level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        return BlockPressurePlateAbstract.c(level, blockPos) || BlockPressurePlateAbstract.a(level, blockPos, EnumDirection.b);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        int signalForState = this.h(state);
        if (signalForState > 0) {
            this.a(null, (World)level, pos, state, signalForState);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        int signalForState;
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (!level.C && (signalForState = this.h(state)) == 0) {
            this.a(entity, level, pos, state, signalForState);
        }
    }

    private void a(@Nullable net.minecraft.world.entity.Entity entity, World level, BlockPosition pos, IBlockData state, int currentSignal) {
        int signalStrength = this.b(level, pos);
        boolean flag = currentSignal > 0;
        boolean flag1 = signalStrength > 0;
        CraftWorld bworld = level.getWorld();
        PluginManager manager = level.getCraftServer().getPluginManager();
        if (flag != flag1) {
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bworld.getBlockAt(pos.u(), pos.v(), pos.w()), currentSignal, signalStrength);
            manager.callEvent((Event)eventRedstone);
            flag1 = eventRedstone.getNewCurrent() > 0;
            signalStrength = eventRedstone.getNewCurrent();
        }
        if (currentSignal != signalStrength) {
            IBlockData blockState = this.a(state, signalStrength);
            level.a(pos, blockState, 2);
            this.a(level, pos);
            level.b(pos, state, blockState);
        }
        if (!flag1 && flag) {
            level.a(null, pos, this.d.l(), SoundCategory.e);
            level.a(entity, GameEvent.e, pos);
        } else if (flag1 && !flag) {
            level.a(null, pos, this.d.m(), SoundCategory.e);
            level.a(entity, GameEvent.a, pos);
        }
        if (flag1) {
            level.a(new BlockPosition(pos), (Block)this, this.b());
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData newState, boolean isMoving) {
        if (!isMoving && !state.a(newState.b())) {
            if (this.h(state) > 0) {
                this.a(level, pos);
            }
            super.a(state, level, pos, newState, isMoving);
        }
    }

    protected void a(World level, BlockPosition pos) {
        level.a(pos, this);
        level.a(pos.e(), this);
    }

    @Override
    protected int a(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return this.h(blockState);
    }

    @Override
    protected int b(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return side == EnumDirection.b ? this.h(blockState) : 0;
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    protected static int a(World level, AxisAlignedBB box, Class<? extends net.minecraft.world.entity.Entity> entityClass) {
        return BlockPressurePlateAbstract.getEntities(level, box, entityClass).size();
    }

    protected static <T extends net.minecraft.world.entity.Entity> List<T> getEntities(World level, AxisAlignedBB box, Class<T> entityClass) {
        return level.a(entityClass, box, IEntitySelector.f.and(entity -> !entity.s_()));
    }

    protected abstract int b(World var1, BlockPosition var2);

    protected abstract int h(IBlockData var1);

    protected abstract IBlockData a(IBlockData var1, int var2);
}

