/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;

public class BlockPoweredRail
extends BlockMinecartTrackAbstract {
    public static final MapCodec<BlockPoweredRail> d = BlockPoweredRail.b(BlockPoweredRail::new);
    public static final BlockStateEnum<BlockPropertyTrackPosition> e = BlockProperties.ak;
    public static final BlockStateBoolean f = BlockProperties.B;

    public MapCodec<BlockPoweredRail> a() {
        return d;
    }

    protected BlockPoweredRail(BlockBase.Info properties) {
        super(true, properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(e, BlockPropertyTrackPosition.a)).b(f, false)).b(BlockMinecartTrackAbstract.c, false));
    }

    protected boolean a(World level, BlockPosition pos, IBlockData state, boolean searchForward, int recursionCount) {
        if (recursionCount >= 8) {
            return false;
        }
        int x2 = pos.u();
        int y2 = pos.v();
        int z2 = pos.w();
        boolean flag = true;
        BlockPropertyTrackPosition railShape = state.c(e);
        switch (railShape) {
            case a: {
                if (searchForward) {
                    ++z2;
                    break;
                }
                --z2;
                break;
            }
            case b: {
                if (searchForward) {
                    --x2;
                    break;
                }
                ++x2;
                break;
            }
            case c: {
                if (searchForward) {
                    --x2;
                } else {
                    ++x2;
                    ++y2;
                    flag = false;
                }
                railShape = BlockPropertyTrackPosition.b;
                break;
            }
            case d: {
                if (searchForward) {
                    --x2;
                    ++y2;
                    flag = false;
                } else {
                    ++x2;
                }
                railShape = BlockPropertyTrackPosition.b;
                break;
            }
            case e: {
                if (searchForward) {
                    ++z2;
                } else {
                    --z2;
                    ++y2;
                    flag = false;
                }
                railShape = BlockPropertyTrackPosition.a;
                break;
            }
            case f: {
                if (searchForward) {
                    ++z2;
                    ++y2;
                    flag = false;
                } else {
                    --z2;
                }
                railShape = BlockPropertyTrackPosition.a;
            }
        }
        return this.a(level, new BlockPosition(x2, y2, z2), searchForward, recursionCount, railShape) || flag && this.a(level, new BlockPosition(x2, y2 - 1, z2), searchForward, recursionCount, railShape);
    }

    protected boolean a(World level, BlockPosition state, boolean searchForward, int recursionCount, BlockPropertyTrackPosition shape) {
        IBlockData blockState = level.a_(state);
        if (!blockState.a(this)) {
            return false;
        }
        BlockPropertyTrackPosition railShape = blockState.c(e);
        return (shape != BlockPropertyTrackPosition.b || railShape != BlockPropertyTrackPosition.a && railShape != BlockPropertyTrackPosition.e && railShape != BlockPropertyTrackPosition.f) && (shape != BlockPropertyTrackPosition.a || railShape != BlockPropertyTrackPosition.b && railShape != BlockPropertyTrackPosition.c && railShape != BlockPropertyTrackPosition.d) && blockState.c(f) != false && (level.C(state) || this.a(level, state, blockState, searchForward, recursionCount + 1));
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block block) {
        boolean flag;
        boolean poweredValue = state.c(f);
        boolean bl = flag = level.C(pos) || this.a(level, pos, state, true, 0) || this.a(level, pos, state, false, 0);
        if (flag != poweredValue) {
            int power = flag ? 15 : 0;
            int newPower = CraftEventFactory.callRedstoneChange(level, pos, power, 15 - power).getNewCurrent();
            if (newPower == power) {
                return;
            }
            level.a(pos, (IBlockData)state.b(f, flag), 3);
            level.a(pos.e(), this);
            if (state.c(e).b()) {
                level.a(pos.d(), this);
            }
        }
    }

    @Override
    public IBlockState<BlockPropertyTrackPosition> c() {
        return e;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rot) {
        switch (rot) {
            case c: {
                switch (state.c(e)) {
                    case c: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.d);
                    }
                    case d: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.c);
                    }
                    case e: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.f);
                    }
                    case f: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.e);
                    }
                    case g: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.i);
                    }
                    case h: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.j);
                    }
                    case i: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.g);
                    }
                    case j: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.h);
                    }
                }
            }
            case d: {
                switch (state.c(e)) {
                    case a: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.b);
                    }
                    case b: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.a);
                    }
                    case c: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.e);
                    }
                    case d: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.f);
                    }
                    case e: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.d);
                    }
                    case f: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.c);
                    }
                    case g: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.j);
                    }
                    case h: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.g);
                    }
                    case i: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.h);
                    }
                    case j: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.i);
                    }
                }
            }
            case b: {
                switch (state.c(e)) {
                    case a: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.b);
                    }
                    case b: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.a);
                    }
                    case c: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.f);
                    }
                    case d: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.e);
                    }
                    case e: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.c);
                    }
                    case f: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.d);
                    }
                    case g: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.h);
                    }
                    case h: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.i);
                    }
                    case i: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.j);
                    }
                    case j: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.g);
                    }
                }
            }
        }
        return state;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        BlockPropertyTrackPosition railShape = state.c(e);
        block0 : switch (mirror) {
            case b: {
                switch (railShape) {
                    case e: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.f);
                    }
                    case f: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.e);
                    }
                    case g: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.j);
                    }
                    case h: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.i);
                    }
                    case i: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.h);
                    }
                    case j: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.g);
                    }
                }
                return super.a(state, mirror);
            }
            case c: {
                switch (railShape) {
                    case c: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.d);
                    }
                    case d: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.c);
                    }
                    default: {
                        break block0;
                    }
                    case g: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.h);
                    }
                    case h: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.g);
                    }
                    case i: {
                        return (IBlockData)state.b(e, BlockPropertyTrackPosition.j);
                    }
                    case j: 
                }
                return (IBlockData)state.b(e, BlockPropertyTrackPosition.i);
            }
        }
        return super.a(state, mirror);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(e, f, BlockMinecartTrackAbstract.c);
    }
}

