/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPlant;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.TreeType;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;

public class BlockMushroom
extends BlockPlant
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockMushroom> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.a(Registries.aL).fieldOf("feature").forGetter(mushroomBlock -> mushroomBlock.d), BlockMushroom.t()).apply((Applicative)instance, BlockMushroom::new));
    protected static final float b = 3.0f;
    protected static final VoxelShape c = Block.a(5.0, 0.0, 5.0, 11.0, 6.0, 11.0);
    private final ResourceKey<WorldGenFeatureConfigured<?, ?>> d;

    public MapCodec<BlockMushroom> a() {
        return a;
    }

    public BlockMushroom(ResourceKey<WorldGenFeatureConfigured<?, ?>> feature, BlockBase.Info properties) {
        super(properties);
        this.d = feature;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return c;
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (random.i() < (float)level.spigotConfig.mushroomModifier / 2500.0f) {
            int i2 = 5;
            int i1 = 4;
            for (BlockPosition blockPos : BlockPosition.c(pos.b(-4, -1, -4), pos.b(4, 1, 4))) {
                if (!level.a_(blockPos).a(this) || --i2 > 0) continue;
                return;
            }
            BlockPosition blockPos1 = pos.b(random.a(3) - 1, random.a(2) - random.a(2), random.a(3) - 1);
            BlockPosition sourcePos = pos;
            for (int i22 = 0; i22 < 4; ++i22) {
                if (level.u(blockPos1) && state.a((IWorldReader)level, blockPos1)) {
                    pos = blockPos1;
                }
                blockPos1 = pos.b(random.a(3) - 1, random.a(2) - random.a(2), random.a(3) - 1);
            }
            if (level.u(blockPos1) && state.a((IWorldReader)level, blockPos1)) {
                CraftEventFactory.handleBlockSpreadEvent(level, sourcePos, blockPos1, state, 2);
            }
        }
    }

    @Override
    protected boolean b(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return state.s();
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        IBlockData blockState = level.a_(blockPos);
        return blockState.a(TagsBlock.bc) || level.b(pos, 0) < 13 && this.b(blockState, level, blockPos);
    }

    public boolean a(WorldServer level, BlockPosition pos, IBlockData state, RandomSource random) {
        Optional optional = level.K_().e(Registries.aL).a(this.d);
        if (optional.isEmpty()) {
            return false;
        }
        level.a(pos, false);
        TreeType treeType = BlockSapling.treeType = this == Blocks.cm ? TreeType.BROWN_MUSHROOM : TreeType.RED_MUSHROOM;
        if (((WorldGenFeatureConfigured)((Holder)optional.get()).a()).a(level, level.m().g(), random, pos)) {
            return true;
        }
        level.a(pos, state, 3);
        return false;
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return (double)random.i() < 0.4;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        this.a(level, pos, state, random);
    }
}

