/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class BlockMonsterEggs
extends Block {
    public static final MapCodec<BlockMonsterEggs> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.e.q().fieldOf("host").forGetter(BlockMonsterEggs::b), BlockMonsterEggs.t()).apply((Applicative)instance, BlockMonsterEggs::new));
    private final Block b;
    private static final Map<Block, Block> c = Maps.newIdentityHashMap();
    private static final Map<IBlockData, IBlockData> d = Maps.newIdentityHashMap();
    private static final Map<IBlockData, IBlockData> e = Maps.newIdentityHashMap();

    public MapCodec<? extends BlockMonsterEggs> a() {
        return a;
    }

    public BlockMonsterEggs(Block hostBlock, BlockBase.Info properties) {
        super(properties.e(hostBlock.x() / 2.0f).f(0.75f));
        this.b = hostBlock;
        c.put(hostBlock, this);
    }

    public Block b() {
        return this.b;
    }

    public static boolean o(IBlockData state) {
        return c.containsKey(state.b());
    }

    private void a(WorldServer level, BlockPosition pos) {
        EntitySilverfish silverfish = EntityTypes.bd.a(level, EntitySpawnReason.k);
        if (silverfish != null) {
            silverfish.b((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, 0.0f, 0.0f);
            level.addFreshEntity(silverfish, CreatureSpawnEvent.SpawnReason.SILVERFISH_BLOCK);
            silverfish.V();
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, ItemStack stack, boolean dropExperience) {
        super.a(state, level, pos, stack, dropExperience);
        if (level.O().b(GameRules.h) && !EnchantmentManager.a(stack, EnchantmentTags.t)) {
            this.a(level, pos);
        }
    }

    public static IBlockData p(IBlockData host) {
        return BlockMonsterEggs.a(d, host, () -> c.get(host.b()).m());
    }

    public IBlockData q(IBlockData infested) {
        return BlockMonsterEggs.a(e, infested, () -> this.b().m());
    }

    private static IBlockData a(Map<IBlockData, IBlockData> stateMap, IBlockData state, Supplier<IBlockData> supplier) {
        return stateMap.computeIfAbsent(state, blockState -> {
            IBlockData blockState1 = (IBlockData)supplier.get();
            for (IBlockState<?> property : blockState.F()) {
                blockState1 = blockState1.b(property) ? (IBlockData)blockState1.b(property, blockState.c(property)) : blockState1;
            }
            return blockState1;
        });
    }
}

