/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockLever
extends BlockAttachable {
    public static final MapCodec<BlockLever> a = BlockLever.b(BlockLever::new);
    public static final BlockStateBoolean b = BlockProperties.B;
    protected static final int c = 6;
    protected static final int d = 6;
    protected static final int e = 8;
    protected static final VoxelShape f = Block.a(5.0, 4.0, 10.0, 11.0, 12.0, 16.0);
    protected static final VoxelShape g = Block.a(5.0, 4.0, 0.0, 11.0, 12.0, 6.0);
    protected static final VoxelShape h = Block.a(10.0, 4.0, 5.0, 16.0, 12.0, 11.0);
    protected static final VoxelShape i = Block.a(0.0, 4.0, 5.0, 6.0, 12.0, 11.0);
    protected static final VoxelShape j = Block.a(5.0, 0.0, 4.0, 11.0, 6.0, 12.0);
    protected static final VoxelShape k = Block.a(4.0, 0.0, 5.0, 12.0, 6.0, 11.0);
    protected static final VoxelShape l = Block.a(5.0, 10.0, 4.0, 11.0, 16.0, 12.0);
    protected static final VoxelShape m = Block.a(4.0, 10.0, 5.0, 12.0, 16.0, 11.0);

    public MapCodec<BlockLever> a() {
        return a;
    }

    protected BlockLever(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(BlockFacingHorizontal.aF, EnumDirection.c)).b(b, false)).b(BlockAttachable.L, BlockPropertyAttachPosition.b));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        switch (state.c(BlockAttachable.L)) {
            case a: {
                switch (state.c(BlockFacingHorizontal.aF).o()) {
                    case a: {
                        return k;
                    }
                }
                return j;
            }
            case b: {
                switch (state.c(BlockFacingHorizontal.aF)) {
                    case f: {
                        return i;
                    }
                    case e: {
                        return h;
                    }
                    case d: {
                        return g;
                    }
                }
                return f;
            }
        }
        switch (state.c(BlockFacingHorizontal.aF).o()) {
            case a: {
                return m;
            }
        }
        return l;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (level.C) {
            IBlockData blockState = (IBlockData)state.a(b);
            if (blockState.c(b).booleanValue()) {
                BlockLever.a(blockState, (GeneratorAccess)level, pos, 1.0f);
            }
        } else {
            boolean powered = state.c(b);
            org.bukkit.block.Block block = level.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
            level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (eventRedstone.getNewCurrent() > 0 != !powered) {
                return EnumInteractionResult.a;
            }
            this.b(state, level, pos, null);
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, Explosion explosion, BiConsumer<ItemStack, BlockPosition> dropConsumer) {
        if (explosion.g()) {
            this.b(state, (World)level, pos, null);
        }
        super.a(state, level, pos, explosion, dropConsumer);
    }

    public void b(IBlockData state, World level, BlockPosition pos, @Nullable EntityHuman player) {
        state = (IBlockData)state.a(b);
        level.a(pos, state, 3);
        this.e(state, level, pos);
        BlockLever.a(player, (GeneratorAccess)level, pos, state);
        level.a((Entity)player, state.c(b) != false ? GameEvent.a : GameEvent.e, pos);
    }

    protected static void a(@Nullable EntityHuman player, GeneratorAccess level, BlockPosition pos, IBlockData state) {
        float f2 = state.c(b) != false ? 0.6f : 0.5f;
        level.a(player, pos, SoundEffects.os, SoundCategory.e, 0.3f, f2);
    }

    private static void a(IBlockData state, GeneratorAccess level, BlockPosition pos, float alpha) {
        EnumDirection opposite = state.c(BlockFacingHorizontal.aF).g();
        EnumDirection opposite1 = BlockLever.n(state).g();
        double d2 = (double)pos.u() + 0.5 + 0.1 * (double)opposite.j() + 0.2 * (double)opposite1.j();
        double d1 = (double)pos.v() + 0.5 + 0.1 * (double)opposite.k() + 0.2 * (double)opposite1.k();
        double d22 = (double)pos.w() + 0.5 + 0.1 * (double)opposite.l() + 0.2 * (double)opposite1.l();
        level.a(new ParticleParamRedstone(0xFF0000, alpha), d2, d1, d22, 0.0, 0.0, 0.0);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        if (state.c(b).booleanValue() && random.i() < 0.25f) {
            BlockLever.a(state, (GeneratorAccess)level, pos, 0.5f);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData newState, boolean isMoving) {
        if (!isMoving && !state.a(newState.b())) {
            if (state.c(b).booleanValue()) {
                this.e(state, level, pos);
            }
            super.a(state, level, pos, newState, isMoving);
        }
    }

    @Override
    protected int a(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return blockState.c(b) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return blockState.c(b) != false && BlockLever.n(blockState) == side ? 15 : 0;
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    private void e(IBlockData state, World level, BlockPosition pos) {
        EnumDirection opposite;
        Orientation orientation = ExperimentalRedstoneUtils.a(level, opposite, (opposite = BlockLever.n(state).g()).o().d() ? EnumDirection.b : state.c(BlockFacingHorizontal.aF));
        level.a(pos, (Block)this, orientation);
        level.a(pos.a(opposite), (Block)this, orientation);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockAttachable.L, BlockFacingHorizontal.aF, b);
    }
}

