/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.player.PlayerInsertLecternBookEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.inventory.ItemStack;

public class BlockLectern
extends BlockTileEntity {
    public static final MapCodec<BlockLectern> a = BlockLectern.b(BlockLectern::new);
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.aF;
    public static final BlockStateBoolean c = BlockProperties.B;
    public static final BlockStateBoolean d = BlockProperties.s;
    public static final VoxelShape e = Block.a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    public static final VoxelShape f = Block.a(4.0, 2.0, 4.0, 12.0, 14.0, 12.0);
    public static final VoxelShape g = VoxelShapes.a(e, f);
    public static final VoxelShape h = Block.a(0.0, 15.0, 0.0, 16.0, 15.0, 16.0);
    public static final VoxelShape i = VoxelShapes.a(g, h);
    public static final VoxelShape j = VoxelShapes.a(Block.a(1.0, 10.0, 0.0, 5.333333, 14.0, 16.0), Block.a(5.333333, 12.0, 0.0, 9.666667, 16.0, 16.0), Block.a(9.666667, 14.0, 0.0, 14.0, 18.0, 16.0), g);
    public static final VoxelShape k = VoxelShapes.a(Block.a(0.0, 10.0, 1.0, 16.0, 14.0, 5.333333), Block.a(0.0, 12.0, 5.333333, 16.0, 16.0, 9.666667), Block.a(0.0, 14.0, 9.666667, 16.0, 18.0, 14.0), g);
    public static final VoxelShape l = VoxelShapes.a(Block.a(10.666667, 10.0, 0.0, 15.0, 14.0, 16.0), Block.a(6.333333, 12.0, 0.0, 10.666667, 16.0, 16.0), Block.a(2.0, 14.0, 0.0, 6.333333, 18.0, 16.0), g);
    public static final VoxelShape m = VoxelShapes.a(Block.a(0.0, 10.0, 10.666667, 16.0, 14.0, 15.0), Block.a(0.0, 12.0, 6.333333, 16.0, 16.0, 10.666667), Block.a(0.0, 14.0, 2.0, 16.0, 18.0, 6.333333), g);
    private static final int n = 2;

    public MapCodec<BlockLectern> a() {
        return a;
    }

    protected BlockLectern(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.F.b().b(b, EnumDirection.c)).b(c, false)).b(d, false));
    }

    @Override
    protected VoxelShape d_(IBlockData state) {
        return g;
    }

    @Override
    protected boolean g_(IBlockData state) {
        return true;
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        CustomData customData;
        World level = context.q();
        net.minecraft.world.item.ItemStack itemInHand = context.n();
        EntityHuman player = context.o();
        boolean flag = false;
        if (!level.C && player != null && player.gG() && (customData = itemInHand.a(DataComponents.Y, CustomData.a)).a("Book")) {
            flag = true;
        }
        return (IBlockData)((IBlockData)this.m().b(b, context.g().g())).b(d, flag);
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return i;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        switch (state.c(b)) {
            case c: {
                return k;
            }
            case d: {
                return m;
            }
            case f: {
                return l;
            }
            case e: {
                return j;
            }
        }
        return g;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityLectern(pos, state);
    }

    public static boolean a(@Nullable EntityLiving entity, World level, BlockPosition pos, IBlockData state, net.minecraft.world.item.ItemStack stack) {
        if (!state.c(d).booleanValue()) {
            if (!level.C) {
                BlockLectern.b(entity, level, pos, state, stack);
            }
            return true;
        }
        return false;
    }

    private static void b(@Nullable EntityLiving entity, World level, BlockPosition pos, IBlockData state, net.minecraft.world.item.ItemStack stack) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof TileEntityLectern) {
            TileEntityLectern lecternBlockEntity = (TileEntityLectern)tileEntity;
            net.minecraft.world.item.ItemStack eventSourcedBookStack = null;
            if (entity instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entity;
                PlayerInsertLecternBookEvent event = new PlayerInsertLecternBookEvent((Player)serverPlayer.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos), (ItemStack)CraftItemStack.asCraftMirror(stack.c(1)));
                if (!event.callEvent()) {
                    return;
                }
                eventSourcedBookStack = CraftItemStack.unwrap(event.getBook());
            }
            if (eventSourcedBookStack == null) {
                eventSourcedBookStack = stack.b(1, entity);
            } else {
                stack.a(1, entity);
            }
            lecternBlockEntity.b(eventSourcedBookStack);
            BlockLectern.a((Entity)entity, level, pos, state, true);
            level.a(null, pos, SoundEffects.cz, SoundCategory.e, 1.0f, 1.0f);
        }
    }

    public static void a(@Nullable Entity entity, World level, BlockPosition pos, IBlockData state, boolean hasBook) {
        IBlockData blockState = (IBlockData)((IBlockData)state.b(c, false)).b(d, hasBook);
        level.a(pos, blockState, 3);
        level.a(GameEvent.c, pos, GameEvent.a.a(entity, blockState));
        BlockLectern.b(level, pos, state);
    }

    public static void a(World level, BlockPosition pos, IBlockData state) {
        BlockLectern.a(level, pos, state, true);
        level.a(pos, state.b(), 2);
        level.c(1043, pos, 0);
    }

    private static void a(World level, BlockPosition pos, IBlockData state, boolean powered) {
        BlockRedstoneEvent event;
        int targetRedstoneLevel;
        int currentRedstoneLevel = state.c(c) != false ? 15 : 0;
        int n2 = targetRedstoneLevel = powered ? 15 : 0;
        if (currentRedstoneLevel != targetRedstoneLevel && (event = CraftEventFactory.callRedstoneChange(level, pos, currentRedstoneLevel, targetRedstoneLevel)).getNewCurrent() != targetRedstoneLevel) {
            return;
        }
        level.a(pos, (IBlockData)state.b(c, powered), 3);
        BlockLectern.b(level, pos, state);
    }

    private static void b(World level, BlockPosition pos, IBlockData state) {
        Orientation orientation = ExperimentalRedstoneUtils.a(level, state.c(b).g(), EnumDirection.b);
        level.a(pos.e(), state.b(), orientation);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        BlockLectern.a((World)level, pos, state, false);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData newState, boolean isMoving) {
        if (!state.a(newState.b())) {
            if (state.c(d).booleanValue()) {
                this.e(state, level, pos);
            }
            super.a(state, level, pos, newState, isMoving);
            if (state.c(c).booleanValue()) {
                BlockLectern.b(level, pos, state);
            }
        }
    }

    private void e(IBlockData state, World level, BlockPosition pos) {
        TileEntity tileEntity = level.getBlockEntity(pos, false);
        if (tileEntity instanceof TileEntityLectern) {
            TileEntityLectern lecternBlockEntity = (TileEntityLectern)tileEntity;
            EnumDirection direction = state.c(b);
            net.minecraft.world.item.ItemStack itemStack = lecternBlockEntity.b().v();
            if (itemStack.f()) {
                return;
            }
            float f2 = 0.25f * (float)direction.j();
            float f1 = 0.25f * (float)direction.l();
            EntityItem itemEntity = new EntityItem(level, (double)pos.u() + 0.5 + (double)f2, pos.v() + 1, (double)pos.w() + 0.5 + (double)f1, itemStack);
            itemEntity.s();
            level.b(itemEntity);
            lecternBlockEntity.a();
        }
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return blockState.c(c) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return side == EnumDirection.b && blockState.c(c) != false ? 15 : 0;
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData blockState, World level, BlockPosition pos) {
        TileEntity blockEntity;
        if (blockState.c(d).booleanValue() && (blockEntity = level.c_(pos)) instanceof TileEntityLectern) {
            return ((TileEntityLectern)blockEntity).j();
        }
        return 0;
    }

    @Override
    protected EnumInteractionResult a(net.minecraft.world.item.ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        if (state.c(d).booleanValue()) {
            return EnumInteractionResult.f;
        }
        if (stack.a(TagsItem.aY)) {
            return (EnumInteractionResult)((Object)(BlockLectern.a(player, level, pos, state, stack) ? EnumInteractionResult.a : EnumInteractionResult.e));
        }
        return (EnumInteractionResult)((Object)(stack.f() && hand == EnumHand.a ? EnumInteractionResult.e : EnumInteractionResult.f));
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        if (state.c(d).booleanValue()) {
            if (!level.C) {
                this.a(level, pos, player);
            }
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.c;
    }

    @Override
    @Nullable
    public ITileInventory b(IBlockData state, World level, BlockPosition pos) {
        return state.c(d) == false ? null : super.b(state, level, pos);
    }

    private void a(World level, BlockPosition pos, EntityHuman player) {
        TileEntityLectern lecternBlockEntity;
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityLectern && player.a(lecternBlockEntity = (TileEntityLectern)blockEntity).isPresent()) {
            player.a(StatisticList.au);
        }
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }
}

