/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.entity.Entity;

public class BlockHopper
extends BlockTileEntity {
    public static final MapCodec<BlockHopper> a = BlockHopper.b(BlockHopper::new);
    public static final BlockStateEnum<EnumDirection> b = BlockProperties.T;
    public static final BlockStateBoolean c = BlockProperties.j;
    private static final VoxelShape d = Block.a(0.0, 10.0, 0.0, 16.0, 16.0, 16.0);
    private static final VoxelShape e = Block.a(4.0, 4.0, 4.0, 12.0, 10.0, 12.0);
    private static final VoxelShape f = VoxelShapes.a(e, d);
    private static final VoxelShape g = BlockHopper.a(2.0, 11.0, 2.0, 14.0, 16.0, 14.0);
    private static final VoxelShape h = VoxelShapes.a(f, g, OperatorBoolean.e);
    private static final VoxelShape i = VoxelShapes.a(h, Block.a(6.0, 0.0, 6.0, 10.0, 4.0, 10.0));
    private static final VoxelShape j = VoxelShapes.a(h, Block.a(12.0, 4.0, 6.0, 16.0, 8.0, 10.0));
    private static final VoxelShape k = VoxelShapes.a(h, Block.a(6.0, 4.0, 0.0, 10.0, 8.0, 4.0));
    private static final VoxelShape l = VoxelShapes.a(h, Block.a(6.0, 4.0, 12.0, 10.0, 8.0, 16.0));
    private static final VoxelShape m = VoxelShapes.a(h, Block.a(0.0, 4.0, 6.0, 4.0, 8.0, 10.0));
    private static final VoxelShape n = g;
    private static final VoxelShape o = VoxelShapes.a(g, Block.a(12.0, 8.0, 6.0, 16.0, 10.0, 10.0));
    private static final VoxelShape G = VoxelShapes.a(g, Block.a(6.0, 8.0, 0.0, 10.0, 10.0, 4.0));
    private static final VoxelShape H = VoxelShapes.a(g, Block.a(6.0, 8.0, 12.0, 10.0, 10.0, 16.0));
    private static final VoxelShape I = VoxelShapes.a(g, Block.a(0.0, 8.0, 6.0, 4.0, 10.0, 10.0));

    public MapCodec<BlockHopper> a() {
        return a;
    }

    public BlockHopper(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)this.F.b().b(b, EnumDirection.a)).b(c, true));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        switch (state.c(b)) {
            case a: {
                return i;
            }
            case c: {
                return k;
            }
            case d: {
                return l;
            }
            case e: {
                return m;
            }
            case f: {
                return j;
            }
        }
        return h;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos) {
        switch (state.c(b)) {
            case a: {
                return n;
            }
            case c: {
                return G;
            }
            case d: {
                return H;
            }
            case e: {
                return I;
            }
            case f: {
                return o;
            }
        }
        return g;
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        EnumDirection opposite = context.k().g();
        return (IBlockData)((IBlockData)this.m().b(b, opposite.o() == EnumDirection.EnumAxis.b ? EnumDirection.a : opposite)).b(c, true);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new TileEntityHopper(pos, state);
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return level.C ? null : BlockHopper.a(blockEntityType, TileEntityTypes.s, TileEntityHopper::a);
    }

    @Override
    protected void b(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean isMoving) {
        if (!oldState.a(state.b())) {
            this.a(level, pos, state);
        }
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntityHopper hopperBlockEntity;
        TileEntity tileEntity;
        if (!level.C && (tileEntity = level.c_(pos)) instanceof TileEntityHopper && player.a(hopperBlockEntity = (TileEntityHopper)tileEntity).isPresent()) {
            player.a(StatisticList.ad);
        }
        return EnumInteractionResult.a;
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        this.a(level, pos, state);
    }

    private void a(World level, BlockPosition pos, IBlockData state) {
        boolean flag;
        boolean bl = flag = !level.C(pos);
        if (flag != state.c(c)) {
            level.a(pos, (IBlockData)state.b(c, flag), 2);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData newState, boolean isMoving) {
        InventoryUtils.a(state, newState, level, pos);
        super.a(state, level, pos, newState, isMoving);
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData blockState, World level, BlockPosition pos) {
        return Container.a(level.c_(pos));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c);
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        TileEntity blockEntity = level.c_(pos);
        if (blockEntity instanceof TileEntityHopper) {
            TileEntityHopper.a(level, pos, state, entity, (TileEntityHopper)blockEntity);
        }
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }
}

