/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockSoulFire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityCombustByBlockEvent;

public abstract class BlockFireAbstract
extends Block {
    private static final int c = 8;
    private static final int d = 1;
    private static final int e = 3;
    private final float f;
    protected static final float a = 1.0f;
    protected static final VoxelShape b = Block.a(0.0, 0.0, 0.0, 16.0, 1.0, 16.0);

    public BlockFireAbstract(BlockBase.Info properties, float fireDamage) {
        super(properties);
        this.f = fireDamage;
    }

    protected abstract MapCodec<? extends BlockFireAbstract> a();

    @Override
    public IBlockData a(BlockActionContext context) {
        return BlockFireAbstract.a(context.q(), context.a());
    }

    public static IBlockData a(IBlockAccess reader, BlockPosition pos) {
        BlockPosition blockPos = pos.e();
        IBlockData blockState = reader.a_(blockPos);
        return BlockSoulFire.o(blockState) ? Blocks.cz.m() : ((BlockFire)Blocks.cy).b(reader, pos);
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return b;
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        block12: {
            block11: {
                double d2;
                double d1;
                double d3;
                int i2;
                BlockPosition blockPos;
                IBlockData blockState;
                if (random.a(24) == 0) {
                    level.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.jt, SoundCategory.e, 1.0f + random.i(), random.i() * 0.7f + 0.3f, false);
                }
                if (this.g(blockState = level.a_(blockPos = pos.e())) || blockState.c((IBlockAccess)level, blockPos, EnumDirection.b)) break block11;
                if (this.g(level.a_(pos.h()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d3 = (double)pos.u() + random.j() * (double)0.1f;
                        d1 = (double)pos.v() + random.j();
                        d2 = (double)pos.w() + random.j();
                        level.a(Particles.Z, d3, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.g(level.a_(pos.i()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d3 = (double)(pos.u() + 1) - random.j() * (double)0.1f;
                        d1 = (double)pos.v() + random.j();
                        d2 = (double)pos.w() + random.j();
                        level.a(Particles.Z, d3, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.g(level.a_(pos.f()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d3 = (double)pos.u() + random.j();
                        d1 = (double)pos.v() + random.j();
                        d2 = (double)pos.w() + random.j() * (double)0.1f;
                        level.a(Particles.Z, d3, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (this.g(level.a_(pos.g()))) {
                    for (i2 = 0; i2 < 2; ++i2) {
                        d3 = (double)pos.u() + random.j();
                        d1 = (double)pos.v() + random.j();
                        d2 = (double)(pos.w() + 1) - random.j() * (double)0.1f;
                        level.a(Particles.Z, d3, d1, d2, 0.0, 0.0, 0.0);
                    }
                }
                if (!this.g(level.a_(pos.d()))) break block12;
                for (i2 = 0; i2 < 2; ++i2) {
                    d3 = (double)pos.u() + random.j();
                    d1 = (double)(pos.v() + 1) - random.j() * (double)0.1f;
                    d2 = (double)pos.w() + random.j();
                    level.a(Particles.Z, d3, d1, d2, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            for (int i3 = 0; i3 < 3; ++i3) {
                double d4 = (double)pos.u() + random.j();
                double d1 = (double)pos.v() + random.j() * 0.5 + 0.5;
                double d2 = (double)pos.w() + random.j();
                level.a(Particles.Z, d4, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    protected abstract boolean g(IBlockData var1);

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (org.bukkit.block.Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (!entity.bi()) {
            if (entity.aG() < 0) {
                entity.h(entity.aG() + 1);
            } else if (entity instanceof EntityPlayer) {
                int randomInt = level.H_().b(1, 3);
                entity.h(entity.aG() + randomInt);
            }
            if (entity.aG() >= 0) {
                EntityCombustByBlockEvent event = new EntityCombustByBlockEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), (Entity)entity.getBukkitEntity(), 8.0f);
                level.getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    entity.igniteForSeconds(event.getDuration(), false);
                } else {
                    entity.h(entity.aG() - 1);
                }
            }
        }
        entity.a(level.ak().a(), this.f);
        super.a(state, level, pos, entity);
    }

    @Override
    protected void onPlace(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean isMoving, ItemActionContext context) {
        if (!oldState.a(state.b())) {
            Optional<BlockPortalShape> optional;
            if (BlockFireAbstract.a(level) && (optional = BlockPortalShape.a(level, pos, EnumDirection.EnumAxis.a)).isPresent()) {
                optional.get().createPortalBlocks(level, context == null ? null : context.o());
                return;
            }
            if (!state.a((IWorldReader)level, pos)) {
                this.fireExtinguished(level, pos);
            }
        }
    }

    private static boolean a(World level) {
        return level.getTypeKey() == WorldDimension.b || level.getTypeKey() == WorldDimension.c;
    }

    @Override
    protected void a(World level, EntityHuman player, BlockPosition pos, IBlockData state) {
    }

    @Override
    public IBlockData a(World level, BlockPosition pos, IBlockData state, EntityHuman player) {
        if (!level.B_()) {
            level.a(null, 1009, pos, 0);
        }
        return super.a(level, pos, state, player);
    }

    public static boolean a(World level, BlockPosition pos, EnumDirection direction) {
        IBlockData blockState = level.a_(pos);
        return blockState.l() && (BlockFireAbstract.a(level, pos).a((IWorldReader)level, pos) || BlockFireAbstract.b(level, pos, direction));
    }

    private static boolean b(World level, BlockPosition pos, EnumDirection direction) {
        if (!BlockFireAbstract.a(level)) {
            return false;
        }
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        boolean flag = false;
        for (EnumDirection direction1 : EnumDirection.values()) {
            if (!level.a_(mutableBlockPos.g(pos).c(direction1)).a(Blocks.cv)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        EnumDirection.EnumAxis axis = direction.o().d() ? direction.i().o() : EnumDirection.EnumDirectionLimit.a.b(level.A);
        return BlockPortalShape.a(level, pos, axis).isPresent();
    }

    protected void fireExtinguished(GeneratorAccess world, BlockPosition position) {
        if (!CraftEventFactory.callBlockFadeEvent(world, position, Blocks.a.m()).isCancelled()) {
            world.a(position, false);
        }
    }
}

